/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.client.extended.run.RunOperations;
import java.io.InputStream;
import java.net.URL;
import okhttp3.OkHttpClient;

public class AutoAdaptableKubernetesClient
extends DefaultKubernetesClient {
    private KubernetesClient delegate;

    public AutoAdaptableKubernetesClient() {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient());
    }

    public AutoAdaptableKubernetesClient(OkHttpClient httpClient, Config config) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(httpClient, config));
    }

    public AutoAdaptableKubernetesClient(Config config) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(config));
    }

    public AutoAdaptableKubernetesClient(String masterUrl) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(masterUrl));
    }

    public static KubernetesClient adapt(KubernetesClient initial) {
        KubernetesClient result = initial;
        for (ExtensionAdapter<KubernetesClient> adapter : Adapters.list(KubernetesClient.class)) {
            if (!adapter.isAdaptable(result).booleanValue()) continue;
            result = adapter.adapt(result);
        }
        return result;
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new AutoAdaptableKubernetesClient(this.httpClient, updated);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.delegate.admissionRegistration();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.delegate.authorization();
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.delegate.discovery();
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.delegate.network();
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.delegate.storage();
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.delegate.batch();
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.delegate.policy();
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.delegate.rbac();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s2) {
        return this.delegate.resourceList(s2);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s2) {
        return this.delegate.resource(s2);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public RunOperations run() {
        return this.delegate.run();
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        return this.delegate.isAdaptable(type);
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }
}

