/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.maplibre.style.Style;
import org.apache.baremaps.maplibre.style.StyleSource;
import org.apache.baremaps.maplibre.tileset.Tileset;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"Init configuration files."})
public class Init
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Init.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"A style file."})
    private Path style;
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"A tileset file."})
    private Path tileset;

    @Override
    public Integer call() throws Exception {
        if (this.style == null && this.tileset == null) {
            logger.info("No configuration file specified.");
            return 0;
        }
        if (this.style != null) {
            Style styleObject = new Style();
            styleObject.setName("Baremaps");
            StyleSource sources = new StyleSource();
            sources.setType("vector");
            sources.setUrl("http://localhost:9000/tiles.json");
            styleObject.setSources(Map.of("baremaps", sources));
            Files.write(this.style, ObjectMapperUtils.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)styleObject), new OpenOption[0]);
            logger.info("Style initialized: {}", (Object)this.style);
        }
        if (this.tileset != null) {
            Tileset tilesetObject = new Tileset();
            tilesetObject.setTilejson("2.2.0");
            tilesetObject.setName("Baremaps");
            tilesetObject.setTiles(Arrays.asList("http://localhost:9000/tiles.json"));
            Files.write(this.tileset, ObjectMapperUtils.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)tilesetObject), new OpenOption[0]);
            logger.info("Tileset initialized: {}", (Object)this.tileset);
        }
        return 0;
    }
}

