/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Level;
import com.j256.ormlite.logger.LogBackend;
import com.j256.ormlite.logger.LogBackendFactory;
import java.util.logging.Logger;

public class JavaUtilLogBackend
implements LogBackend {
    private final Logger logger;

    public JavaUtilLogBackend(String className) {
        this.logger = Logger.getLogger(className);
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        return this.logger.isLoggable(this.levelToJavaLevel(level));
    }

    @Override
    public void log(Level level, String msg) {
        this.logger.log(this.levelToJavaLevel(level), msg);
    }

    @Override
    public void log(Level level, String msg, Throwable throwable) {
        this.logger.log(this.levelToJavaLevel(level), msg, throwable);
    }

    private java.util.logging.Level levelToJavaLevel(Level level) {
        switch (level) {
            case TRACE: {
                return java.util.logging.Level.FINER;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case WARNING: {
                return java.util.logging.Level.WARNING;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
            case FATAL: {
                return java.util.logging.Level.SEVERE;
            }
        }
        return java.util.logging.Level.INFO;
    }

    public static class JavaUtilLogBackendFactory
    implements LogBackendFactory {
        @Override
        public LogBackend createLogBackend(String classLabel) {
            return new JavaUtilLogBackend(classLabel);
        }
    }
}

