/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.nga.crs.util.proj.ProjParser;
import mil.nga.crs.wkt.WKTUtils;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.GeoPackageManager;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.SQLUtils;
import mil.nga.geopackage.db.master.SQLiteMaster;
import mil.nga.geopackage.db.master.SQLiteMasterColumn;
import mil.nga.geopackage.db.master.SQLiteMasterQuery;
import mil.nga.geopackage.db.master.SQLiteMasterType;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.db.table.TableInfo;
import mil.nga.geopackage.dgiwg.DGIWGGeoPackage;
import mil.nga.geopackage.dgiwg.DGIWGValidationErrors;
import mil.nga.geopackage.dgiwg.GeoPackageFileName;
import mil.nga.geopackage.extension.rtree.RTreeIndexExtension;
import mil.nga.geopackage.extension.rtree.RTreeIndexTableDao;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.geopackage.io.SQLExecAlterTable;
import mil.nga.geopackage.io.SQLExecResult;
import mil.nga.geopackage.io.TileReproject;
import mil.nga.geopackage.property.GeoPackageJavaProperties;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.tiles.reproject.TileReprojection;
import mil.nga.geopackage.tiles.reproject.TileReprojectionOptimize;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.validate.GeoPackageValidate;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.GeometryTransform;

public class SQLExec {
    public static final String ARGUMENT_PREFIX = "-";
    public static final String ARGUMENT_MAX_ROWS = "m";
    public static final int DEFAULT_MAX_ROWS = 100;
    public static final String ARGUMENT_MAX_COLUMN_WIDTH = "w";
    public static final Integer DEFAULT_MAX_COLUMN_WIDTH = 120;
    public static final String ARGUMENT_MAX_LINES_PER_ROW = "l";
    public static final String ARGUMENT_DGIWG = "dgiwg";
    public static final Integer DEFAULT_MAX_LINES_PER_ROW = null;
    public static final Pattern HISTORY_PATTERN = Pattern.compile("^!-?\\d+$");
    public static final String COMMAND_PROMPT = "sql> ";
    public static final String COMMAND_HELP = "help";
    public static final String COMMAND_VERSION = "version";
    public static final String COMMAND_TABLES = "tables";
    public static final String COMMAND_INDEXES = "indexes";
    public static final String COMMAND_VIEWS = "views";
    public static final String COMMAND_TRIGGERS = "triggers";
    public static final int COMMAND_ALL_ROWS = 0x7FFFFFFE;
    public static final String COMMAND_HISTORY = "history";
    public static final String COMMAND_PREVIOUS = "!!";
    public static final String COMMAND_WRITE_BLOBS = "blobs";
    public static final String COMMAND_MAX_ROWS = "rows";
    public static final String COMMAND_MAX_COLUMN_WIDTH = "width";
    public static final String COMMAND_MAX_LINES_PER_ROW = "lines";
    public static final String COMMAND_TABLE_INFO = "info";
    public static final String COMMAND_COUNT = "count";
    public static final String COMMAND_VACUUM = "vacuum";
    public static final String COMMAND_FOREIGN_KEYS = "fk";
    public static final String COMMAND_FOREIGN_KEY_CHECK = "fkc";
    public static final String COMMAND_INTEGRITY_CHECK = "integrity";
    public static final String COMMAND_QUICK_CHECK = "quick";
    public static final String COMMAND_SQLITE_MASTER = "sqlite_master";
    public static final String COMMAND_CONTENTS = "contents";
    public static final String COMMAND_GEOPACKAGE_INFO = "ginfo";
    public static final String COMMAND_EXTENSIONS = "extensions";
    public static final String COMMAND_RTREE = "rtree";
    public static final String COMMAND_GEOMETRY = "geometry";
    public static final String COMMAND_REPROJECT = "reproject";
    public static final String COMMAND_DGIWG = "dgiwg";
    public static final String BLOB_DISPLAY_VALUE = "BLOB";
    public static final String BLOBS_WRITE_DEFAULT_DIRECTORY = "blobs";
    public static final String BLOBS_ARGUMENT_EXTENSION = "e";
    public static final String BLOBS_ARGUMENT_DIRECTORY = "d";
    public static final String BLOBS_ARGUMENT_PATTERN = "p";
    public static final String BLOBS_COLUMN_START_REGEX = "\\(";
    public static final String BLOBS_COLUMN_END_REGEX = "\\)";
    public static final String COMMAND_CONTENTS_BOUNDS = "cbounds";
    public static final String COMMAND_BOUNDS = "bounds";
    public static final String COMMAND_TABLE_BOUNDS = "tbounds";
    public static final String ARGUMENT_PROJECTION = "p";
    public static final String ARGUMENT_ZOOM_LEVELS = "z";
    public static final String ARGUMENT_BOUNDS_MANUAL = "m";
    public static final String ARGUMENT_RTREE_GEODESIC = "g";
    public static final String ARGUMENT_RTREE_DROP = "d";
    public static final Pattern BLOBS_COLUMN_PATTERN = Pattern.compile("\\(([^\\)]+)\\)");
    public static final int BLOBS_COLUMN_PATTERN_GROUP = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean valid = true;
        boolean requiredArguments = false;
        File sqliteFile = null;
        Integer maxRows = 100;
        Integer maxColumnWidth = DEFAULT_MAX_COLUMN_WIDTH;
        Integer maxLinesPerRow = DEFAULT_MAX_LINES_PER_ROW;
        StringBuilder sql = null;
        boolean dgiwg = false;
        for (int i = 0; valid && i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length()).toLowerCase()) {
                    case "m": {
                        if (i + 1 < args.length) {
                            String maxRowsString = args[++i];
                            try {
                                maxRows = Integer.valueOf(maxRowsString);
                            }
                            catch (NumberFormatException e) {
                                valid = false;
                                System.out.println("Error: Max Rows argument '" + arg + "' must be followed by a valid number. Invalid: " + maxRowsString);
                            }
                            maxRows = Math.max(0, maxRows);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Max Rows argument '" + arg + "' must be followed by a valid number");
                        break;
                    }
                    case "w": {
                        if (i + 1 < args.length) {
                            String maxColumnWidthString = args[++i];
                            try {
                                maxColumnWidth = Integer.valueOf(maxColumnWidthString);
                            }
                            catch (NumberFormatException e) {
                                valid = false;
                                System.out.println("Error: Max Column Width argument '" + arg + "' must be followed by a valid number. Invalid: " + maxColumnWidthString);
                            }
                            maxColumnWidth = Math.max(0, maxColumnWidth);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Max Column Width argument '" + arg + "' must be followed by a valid number");
                        break;
                    }
                    case "l": {
                        if (i + 1 < args.length) {
                            String maxLinesPerRowString = args[++i];
                            try {
                                maxLinesPerRow = Integer.valueOf(maxLinesPerRowString);
                            }
                            catch (NumberFormatException e) {
                                valid = false;
                                System.out.println("Error: Max Lines Per Row argument '" + arg + "' must be followed by a valid number. Invalid: " + maxLinesPerRowString);
                            }
                            maxLinesPerRow = Math.max(0, maxLinesPerRow);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Max Lines Per Row argument '" + arg + "' must be followed by a valid number");
                        break;
                    }
                    case "dgiwg": {
                        dgiwg = true;
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (sqliteFile == null) {
                sqliteFile = new File(arg);
                requiredArguments = true;
                continue;
            }
            if (sql == null) {
                sql = new StringBuilder(arg);
                continue;
            }
            sql.append(" ").append(arg);
        }
        if (!valid || !requiredArguments) {
            SQLExec.printUsage();
        } else {
            if (!GeoPackageManager.exists(sqliteFile)) {
                sqliteFile = GeoPackageManager.create(sqliteFile, false);
                boolean isGeoPackage = GeoPackageValidate.hasGeoPackageExtension((File)sqliteFile);
                System.out.println();
                System.out.print("Created new ");
                if (isGeoPackage) {
                    System.out.print("GeoPackage");
                } else {
                    System.out.print("database");
                }
                System.out.println(": " + sqliteFile.getPath());
            }
            try (GeoPackage database = GeoPackageManager.open(sqliteFile, false);){
                SQLExec.printInfo(database, maxRows, maxColumnWidth, maxLinesPerRow);
                File databaseFile = new File(database.getPath());
                System.out.println("Last Modified: " + new Date(databaseFile.lastModified()));
                if (dgiwg) {
                    SQLExec.dgiwg(database);
                }
                if (sql != null) {
                    try {
                        SQLExecResult result = SQLExec.executeSQL(database, sql.toString(), maxRows);
                        SQLExec.setPrintOptions(result, maxColumnWidth, maxLinesPerRow);
                        result.printResults();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                } else if (!dgiwg) {
                    SQLExec.commandPrompt(database, maxRows, maxColumnWidth, maxLinesPerRow);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commandPrompt(GeoPackage database, Integer maxRows, Integer maxColumnWidth, Integer maxLinesPerRow) {
        SQLExec.printHelp(database);
        ArrayList<String> history = new ArrayList<String>();
        try (Scanner scanner = new Scanner(System.in);){
            StringBuilder sqlBuilder = new StringBuilder();
            SQLExec.resetCommandPrompt(sqlBuilder);
            while (scanner.hasNextLine()) {
                try {
                    boolean singleLine;
                    boolean executeSql;
                    String sqlLine = scanner.nextLine().trim();
                    int semicolon = sqlLine.indexOf(";");
                    boolean bl = executeSql = semicolon >= 0;
                    if (executeSql) {
                        sqlLine = sqlLine.substring(0, semicolon + 1);
                    }
                    boolean bl2 = singleLine = sqlBuilder.length() == 0;
                    if (!sqlLine.isEmpty()) {
                        if (!singleLine) {
                            sqlBuilder.append(" ");
                        }
                        sqlBuilder.append(sqlLine);
                    }
                    if (singleLine) {
                        if (executeSql) {
                            sqlLine = sqlLine.substring(0, sqlLine.length() - 1).trim();
                        }
                        boolean command = true;
                        String sqlLineLower = sqlLine.toLowerCase();
                        if (sqlLine.isEmpty()) {
                            break;
                        }
                        if (sqlLine.equalsIgnoreCase(COMMAND_HELP)) {
                            SQLExec.printHelp(database);
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLine.equalsIgnoreCase(COMMAND_VERSION)) {
                            SQLExec.printVersion();
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLineLower.startsWith(COMMAND_TABLES)) {
                            String name = sqlLine.substring(COMMAND_TABLES.length(), sqlLine.length()).trim();
                            String sql = SQLExec.buildSqlMasterQuery(new SQLiteMasterColumn[]{SQLiteMasterColumn.NAME}, SQLiteMasterType.TABLE, name);
                            SQLExec.executeSQL(database, sqlBuilder, sql, (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                        } else if (sqlLineLower.startsWith(COMMAND_INDEXES)) {
                            String name = sqlLine.substring(COMMAND_INDEXES.length(), sqlLine.length()).trim();
                            String sql = SQLExec.buildSqlMasterQuery(new SQLiteMasterColumn[]{SQLiteMasterColumn.NAME, SQLiteMasterColumn.TBL_NAME}, SQLiteMasterType.INDEX, name);
                            SQLExec.executeSQL(database, sqlBuilder, sql, (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                        } else if (sqlLineLower.startsWith(COMMAND_VIEWS)) {
                            String name = sqlLine.substring(COMMAND_VIEWS.length(), sqlLine.length()).trim();
                            String sql = SQLExec.buildSqlMasterQuery(new SQLiteMasterColumn[]{SQLiteMasterColumn.NAME}, SQLiteMasterType.VIEW, name);
                            SQLExec.executeSQL(database, sqlBuilder, sql, (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                        } else if (sqlLineLower.startsWith(COMMAND_TRIGGERS)) {
                            String name = sqlLine.substring(COMMAND_TRIGGERS.length(), sqlLine.length()).trim();
                            String sql = SQLExec.buildSqlMasterQuery(new SQLiteMasterColumn[]{SQLiteMasterColumn.NAME, SQLiteMasterColumn.TBL_NAME}, SQLiteMasterType.TRIGGER, name);
                            SQLExec.executeSQL(database, sqlBuilder, sql, (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                        } else if (sqlLine.equalsIgnoreCase(COMMAND_HISTORY)) {
                            for (int i = 0; i < history.size(); ++i) {
                                System.out.println(" " + String.format("%4d", i + 1) + "  " + (String)history.get(i));
                            }
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLine.equalsIgnoreCase(COMMAND_PREVIOUS)) {
                            SQLExec.executeSQL(database, sqlBuilder, history.size(), maxRows, maxColumnWidth, maxLinesPerRow, history);
                        } else if (sqlLineLower.startsWith("blobs")) {
                            SQLExec.writeBlobs(database, sqlBuilder, maxRows, history, sqlLine.substring("blobs".length()));
                        } else if (HISTORY_PATTERN.matcher(sqlLine).matches()) {
                            int historyNumber = Integer.parseInt(sqlLine.substring(1, sqlLine.length()));
                            SQLExec.executeSQL(database, sqlBuilder, historyNumber, maxRows, maxColumnWidth, maxLinesPerRow, history);
                        } else if (sqlLineLower.startsWith(COMMAND_MAX_ROWS)) {
                            String maxRowsString = sqlLine.substring(COMMAND_MAX_ROWS.length(), sqlLine.length()).trim();
                            if (!maxRowsString.isEmpty()) {
                                maxRows = Integer.parseInt(maxRowsString);
                                maxRows = Math.max(0, maxRows);
                            }
                            System.out.println("Max Rows: " + SQLExec.printableValue(maxRows));
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLineLower.startsWith(COMMAND_MAX_COLUMN_WIDTH)) {
                            String maxColumnWidthString = sqlLine.substring(COMMAND_MAX_COLUMN_WIDTH.length(), sqlLine.length()).trim();
                            if (!maxColumnWidthString.isEmpty()) {
                                maxColumnWidth = Integer.parseInt(maxColumnWidthString);
                                maxColumnWidth = Math.max(0, maxColumnWidth);
                            }
                            System.out.println("Max Column Width: " + SQLExec.printableValue(maxColumnWidth));
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLineLower.startsWith(COMMAND_MAX_LINES_PER_ROW)) {
                            String maxLinesPerRowString = sqlLine.substring(COMMAND_MAX_LINES_PER_ROW.length(), sqlLine.length()).trim();
                            if (!maxLinesPerRowString.isEmpty()) {
                                maxLinesPerRow = Integer.parseInt(maxLinesPerRowString);
                                maxLinesPerRow = Math.max(0, maxLinesPerRow);
                            }
                            System.out.println("Max Lines Per Row: " + SQLExec.printableValue(maxLinesPerRow));
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLineLower.startsWith(COMMAND_TABLE_INFO)) {
                            String tableName = sqlLine.substring(COMMAND_TABLE_INFO.length(), sqlLine.length()).trim();
                            if (!tableName.isEmpty()) {
                                SQLExec.tableInfo(database, sqlBuilder, maxColumnWidth, maxLinesPerRow, history, tableName, true);
                            } else {
                                SQLExec.printInfo(database, maxRows, maxColumnWidth, maxLinesPerRow);
                                SQLExec.resetCommandPrompt(sqlBuilder);
                            }
                        } else if (sqlLineLower.startsWith(COMMAND_COUNT)) {
                            String tableName = sqlLine.substring(COMMAND_COUNT.length(), sqlLine.length()).trim();
                            if (!tableName.isEmpty()) {
                                SQLExec.executeSQL(database, sqlBuilder, "SELECT COUNT(*) FROM \"" + tableName + "\";", (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                            } else {
                                String sql = SQLExec.buildSqlMasterCountQuery(SQLiteMasterType.TABLE, tableName);
                                SQLExec.executeSQL(database, sqlBuilder, sql, (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                            }
                        } else if (sqlLine.equalsIgnoreCase(COMMAND_SQLITE_MASTER) || SQLiteMaster.count((GeoPackageCoreConnection)database.getDatabase(), (SQLiteMasterType[])new SQLiteMasterType[]{SQLiteMasterType.TABLE, SQLiteMasterType.VIEW}, (SQLiteMasterQuery)SQLiteMasterQuery.create((SQLiteMasterColumn)SQLiteMasterColumn.NAME, (String)sqlLine)) > 0) {
                            SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM \"" + sqlLine + "\";", maxRows, maxColumnWidth, maxLinesPerRow, history);
                        } else if (sqlLineLower.startsWith(COMMAND_VACUUM)) {
                            SQLExec.executeShortcutSQL(database, sqlBuilder, sqlLine, maxRows, maxColumnWidth, maxLinesPerRow, history, COMMAND_VACUUM, "VACUUM");
                        } else if (sqlLineLower.startsWith(COMMAND_FOREIGN_KEY_CHECK)) {
                            SQLExec.executeShortcutSQL(database, sqlBuilder, sqlLine, maxRows, maxColumnWidth, maxLinesPerRow, history, COMMAND_FOREIGN_KEY_CHECK, "PRAGMA foreign_key_check");
                        } else if (sqlLineLower.startsWith(COMMAND_FOREIGN_KEYS)) {
                            SQLExec.executeShortcutSQL(database, sqlBuilder, sqlLine, maxRows, maxColumnWidth, maxLinesPerRow, history, COMMAND_FOREIGN_KEYS, "PRAGMA foreign_keys");
                        } else if (sqlLineLower.startsWith(COMMAND_INTEGRITY_CHECK)) {
                            SQLExec.executeShortcutSQL(database, sqlBuilder, sqlLine, maxRows, maxColumnWidth, maxLinesPerRow, history, COMMAND_INTEGRITY_CHECK, "PRAGMA integrity_check");
                        } else if (sqlLineLower.startsWith(COMMAND_QUICK_CHECK)) {
                            SQLExec.executeShortcutSQL(database, sqlBuilder, sqlLine, maxRows, maxColumnWidth, maxLinesPerRow, history, COMMAND_QUICK_CHECK, "PRAGMA quick_check");
                        } else if (SQLExec.isGeoPackage(database)) {
                            if (sqlLineLower.startsWith(COMMAND_CONTENTS)) {
                                String tableName = sqlLine.substring(COMMAND_CONTENTS.length(), sqlLine.length()).trim();
                                StringBuilder sql = new StringBuilder("SELECT table_name, data_type FROM gpkg_contents");
                                if (!tableName.isEmpty()) {
                                    sql.append(" WHERE table_name LIKE ");
                                    sql.append(CoreSQLUtils.quoteWrap((String)tableName));
                                }
                                sql.append(" ORDER BY table_name;");
                                SQLExec.executeSQL(database, sqlBuilder, sql.toString(), (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                            } else if (sqlLineLower.startsWith(COMMAND_GEOPACKAGE_INFO)) {
                                String tableName = sqlLine.substring(COMMAND_GEOPACKAGE_INFO.length(), sqlLine.length()).trim();
                                if (!tableName.isEmpty()) {
                                    SQLExec.geoPackageTableInfo(database, sqlBuilder, maxColumnWidth, maxLinesPerRow, history, tableName);
                                }
                                SQLExec.resetCommandPrompt(sqlBuilder);
                            } else if (sqlLineLower.startsWith(COMMAND_CONTENTS_BOUNDS) || sqlLineLower.startsWith(COMMAND_BOUNDS) || sqlLineLower.startsWith(COMMAND_TABLE_BOUNDS)) {
                                int commandLength;
                                BoundsType type = null;
                                if (sqlLineLower.startsWith(COMMAND_CONTENTS_BOUNDS)) {
                                    type = BoundsType.CONTENTS;
                                    commandLength = COMMAND_CONTENTS_BOUNDS.length();
                                } else if (sqlLineLower.startsWith(COMMAND_TABLE_BOUNDS)) {
                                    type = BoundsType.TABLE;
                                    commandLength = COMMAND_TABLE_BOUNDS.length();
                                } else {
                                    type = BoundsType.ALL;
                                    commandLength = COMMAND_BOUNDS.length();
                                }
                                SQLExec.bounds(database, sqlBuilder, type, sqlLine.substring(commandLength));
                            } else if (sqlLineLower.startsWith(COMMAND_EXTENSIONS)) {
                                String tableName = sqlLine.substring(COMMAND_EXTENSIONS.length(), sqlLine.length()).trim();
                                StringBuilder sql = new StringBuilder("SELECT table_name, column_name, extension_name, definition FROM gpkg_extensions");
                                if (!tableName.isEmpty()) {
                                    sql.append(" WHERE LOWER(table_name) LIKE ");
                                    sql.append(CoreSQLUtils.quoteWrap((String)tableName.toLowerCase()));
                                }
                                sql.append(";");
                                SQLExec.executeSQL(database, sqlBuilder, sql.toString(), (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                            } else if (sqlLineLower.startsWith(COMMAND_RTREE)) {
                                SQLExec.rtree(database, sqlBuilder, history, sqlLine.substring(COMMAND_RTREE.length(), sqlLine.length()));
                            } else if (sqlLineLower.startsWith(COMMAND_GEOMETRY)) {
                                SQLExec.geometries(database, sqlBuilder, history, sqlLine.substring(COMMAND_GEOMETRY.length(), sqlLine.length()));
                            } else if (sqlLineLower.startsWith(COMMAND_REPROJECT)) {
                                SQLExec.reproject(database, sqlBuilder, maxColumnWidth, maxLinesPerRow, history, sqlLine.substring(COMMAND_REPROJECT.length(), sqlLine.length()));
                            } else if (sqlLineLower.equalsIgnoreCase("dgiwg")) {
                                SQLExec.dgiwg(database);
                                SQLExec.resetCommandPrompt(sqlBuilder);
                            } else {
                                String[] parts = sqlLine.split("\\s+");
                                String dataType = parts[0];
                                if (ContentsDataType.fromName((String)dataType.toLowerCase()) != null || !database.getTables(dataType.toLowerCase()).isEmpty() || !database.getTables(dataType).isEmpty()) {
                                    String tableName;
                                    StringBuilder sql = new StringBuilder("SELECT table_name FROM gpkg_contents WHERE LOWER(data_type) = '");
                                    sql.append(dataType.toLowerCase());
                                    sql.append("'");
                                    if (parts.length > 0 && !(tableName = sqlLine.substring(dataType.length(), sqlLine.length()).trim()).isEmpty()) {
                                        sql.append(" AND table_name LIKE ");
                                        sql.append(CoreSQLUtils.quoteWrap((String)tableName));
                                    }
                                    sql.append(" ORDER BY table_name;");
                                    SQLExec.executeSQL(database, sqlBuilder, sql.toString(), (Integer)0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history);
                                } else {
                                    command = false;
                                }
                            }
                        } else {
                            command = false;
                        }
                        if (command) {
                            executeSql = false;
                        }
                    }
                    if (!executeSql) continue;
                    SQLExec.executeSQL(database, sqlBuilder, sqlBuilder.toString(), maxRows, maxColumnWidth, maxLinesPerRow, history);
                }
                catch (Exception e) {
                    System.out.println(e);
                    SQLExec.resetCommandPrompt(sqlBuilder);
                }
            }
        }
    }

    private static String buildSqlMasterQuery(SQLiteMasterColumn[] columns, SQLiteMasterType type, String name) {
        ArrayList<String> columnsList = new ArrayList<String>();
        for (SQLiteMasterColumn column : columns) {
            columnsList.add(column.name().toLowerCase());
        }
        return SQLExec.buildSqlMasterQuery(columnsList, type, name);
    }

    private static String buildSqlMasterCountQuery(SQLiteMasterType type, String name) {
        ArrayList<String> columnsList = new ArrayList<String>();
        columnsList.add("COUNT(*)");
        return SQLExec.buildSqlMasterQuery(columnsList, type, name);
    }

    private static String buildSqlMasterQuery(List<String> columns, SQLiteMasterType type, String name) {
        StringBuilder sql = new StringBuilder("SELECT ");
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(columns.get(i));
        }
        sql.append(" FROM ");
        sql.append(COMMAND_SQLITE_MASTER);
        sql.append(" WHERE ");
        sql.append(SQLiteMasterColumn.TYPE.name().toLowerCase());
        sql.append(" = '");
        sql.append(type.name().toLowerCase());
        sql.append("' AND ");
        sql.append(SQLiteMasterColumn.NAME.name().toLowerCase());
        sql.append(" NOT LIKE 'sqlite_%'");
        if (name != null && !(name = name.trim()).isEmpty()) {
            sql.append(" AND ");
            sql.append(SQLiteMasterColumn.NAME.name().toLowerCase());
            sql.append(" LIKE ");
            sql.append(CoreSQLUtils.quoteWrap((String)name));
        }
        sql.append(" ORDER BY ");
        sql.append(SQLiteMasterColumn.NAME.name().toLowerCase());
        sql.append(";");
        return sql.toString();
    }

    private static void printInfo(GeoPackage database, Integer maxRows, Integer maxColumnWidth, Integer maxLinesPerRow) {
        Integer userVersion;
        boolean isGeoPackage = SQLExec.isGeoPackage(database);
        System.out.println();
        if (isGeoPackage) {
            System.out.print("GeoPackage");
        } else {
            System.out.print("Database");
        }
        System.out.println(": " + database.getName());
        System.out.println("Path: " + database.getPath());
        System.out.println("Size: " + database.readableSize() + " (" + database.size() + " bytes)");
        Integer applicationId = database.getApplicationIdInteger();
        if (applicationId != null) {
            System.out.println("Application ID: " + applicationId + ", " + database.getApplicationIdHex() + ", " + database.getApplicationId());
        }
        if ((userVersion = database.getUserVersion()) != null) {
            System.out.println("User Version: " + userVersion);
        }
        System.out.println("Max Rows: " + SQLExec.printableValue(maxRows));
        System.out.println("Max Column Width: " + SQLExec.printableValue(maxColumnWidth));
        System.out.println("Max Lines Per Row: " + SQLExec.printableValue(maxLinesPerRow));
    }

    private static void printHelp(GeoPackage database) {
        boolean isGeoPackage = SQLExec.isGeoPackage(database);
        System.out.println();
        System.out.println("- Supports most SQLite statements including:");
        System.out.println("\tSELECT, INSERT, UPDATE, DELETE, CREATE, ALTER, DROP, PRAGMA, VACUUM, etc");
        System.out.println("- Terminate SQL statements with a ;");
        System.out.println("- Exit with a single empty line");
        System.out.println();
        System.out.println("Commands:");
        System.out.println();
        System.out.println("\tinfo              - " + (isGeoPackage ? "GeoPackage" : "Database") + " information");
        System.out.println("\thelp              - print this help information");
        System.out.println("\tversion           - Show the SQLite Exec version");
        System.out.println("\tcount             - count database tables");
        System.out.println("\ttables [name]     - list database tables (all or LIKE table name)");
        System.out.println("\tindexes [name]    - list database indexes (all or LIKE index name)");
        System.out.println("\tviews [name]      - list database views (all or LIKE view name)");
        System.out.println("\ttriggers [name]   - list database triggers (all or LIKE trigger name)");
        System.out.println("\trows [n]          - display or set the max rows per query");
        System.out.println("\twidth [n]         - display or set the max width (in characters) per column");
        System.out.println("\tlines [n]         - display or set the max lines per row");
        System.out.println("\thistory           - list successfully executed sql commands");
        System.out.println("\t!!                - re-execute the previous successful sql command");
        System.out.println("\t!n                - re-execute a sql statement by history id n");
        System.out.println("\t!-n               - re-execute a sql statement n commands back in history");
        System.out.println("\tblobs [-e file_extension] [-d directory] [-p pattern]");
        System.out.println("\t                  - write blobs from the previous successful sql command to the file system");
        System.out.println("\t                        ([directory]|blobs)/table_name/column_name/(pk_values|result_index|[pattern])[.file_extension]");
        System.out.println("\t                     file_extension - file extension added to each saved blob file");
        System.out.println("\t                     directory      - base directory to save table_name/column_name/blobs (default is ./blobs)");
        System.out.println("\t                     pattern        - file directory and/or name pattern consisting of column names in parentheses");
        System.out.println("\t                                       (column_name)-(column_name2)");
        System.out.println("\t                                       (column_name)/(column_name2)");
        System.out.println("\tinfo <name>       - PRAGMA table_info(<name>); SELECT COUNT(*) FROM <name>;");
        System.out.println("\tcount <name>      - SELECT COUNT(*) FROM <name>;");
        System.out.println("\tsqlite_master     - SELECT * FROM sqlite_master;");
        System.out.println("\t<name>            - SELECT * FROM <name>;");
        System.out.println("\tvacuum            - VACUUM [INTO 'filename'];");
        System.out.println("\tfk                - PRAGMA foreign_keys [= boolean];");
        System.out.println("\tfkc               - PRAGMA foreign_key_check[(<table-name>)];");
        System.out.println("\tintegrity         - PRAGMA integrity_check[(N)];");
        System.out.println("\tquick             - PRAGMA quick_check[(N)];");
        if (isGeoPackage) {
            System.out.println("\tcontents [name]   - List GeoPackage contents (all or LIKE table name)");
            System.out.println("\t" + ContentsDataType.ATTRIBUTES.getName() + " [name] - List GeoPackage attributes tables (all or LIKE table name)");
            System.out.println("\t" + ContentsDataType.FEATURES.getName() + " [name]   - List GeoPackage feature tables (all or LIKE table name)");
            System.out.println("\t" + ContentsDataType.TILES.getName() + " [name]      - List GeoPackage tile tables (all or LIKE table name)");
            System.out.println("\tginfo <name>      - Query GeoPackage metadata for the table name");
            System.out.println("\tcbounds [-p projection] [name]");
            System.out.println("\t                  - Determine the bounds (using only the contents) of the entire GeoPackage or single table name");
            System.out.println("\t                     projection     - desired projection as 'authority:code' or 'epsg_code'");
            System.out.println("\tbounds [-p projection] [-m] [name]");
            System.out.println("\t                  - Determine the bounds of the entire GeoPackage or single table name");
            System.out.println("\t                     projection     - desired projection as 'authority:code' or 'epsg_code'");
            System.out.println("\t                     m              - manually query unindexed tables");
            System.out.println("\ttbounds [-p projection] [-m] [name]");
            System.out.println("\t                  - Determine the bounds (using only table metadata) of the entire GeoPackage or single table name");
            System.out.println("\t                     projection     - desired projection as 'authority:code' or 'epsg_code'");
            System.out.println("\t                     m              - manually query unindexed tables");
            System.out.println("\textensions [name] - List GeoPackage extensions (all or LIKE table name)");
            System.out.println("\trtree [-g|-d] <name>");
            System.out.println("\t                  - Create, recreate, or drop a feature table R-tree");
            System.out.println("\t                     g              - index using geodesic bounds");
            System.out.println("\t                     d              - drop the R-tree if it exists");
            System.out.println("\tgeometry <name> [-p projection] [ids]");
            System.out.println("\t                  - Display feature table geometries as Well-Known Text");
            System.out.println("\t                     projection     - desired display projection as 'authority:code' or 'epsg_code'");
            System.out.println("\t                     ids            - single or comma delimited feature table row ids");
            System.out.println("\tgeometry <name> [-p projection] <id> <wkt>");
            System.out.println("\t                  - Update or insert a feature table geometry with Well-Known Text");
            System.out.println("\t                     projection     - Well-Known Text projection as 'authority:code' or 'epsg_code'");
            System.out.println("\t                     id             - single feature table row id to update or -1 to insert a new row");
            System.out.println("\t                     wkt            - Well-Known Text");
            System.out.println("\treproject <name> <projection|optimization> [-z zoom_levels] [reproject_name]");
            System.out.println("\t                  - Reproject tile table tiles to a different projection or optimization");
            System.out.println("\t                     projection     - Projection as 'authority:code' or 'epsg_code'");
            System.out.println("\t                     optimization   - wm, pc, wmw, or pcw");
            System.out.println("\t                        wm             - Web Mercator optimization, minimally tile bounded");
            System.out.println("\t                        pc             - Platte Carre (WGS84) optimization, minimally tile bounded");
            System.out.println("\t                        wmw            - Web Mercator optimization, world bounded with XYZ tile coordinates");
            System.out.println("\t                        pcw            - Platte Carre (WGS84) optimization, world bounded with XYZ tile coordinates");
            System.out.println("\t                     zoom_levels    - Zoom level(s) specified as 'z', 'zmin-zmax', or 'z1,z2,...', (default is all levels)");
            System.out.println("\t                     reproject_name - Reprojection table name (default is <name>)");
            System.out.println("\tdgiwg             - DGIWG GeoPackage Profile validation");
        }
        System.out.println();
        System.out.println("Special Supported Cases:");
        System.out.println();
        System.out.println("\tDrop Column  - Not natively supported in SQLite");
        System.out.println("\t                  * ALTER TABLE table_name DROP column_name");
        System.out.println("\t                  * ALTER TABLE table_name DROP COLUMN column_name");
        System.out.println("\tCopy Table   - Not a traditional SQL statment");
        System.out.println("\t                  * ALTER TABLE table_name COPY TO new_table_name");
        if (isGeoPackage) {
            System.out.println("\tRename Table - User tables are updated throughout the GeoPackage");
            System.out.println("\t                  * ALTER TABLE table_name RENAME TO new_table_name");
            System.out.println("\tDrop Table   - User tables are dropped throughout the GeoPackage");
            System.out.println("\t                  * DROP TABLE table_name");
        }
    }

    private static void printVersion() {
        System.out.println();
        System.out.println(GeoPackageJavaProperties.getProperty("geopackage.version"));
    }

    private static void executeSQL(GeoPackage database, StringBuilder sqlBuilder, int historyNumber, Integer maxRows, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history) throws SQLException {
        int number = historyNumber;
        number = number < 0 ? (number += history.size()) : --number;
        if (number >= 0 && number < history.size()) {
            String sql = history.get(number);
            System.out.println(sql);
            SQLExec.executeSQL(database, sqlBuilder, sql, maxRows, maxColumnWidth, maxLinesPerRow, history);
        } else {
            System.out.println("No History at " + historyNumber);
            SQLExec.resetCommandPrompt(sqlBuilder);
        }
    }

    private static void executeSQL(GeoPackage database, StringBuilder sqlBuilder, String sql, Integer maxRows, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history) throws SQLException {
        SQLExec.executeSQL(database, sqlBuilder, sql, maxRows, maxColumnWidth, maxLinesPerRow, history, true);
    }

    private static void executeSQL(GeoPackage database, StringBuilder sqlBuilder, String sql, Integer maxRows, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, boolean resetCommandPrompt) throws SQLException {
        SQLExec.executeSQL(database, sqlBuilder, sql, maxRows, maxColumnWidth, maxLinesPerRow, history, resetCommandPrompt, true);
    }

    private static void executeSQL(GeoPackage database, StringBuilder sqlBuilder, String sql, Integer maxRows, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, boolean resetCommandPrompt, boolean printSides) throws SQLException {
        SQLExec.executeSQL(database, sqlBuilder, sql, null, maxRows, maxColumnWidth, maxLinesPerRow, history, resetCommandPrompt, printSides);
    }

    private static void executeSQL(GeoPackage database, StringBuilder sqlBuilder, String sql, Projection projection, Integer maxRows, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, boolean resetCommandPrompt, boolean printSides) throws SQLException {
        SQLExecResult result = SQLExec.executeSQL(database, sql, projection, maxRows);
        SQLExec.printResult(result, sqlBuilder, sql, maxColumnWidth, maxLinesPerRow, history, resetCommandPrompt, printSides);
    }

    private static void printResult(SQLExecResult result, StringBuilder sqlBuilder, String sql, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, boolean resetCommandPrompt, boolean printSides) {
        SQLExec.setPrintOptions(result, maxColumnWidth, maxLinesPerRow);
        result.setPrintSides(printSides);
        result.printResults();
        history.add(sql);
        if (resetCommandPrompt) {
            SQLExec.resetCommandPrompt(sqlBuilder);
        }
    }

    private static void setPrintOptions(SQLExecResult result, Integer maxColumnWidth, Integer maxLinesPerRow) {
        if (maxColumnWidth == null) {
            maxColumnWidth = DEFAULT_MAX_COLUMN_WIDTH;
        }
        if (maxLinesPerRow == null) {
            maxLinesPerRow = DEFAULT_MAX_LINES_PER_ROW;
        }
        result.setMaxColumnWidth(maxColumnWidth);
        result.setMaxLinesPerRow(maxLinesPerRow);
    }

    private static void executeShortcutSQL(GeoPackage database, StringBuilder sqlBuilder, String sql, Integer maxRows, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, String shortcut, String replacement) throws SQLException {
        String replacedSql = replacement + sql.substring(shortcut.length());
        SQLExec.executeSQL(database, sqlBuilder, replacedSql, maxRows, maxColumnWidth, maxLinesPerRow, history);
    }

    private static void resetCommandPrompt(StringBuilder sqlBuilder) {
        sqlBuilder.setLength(0);
        System.out.println();
        System.out.print(COMMAND_PROMPT);
    }

    public static SQLExecResult executeSQL(File databaseFile, String sql) throws SQLException {
        return SQLExec.executeSQL(databaseFile, sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLExecResult executeSQL(File databaseFile, String sql, Integer maxRows) throws SQLException {
        SQLExecResult result = null;
        try (GeoPackage database = GeoPackageManager.open(databaseFile);){
            result = SQLExec.executeSQL(database, sql, maxRows);
        }
        return result;
    }

    public static SQLExecResult executeSQL(GeoPackage database, String sql) throws SQLException {
        return SQLExec.executeSQL(database, sql, null);
    }

    public static SQLExecResult executeSQL(GeoPackage database, String sql, Integer maxRows) throws SQLException {
        return SQLExec.executeSQL(database, sql, null, maxRows);
    }

    public static SQLExecResult executeSQL(GeoPackage database, String sql, Projection projection, Integer maxRows) throws SQLException {
        SQLExecResult result;
        sql = sql.trim();
        RTreeIndexExtension rtree = new RTreeIndexExtension(database);
        if (rtree.has()) {
            rtree.createAllFunctions();
        }
        if ((result = SQLExecAlterTable.alterTable(database, sql)) == null) {
            result = SQLExec.executeQuery(database, sql, projection, maxRows);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SQLExecResult executeQuery(GeoPackage database, String sql, Projection projection, Integer maxRows) throws SQLException {
        SQLExecResult result = new SQLExecResult();
        if (!sql.equals(";")) {
            PreparedStatement statement;
            block20: {
                statement = null;
                try {
                    boolean hasResultSet;
                    statement = database.getConnection().getConnection().prepareStatement(sql);
                    if (maxRows != null) {
                        statement.setMaxRows(maxRows);
                        result.setMaxRows(maxRows);
                    }
                    if (hasResultSet = statement.execute()) {
                        ResultSet resultSet = statement.getResultSet();
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        int numColumns = metadata.getColumnCount();
                        int[] columnWidths = new int[numColumns];
                        int[] columnTypes = new int[numColumns];
                        boolean isGeoPackage = SQLExec.isGeoPackage(database);
                        HashMap<String, GeometryColumns> tableGeometryColumns = new HashMap<String, GeometryColumns>();
                        HashMap<Integer, GeometryTransform> geometryColumns = new HashMap<Integer, GeometryTransform>();
                        for (int col = 1; col <= numColumns; ++col) {
                            String tableName = metadata.getTableName(col);
                            result.addTable(tableName);
                            String columnName = metadata.getColumnName(col);
                            result.addColumn(columnName);
                            columnTypes[col - 1] = metadata.getColumnType(col);
                            columnWidths[col - 1] = columnName.length();
                            if (!isGeoPackage) continue;
                            GeometryColumns geometryColumn = null;
                            if (tableGeometryColumns.containsKey(tableName)) {
                                geometryColumn = (GeometryColumns)tableGeometryColumns.get(tableName);
                            } else {
                                if (database.isFeatureTable(tableName)) {
                                    geometryColumn = database.getGeometryColumnsDao().queryForTableName(tableName);
                                }
                                tableGeometryColumns.put(tableName, geometryColumn);
                            }
                            if (geometryColumn == null || !geometryColumn.getColumnName().equalsIgnoreCase(columnName)) continue;
                            GeometryTransform transform = null;
                            if (projection != null) {
                                transform = GeometryTransform.create((Projection)geometryColumn.getProjection(), (Projection)projection);
                            }
                            geometryColumns.put(col, transform);
                        }
                        while (resultSet.next()) {
                            ArrayList<String> row = new ArrayList<String>();
                            result.addRow(row);
                            for (int col = 1; col <= numColumns; ++col) {
                                String stringValue = null;
                                Object value = resultSet.getObject(col);
                                if (value != null) {
                                    int valueLength;
                                    switch (columnTypes[col - 1]) {
                                        case 2004: {
                                            stringValue = BLOB_DISPLAY_VALUE;
                                            if (!geometryColumns.containsKey(col)) break;
                                            GeometryTransform transform = (GeometryTransform)geometryColumns.get(col);
                                            byte[] bytes = (byte[])value;
                                            try {
                                                if (transform == null) {
                                                    stringValue = GeoPackageGeometryData.wkt((byte[])bytes);
                                                    break;
                                                }
                                                GeoPackageGeometryData geometryData = GeoPackageGeometryData.create((byte[])bytes);
                                                stringValue = geometryData.transform(transform).getWkt();
                                            }
                                            catch (IOException iOException) {}
                                            break;
                                        }
                                        default: {
                                            stringValue = value.toString().replaceAll("\\s*[\\r\\n]+\\s*", " ");
                                        }
                                    }
                                    if (stringValue != null && (valueLength = stringValue.length()) > columnWidths[col - 1]) {
                                        columnWidths[col - 1] = valueLength;
                                    }
                                }
                                row.add(stringValue);
                            }
                        }
                        result.addColumnWidths(columnWidths);
                        break block20;
                    }
                    int updateCount = statement.getUpdateCount();
                    if (updateCount < 0) break block20;
                    result.setUpdateCount(updateCount);
                }
                catch (Throwable throwable) {
                    SQLUtils.closeStatement(statement, sql);
                    throw throwable;
                }
            }
            SQLUtils.closeStatement(statement, sql);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBlobs(GeoPackage database, StringBuilder sqlBuilder, Integer maxRows, List<String> history, String args) throws SQLException, IOException {
        if (history.isEmpty()) {
            System.out.println("No previous query with blobs");
        } else {
            boolean valid = true;
            Object extension = null;
            String directory = null;
            String pattern = null;
            ArrayList<String> patternColumns = new ArrayList<String>();
            if (args != null && !args.isEmpty()) {
                String[] argParts = args.trim().split("\\s+");
                block12: for (int i = 0; valid && i < argParts.length; ++i) {
                    String arg = argParts[i];
                    if (arg.startsWith(ARGUMENT_PREFIX)) {
                        String argument;
                        switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                            case "e": {
                                if (i + 1 < argParts.length) {
                                    extension = argParts[++i];
                                    break;
                                }
                                valid = false;
                                System.out.println("Error: Blobs extension argument '" + arg + "' must be followed by a file extension");
                                break;
                            }
                            case "d": {
                                if (i + 1 < argParts.length) {
                                    directory = argParts[++i];
                                    break;
                                }
                                valid = false;
                                System.out.println("Error: Blobs directory argument '" + arg + "' must be followed by a directory location");
                                break;
                            }
                            case "p": {
                                if (i + 1 < argParts.length) {
                                    pattern = argParts[++i];
                                    Matcher matcher = BLOBS_COLUMN_PATTERN.matcher(pattern);
                                    while (matcher.find()) {
                                        String columnName = matcher.group(1);
                                        patternColumns.add(columnName);
                                    }
                                    if (!patternColumns.isEmpty()) continue block12;
                                    valid = false;
                                    System.out.println("Error: Blobs pattern argument '" + arg + "' must be followed by a save pattern with at least one column surrounded by parentheses");
                                    break;
                                }
                                valid = false;
                                System.out.println("Error: Blobs pattern argument '" + arg + "' must be followed by a save pattern");
                                break;
                            }
                            default: {
                                valid = false;
                                System.out.println("Error: Unsupported arg: '" + arg + "'");
                            }
                        }
                        continue;
                    }
                    valid = false;
                    System.out.println("Error: Unsupported arg: '" + arg + "'");
                }
            }
            if (valid) {
                PreparedStatement statement;
                int blobsWrittenCount;
                LinkedHashSet<String> blobsWritten;
                String sql;
                block47: {
                    sql = history.get(history.size() - 1);
                    blobsWritten = new LinkedHashSet<String>();
                    blobsWrittenCount = 0;
                    statement = null;
                    try {
                        int col;
                        boolean hasResultSet;
                        statement = database.getConnection().getConnection().prepareStatement(sql);
                        if (maxRows != null) {
                            statement.setMaxRows(maxRows);
                        }
                        if (!(hasResultSet = statement.execute())) break block47;
                        ResultSet resultSet = statement.getResultSet();
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        int numColumns = metadata.getColumnCount();
                        ArrayList<Integer> blobColumns = new ArrayList<Integer>();
                        ArrayList<String> tables = new ArrayList<String>();
                        ArrayList<String> columnNames = new ArrayList<String>();
                        HashMap tableNameColumns = new HashMap();
                        HashMap<String, Integer> columnNameIndexes = new HashMap<String, Integer>();
                        for (col = 1; col <= numColumns; ++col) {
                            columnNameIndexes.put(metadata.getColumnName(col), col);
                        }
                        for (col = 1; col <= numColumns; ++col) {
                            if (metadata.getColumnType(col) != 2004) continue;
                            blobColumns.add(col);
                            String tableName = metadata.getTableName(col);
                            ArrayList<Integer> nameColumns = (ArrayList<Integer>)tableNameColumns.get(tableName);
                            if (nameColumns == null) {
                                nameColumns = new ArrayList<Integer>();
                                TableInfo tableInfo = TableInfo.info((GeoPackageCoreConnection)database.getConnection(), (String)tableName);
                                ArrayList<String> nameColumnNames = null;
                                if (pattern != null) {
                                    nameColumnNames = patternColumns;
                                } else if (tableInfo.hasPrimaryKey()) {
                                    nameColumnNames = new ArrayList();
                                    for (TableColumn tableColumn : tableInfo.getPrimaryKeys()) {
                                        nameColumnNames.add(tableColumn.getName());
                                    }
                                }
                                if (nameColumnNames != null) {
                                    for (String columnName : nameColumnNames) {
                                        Integer columnIndex = (Integer)columnNameIndexes.get(columnName);
                                        if (columnIndex == null && pattern != null) {
                                            throw new IllegalArgumentException("Pattern column not found in query: " + columnName);
                                        }
                                        nameColumns.add(columnIndex);
                                    }
                                }
                                tableNameColumns.put(tableName, nameColumns);
                            }
                            tables.add(tableName);
                            columnNames.add(metadata.getColumnName(col));
                        }
                        if (!blobColumns.isEmpty()) {
                            if (extension != null && !((String)extension).startsWith(".")) {
                                extension = "." + (String)extension;
                            }
                            if (directory == null) {
                                directory = "blobs";
                            }
                            File blobsDirectory = new File(directory);
                            int resultCount = 0;
                            while (resultSet.next()) {
                                ++resultCount;
                                for (int i = 0; i < blobColumns.size(); ++i) {
                                    List nameColumns;
                                    int col2 = (Integer)blobColumns.get(i);
                                    byte[] blobBytes = resultSet.getBytes(col2);
                                    if (blobBytes == null) continue;
                                    String tableName = (String)tables.get(i);
                                    File tableDirectory = new File(blobsDirectory, tableName);
                                    File columnDirectory = new File(tableDirectory, (String)columnNames.get(i));
                                    Object name = null;
                                    if (pattern != null) {
                                        name = pattern;
                                    }
                                    if (!(nameColumns = (List)tableNameColumns.get(tableName)).isEmpty()) {
                                        for (int j = 0; j < nameColumns.size(); ++j) {
                                            String columnValue;
                                            Integer nameColumn = (Integer)nameColumns.get(j);
                                            if (nameColumn == null || (columnValue = resultSet.getString(nameColumn)) == null) continue;
                                            if (pattern != null) {
                                                String columnName = (String)patternColumns.get(j);
                                                name = ((String)name).replaceAll(BLOBS_COLUMN_START_REGEX + columnName + BLOBS_COLUMN_END_REGEX, columnValue);
                                                continue;
                                            }
                                            name = name == null ? columnValue : (String)name + ARGUMENT_PREFIX + columnValue;
                                        }
                                    }
                                    if (name == null) {
                                        name = String.valueOf(resultCount);
                                    }
                                    if (extension != null) {
                                        name = (String)name + (String)extension;
                                    }
                                    File blobFile = new File(columnDirectory, (String)name);
                                    blobFile.getParentFile().mkdirs();
                                    FileOutputStream fos = new FileOutputStream(blobFile);
                                    fos.write(blobBytes);
                                    fos.close();
                                    ++blobsWrittenCount;
                                    blobsWritten.add(columnDirectory.getAbsolutePath());
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.closeStatement(statement, sql);
                        throw throwable;
                    }
                }
                SQLUtils.closeStatement(statement, sql);
                if (blobsWrittenCount <= 0) {
                    System.out.println("No Blobs in previous query: " + sql);
                } else {
                    System.out.println(blobsWrittenCount + " Blobs written to:");
                    for (String location : blobsWritten) {
                        System.out.println(location);
                    }
                }
            }
        }
        SQLExec.resetCommandPrompt(sqlBuilder);
    }

    private static void geoPackageTableInfo(GeoPackage database, StringBuilder sqlBuilder, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, String tableName) throws SQLException {
        ContentsDataType dataType;
        SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_contents WHERE LOWER(table_name) = '" + tableName.toLowerCase() + "';", 0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history, false);
        SQLExec.projectionInfo(database, tableName);
        String tableType = database.getTableType(tableName);
        if (tableType != null) {
            switch (tableType) {
                case "2d-gridded-coverage": {
                    SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_2d_gridded_coverage_ancillary WHERE tile_matrix_set_name = '" + tableName + "';", 0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history, false);
                    SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_2d_gridded_tile_ancillary WHERE tpudt_name = '" + tableName + "';", 0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history, false);
                }
            }
        }
        if ((dataType = database.getTableDataType(tableName)) != null) {
            switch (dataType) {
                case ATTRIBUTES: {
                    break;
                }
                case FEATURES: {
                    SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_geometry_columns WHERE table_name = '" + tableName + "';", 0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history, false);
                    SQLExec.rtreeInfo(database, tableName);
                    break;
                }
                case TILES: {
                    SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_tile_matrix_set WHERE table_name = '" + tableName + "';", 0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history, false);
                    SQLExec.tileMatrix(database, sqlBuilder, maxColumnWidth, maxLinesPerRow, history, tableName);
                }
            }
        }
        SQLExec.tableInfo(database, sqlBuilder, maxColumnWidth, maxLinesPerRow, history, tableName, false);
    }

    private static void projectionInfo(GeoPackage database, String tableName) {
        SpatialReferenceSystem srs;
        Contents contents = database.getTableContents(tableName);
        if (contents != null && (srs = contents.getSrs()) != null) {
            Projection projection = srs.getProjection();
            System.out.println();
            System.out.println("Authority: " + projection.getAuthority());
            System.out.println("Code: " + projection.getCode());
            String definition = projection.getDefinition();
            if (definition != null) {
                try {
                    String prettyDefinition = WKTUtils.pretty((String)definition);
                    System.out.println();
                    System.out.println(prettyDefinition);
                }
                catch (Exception e) {
                    System.out.println("Failed to pretty print definition: " + definition);
                    e.printStackTrace();
                }
                try {
                    System.out.println();
                    System.out.println("PROJ: " + ProjParser.paramsText((String)definition));
                }
                catch (Exception e) {
                    System.out.println("Failed to parse PROJ params from definition: " + definition);
                    e.printStackTrace();
                }
            }
        }
    }

    private static void tableInfo(GeoPackage database, StringBuilder sqlBuilder, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, String tableName, boolean resetCommandPrompt) throws SQLException {
        System.out.println();
        System.out.print("Table Info: " + tableName);
        SQLExec.executeSQL(database, sqlBuilder, "PRAGMA table_info(\"" + tableName + "\");", 0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history, false);
        System.out.println();
        System.out.print("Table: " + tableName);
        SQLExec.executeSQL(database, sqlBuilder, "SELECT COUNT(*) FROM \"" + tableName + "\";", 0x7FFFFFFE, maxColumnWidth, maxLinesPerRow, history, resetCommandPrompt);
    }

    private static void rtreeInfo(GeoPackage database, String tableName) {
        RTreeIndexExtension extension = new RTreeIndexExtension(database);
        System.out.println();
        System.out.println("R-tree indexed: " + extension.has(tableName));
    }

    private static void tileMatrix(GeoPackage database, StringBuilder sqlBuilder, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, String tableName) throws SQLException {
        String sql = "SELECT * FROM gpkg_tile_matrix WHERE table_name = '" + tableName + "';";
        SQLExecResult result = SQLExec.executeSQL(database, sql, (Integer)0x7FFFFFFE);
        TileDao tileDao = database.getTileDao(tableName);
        int zoomColumn = result.getColumns().indexOf("zoom_level");
        int mapZoomColumn = zoomColumn + 1;
        String mapZoomColumnName = "map_zoom_level";
        int mapZoomColumnWidth = mapZoomColumnName.length();
        for (int i = 0; i < result.numRows(); ++i) {
            long zoom = Long.parseLong(result.getValue(i, zoomColumn));
            String mapZoom = Long.toString(tileDao.getMapZoom(zoom));
            mapZoomColumnWidth = Math.max(mapZoomColumnWidth, mapZoom.length());
            result.addRowValue(i, mapZoomColumn, mapZoom);
        }
        result.addColumn(mapZoomColumn, mapZoomColumnName);
        result.addColumnWidth(mapZoomColumn, mapZoomColumnWidth);
        SQLExec.printResult(result, sqlBuilder, sql, maxColumnWidth, maxLinesPerRow, history, false, true);
    }

    private static void rtree(GeoPackage database, StringBuilder sqlBuilder, List<String> history, String args) throws SQLException, IOException {
        String[] parts = args.trim().split("\\s+");
        boolean valid = true;
        String tableName = null;
        boolean drop = false;
        boolean geodesic = false;
        for (int i = 0; valid && i < parts.length; ++i) {
            String arg = parts[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "g": {
                        geodesic = true;
                        break;
                    }
                    case "d": {
                        drop = true;
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (tableName == null) {
                tableName = arg;
                if (database.isFeatureTable(tableName)) continue;
                valid = false;
                if (tableName.isEmpty()) {
                    System.out.println("Error: Feature table required");
                    continue;
                }
                System.out.println("Error: '" + tableName + "' is not a feature table");
                continue;
            }
            valid = false;
            System.out.println("Error: Unexpected additional argument '" + arg + "' for R-tree");
        }
        if (geodesic && drop) {
            valid = false;
            System.out.println("Error: Unsupported combination of arguments");
        }
        if (valid) {
            RTreeIndexExtension extension = new RTreeIndexExtension(database, geodesic);
            RTreeIndexTableDao dao = extension.getTableDao(tableName);
            boolean exists = dao.has();
            System.out.println();
            if (exists) {
                dao.delete();
                System.out.println("R-tree dropped for table '" + tableName + "'");
            }
            if (!drop) {
                dao.create();
                System.out.println("R-tree created" + (geodesic ? " (geodesic)" : "") + " for table '" + tableName + "'");
            } else if (!exists) {
                System.out.println("No R-tree exists to drop for table '" + tableName + "'");
            }
        }
        SQLExec.resetCommandPrompt(sqlBuilder);
    }

    private static void geometries(GeoPackage database, StringBuilder sqlBuilder, List<String> history, String args) throws SQLException, IOException {
        String[] parts = args.trim().split("\\s+");
        boolean valid = true;
        String tableName = null;
        String ids = null;
        Long singleId = null;
        Projection projection = null;
        StringBuilder wktBuilder = null;
        block8: for (int i = 0; valid && i < parts.length; ++i) {
            String arg = parts[i];
            if (arg.startsWith(ARGUMENT_PREFIX) && !arg.equals("-1")) {
                String argument;
                if (wktBuilder != null) {
                    valid = false;
                    System.out.println("Error: Unexpected argument '" + arg + "' after expected Well-Known Text: " + wktBuilder.toString());
                    continue;
                }
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "p": {
                        if (i + 1 < parts.length) {
                            String projectionArugment;
                            if ((projection = SQLExec.getProjection(projectionArugment = parts[++i])) != null) continue block8;
                            valid = false;
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Projection argument '" + arg + "' must be followed by 'authority:code' or 'epsg_code'");
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                    }
                }
                continue;
            }
            if (tableName == null) {
                tableName = arg;
                if (database.isFeatureTable(tableName)) continue;
                valid = false;
                if (tableName.isEmpty()) {
                    System.out.println("Error: Feature table required");
                    continue;
                }
                System.out.println("Error: '" + tableName + "' is not a feature table");
                continue;
            }
            if (ids == null) {
                ids = arg;
                if (ids.indexOf(",") != -1) continue;
                try {
                    singleId = Long.parseLong(ids);
                }
                catch (NumberFormatException e) {
                    valid = false;
                    System.out.println("Error: Invalid single row id '" + ids + "'");
                }
                continue;
            }
            if (singleId == null) {
                valid = false;
                System.out.println("Error: Unexpected additional argument '" + arg + "' for multiple id query");
                continue;
            }
            if (wktBuilder == null) {
                wktBuilder = new StringBuilder();
            } else {
                wktBuilder.append(" ");
            }
            wktBuilder.append(arg);
        }
        if (tableName == null) {
            valid = false;
            System.out.println("Error: Feature table required");
        }
        if (valid) {
            FeatureRow featureRow;
            GeoPackageGeometryData geometryData;
            FeatureDao featureDao = database.getFeatureDao(tableName);
            if (wktBuilder != null) {
                GeometryTransform transform;
                String wkt = wktBuilder.toString().trim();
                if (wkt.startsWith("'") || wkt.startsWith("\"")) {
                    wkt = wkt.substring(1);
                }
                if (wkt.endsWith("'") || wkt.endsWith("\"")) {
                    wkt = wkt.substring(0, wkt.length() - 1);
                }
                geometryData = GeoPackageGeometryData.createFromWktAndBuildEnvelope((long)featureDao.getSrsId(), (String)wkt);
                if (projection != null && !(transform = GeometryTransform.create(projection, (Projection)featureDao.getProjection())).isSameProjection()) {
                    geometryData = geometryData.transform(transform);
                }
                featureRow = null;
                if (singleId == -1L) {
                    featureRow = featureDao.newRow();
                    featureRow.setGeometry(geometryData);
                    singleId = featureDao.insert(featureRow);
                    System.out.println();
                    System.out.println("Inserted Row Id: " + singleId);
                } else {
                    featureRow = (FeatureRow)featureDao.queryForIdRow(singleId);
                    if (featureRow != null) {
                        featureRow.setGeometry(geometryData);
                        featureDao.update(featureRow);
                        System.out.println();
                        System.out.println("Updated Row Id: " + singleId);
                    } else {
                        System.out.println("Error: No row found for feature table '" + tableName + "' with id '" + singleId + "'");
                    }
                }
                if (featureRow != null && (featureRow = (FeatureRow)featureDao.queryForIdRow(singleId)) != null) {
                    SQLExec.printGeometryData(database, featureDao, featureRow.getGeometry());
                }
            } else {
                StringBuilder sql = new StringBuilder("SELECT " + CoreSQLUtils.quoteWrap((String)featureDao.getGeometryColumnName()) + " FROM " + CoreSQLUtils.quoteWrap((String)tableName));
                if (ids != null) {
                    sql.append(" WHERE " + CoreSQLUtils.quoteWrap((String)featureDao.getIdColumnName()) + " IN (" + ids + ")");
                }
                geometryData = null;
                if (singleId != null && (featureRow = (FeatureRow)featureDao.queryForIdRow(singleId)) != null) {
                    GeometryTransform transform;
                    geometryData = featureRow.getGeometry();
                    if (projection != null && !(transform = GeometryTransform.create((Projection)featureDao.getProjection(), projection)).isSameProjection()) {
                        geometryData = geometryData.transform(transform);
                    }
                }
                SQLExec.printGeometryDataHeader(database, featureDao, geometryData, projection);
                SQLExec.executeSQL(database, sqlBuilder, sql.toString(), projection, 0x7FFFFFFE, 0, 0, history, false, false);
            }
        }
        SQLExec.resetCommandPrompt(sqlBuilder);
    }

    private static void reproject(GeoPackage database, StringBuilder sqlBuilder, Integer maxColumnWidth, Integer maxLinesPerRow, List<String> history, String args) throws SQLException, IOException {
        String[] parts = args.trim().split("\\s+");
        boolean valid = true;
        String tableName = null;
        Projection projection = null;
        TileReprojectionOptimize optimize = null;
        String reprojectTable = null;
        List<Long> zooms = null;
        block6: for (int i = 0; valid && i < parts.length; ++i) {
            String arg = parts[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "z": {
                        if (i + 1 < parts.length) {
                            String zoomLevelsArugment;
                            if ((zooms = TileReproject.parseZoomLevels(zoomLevelsArugment = parts[++i])) != null) continue block6;
                            valid = false;
                            System.out.println("Error: Zoom Levels argument '" + arg + "' must be followed by a valid single zoom or zoom range. Invalid: " + zoomLevelsArugment);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Zoom Levels argument '" + arg + "' must be followed by a single zoom or zoom range");
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                    }
                }
                continue;
            }
            if (tableName == null) {
                tableName = arg;
                if (database.isTileTable(tableName)) continue;
                valid = false;
                if (tableName.isEmpty()) {
                    System.out.println("Error: Tile table required");
                    continue;
                }
                System.out.println("Error: '" + tableName + "' is not a tile table");
                continue;
            }
            if (projection == null) {
                optimize = TileReproject.parseOptimize(arg);
                if (optimize != null) {
                    projection = optimize.getProjection();
                    continue;
                }
                projection = SQLExec.getProjection(arg);
                continue;
            }
            if (reprojectTable == null) {
                reprojectTable = arg;
                if (!database.isTable(reprojectTable) || database.isTileTable(reprojectTable)) continue;
                valid = false;
                System.out.println("Error: '" + reprojectTable + "' is not a tile table");
                continue;
            }
            valid = false;
            System.out.println("Error: Unexpected additional argument '" + arg + "' for reprojection");
        }
        if (valid && projection == null) {
            valid = false;
            System.out.println("Error: Tile table and projection / optimization required");
        }
        if (valid) {
            if (reprojectTable == null) {
                reprojectTable = tableName;
            }
            TileReprojection tileReprojection = TileReprojection.create(database, tableName, reprojectTable, projection);
            tileReprojection.setOverwrite(true);
            if (optimize != null) {
                tileReprojection.setOptimize(optimize);
            }
            int count = 0;
            count = zooms != null ? tileReprojection.reproject(zooms) : tileReprojection.reproject();
            System.out.println();
            System.out.println("Tiles Reprojected: " + count);
            SQLExec.geoPackageTableInfo(database, sqlBuilder, maxColumnWidth, maxLinesPerRow, history, reprojectTable);
        }
        SQLExec.resetCommandPrompt(sqlBuilder);
    }

    private static void printGeometryData(GeoPackage database, FeatureDao featureDao, GeoPackageGeometryData geometryData) throws SQLException {
        SQLExec.printGeometryDataHeader(database, featureDao, geometryData, null);
        System.out.println();
        System.out.println(geometryData.getWkt());
    }

    private static void printGeometryDataHeader(GeoPackage database, FeatureDao featureDao, GeoPackageGeometryData geometryData, Projection projection) throws SQLException {
        System.out.println();
        if (projection == null && geometryData != null) {
            int srsId = geometryData.getSrsId();
            SpatialReferenceSystem geometrySrs = database.getSpatialReferenceSystemDao().queryForId(Long.valueOf(srsId));
            if (geometrySrs != null) {
                projection = geometrySrs.getProjection();
            }
        }
        if (projection != null) {
            System.out.println("Projection: " + projection);
        }
        Projection featureProjection = featureDao.getProjection();
        if (projection == null || !projection.equals((Object)featureProjection)) {
            if (projection != null) {
                System.out.print("Table ");
            }
            System.out.println("Projection: " + featureProjection);
        }
        if (geometryData != null) {
            Geometry geometry;
            GeometryEnvelope builtEnvelope;
            GeometryEnvelope envelope = geometryData.getEnvelope();
            if (envelope != null) {
                System.out.print("Geometry ");
                SQLExec.printGeometryEnvelope(envelope);
            }
            if (!((builtEnvelope = (geometry = geometryData.getGeometry()).getEnvelope()) == null || envelope != null && envelope.equals((Object)builtEnvelope))) {
                System.out.print("Calculated ");
                SQLExec.printGeometryEnvelope(builtEnvelope);
            }
        }
    }

    private static void printGeometryEnvelope(GeometryEnvelope envelope) {
        System.out.println("Envelope");
        System.out.println("   min x: " + envelope.getMinX());
        System.out.println("   min y: " + envelope.getMinY());
        System.out.println("   max x: " + envelope.getMaxX());
        System.out.println("   max y: " + envelope.getMaxY());
        if (envelope.hasZ()) {
            System.out.println("   min z: " + envelope.getMinZ());
            System.out.println("   max z: " + envelope.getMaxZ());
        }
        if (envelope.hasM()) {
            System.out.println("   min m: " + envelope.getMinM());
            System.out.println("   max m: " + envelope.getMaxM());
        }
    }

    private static Projection getProjection(String argument) {
        return ProjectionFactory.getProjection((String)argument);
    }

    private static void bounds(GeoPackage database, StringBuilder sqlBuilder, BoundsType type, String args) {
        block31: {
            BoundingBox bounds;
            Projection projection;
            String table;
            block33: {
                boolean manual;
                block32: {
                    boolean valid = true;
                    table = null;
                    projection = null;
                    manual = false;
                    if (args != null && !args.isEmpty()) {
                        String[] argParts = args.trim().split("\\s+");
                        block18: for (int i = 0; valid && i < argParts.length; ++i) {
                            String arg = argParts[i];
                            if (arg.startsWith(ARGUMENT_PREFIX)) {
                                String argument;
                                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                                    case "p": {
                                        if (i + 1 < argParts.length) {
                                            String projectionArugment;
                                            if ((projection = SQLExec.getProjection(projectionArugment = argParts[++i])) != null) continue block18;
                                            valid = false;
                                            break;
                                        }
                                        valid = false;
                                        System.out.println("Error: Projection argument '" + arg + "' must be followed by 'authority:code' or 'epsg_code'");
                                        break;
                                    }
                                    case "m": {
                                        if (type == BoundsType.CONTENTS) {
                                            valid = false;
                                            System.out.println("Error: Unsupported arg: '" + arg + "'");
                                            break;
                                        }
                                        manual = true;
                                        break;
                                    }
                                    default: {
                                        valid = false;
                                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                                    }
                                }
                                continue;
                            }
                            if (table == null) {
                                table = arg;
                                if (database.isContentsTable(table)) continue;
                                valid = false;
                                System.out.println("Error: Not a contents table: '" + table + "'");
                                continue;
                            }
                            valid = false;
                            System.out.println("Error: Unsupported arg: '" + arg + "'");
                        }
                    }
                    if (!valid) break block31;
                    bounds = null;
                    if (table == null) break block32;
                    switch (type) {
                        case CONTENTS: {
                            if (projection != null) {
                                bounds = database.getContentsBoundingBox(projection, table);
                            } else {
                                bounds = database.getContentsBoundingBox(table);
                                projection = database.getContentsProjection(table);
                            }
                            break block33;
                        }
                        case ALL: {
                            if (projection != null) {
                                bounds = database.getBoundingBox(projection, table, manual);
                            } else {
                                bounds = database.getBoundingBox(table, manual);
                                projection = database.getProjection(table);
                            }
                            break block33;
                        }
                        case TABLE: {
                            if (projection != null) {
                                bounds = database.getTableBoundingBox(projection, table, manual);
                            } else {
                                bounds = database.getTableBoundingBox(table, manual);
                                projection = database.getProjection(table);
                            }
                            break block33;
                        }
                        default: {
                            throw new GeoPackageException("Unsupported type: " + type);
                        }
                    }
                }
                if (projection == null) {
                    projection = ProjectionFactory.getProjection((long)4326L);
                }
                switch (type) {
                    case CONTENTS: {
                        bounds = database.getContentsBoundingBox(projection);
                        break;
                    }
                    case ALL: {
                        bounds = database.getBoundingBox(projection, manual);
                        break;
                    }
                    case TABLE: {
                        bounds = database.getTableBoundingBox(projection, manual);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported type: " + type);
                    }
                }
            }
            SQLExec.printBounds(table, projection, bounds);
        }
        SQLExec.resetCommandPrompt(sqlBuilder);
    }

    private static void printBounds(String table, Projection projection, BoundingBox bounds) {
        SQLExecResult result = new SQLExecResult();
        result.addTable(table);
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("Projection");
        columns.add("Min Longitude");
        columns.add("Min Latitude");
        columns.add("Max Longitude");
        columns.add("Max Latitude");
        result.addColumns(columns);
        int[] columnWidths = new int[columns.size()];
        for (int i = 0; i < columnWidths.length; ++i) {
            columnWidths[i] = ((String)columns.get(i)).length();
        }
        String proj = null;
        if (projection != null) {
            proj = projection.getAuthority() + ":" + projection.getCode();
        }
        String minLon = null;
        String minLat = null;
        String maxLon = null;
        String maxLat = null;
        if (bounds != null) {
            DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            df.setMaximumFractionDigits(340);
            minLon = df.format(bounds.getMinLongitude());
            minLat = df.format(bounds.getMinLatitude());
            maxLon = df.format(bounds.getMaxLongitude());
            maxLat = df.format(bounds.getMaxLatitude());
        }
        ArrayList<String> row = new ArrayList<String>();
        row.add(proj);
        row.add(minLon);
        row.add(minLat);
        row.add(maxLon);
        row.add(maxLat);
        result.addRow(row);
        for (int i = 0; i < columnWidths.length; ++i) {
            String value = (String)row.get(i);
            if (value == null) continue;
            columnWidths[i] = Math.max(columnWidths[i], value.length());
        }
        result.addColumnWidths(columnWidths);
        result.printResults();
    }

    private static void dgiwg(GeoPackage database) {
        GeoPackageFileName fileName = new GeoPackageFileName(database.getPath());
        System.out.println();
        System.out.println("DGIWG GeoPackage");
        System.out.println(fileName.info());
        DGIWGGeoPackage dgiwg = new DGIWGGeoPackage(database);
        DGIWGValidationErrors errors = dgiwg.validate();
        System.out.println();
        if (errors.hasErrors()) {
            System.out.println("DGIWG Validation Errors (" + errors.numErrors() + "):");
            System.out.println();
            System.out.println(errors);
        } else {
            System.out.println("Passed DGIWG validation");
        }
        System.out.println();
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[-m max_rows] [-w max_column_width] [-l max_lines_per_row] [-dgiwg] sqlite_file [sql]");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tExecutes SQL on a SQLite database");
        System.out.println();
        System.out.println("\tProvide the SQL to execute a single statement. Omit to start an interactive session.");
        System.out.println();
        System.out.println("ARGUMENTS");
        System.out.println();
        System.out.println("\t-m max_rows");
        System.out.println("\t\tMax rows per query (Default is " + SQLExec.printableValue(100) + ")");
        System.out.println();
        System.out.println("\t-w max_column_width");
        System.out.println("\t\tMax width (in characters) per column (Default is " + SQLExec.printableValue(DEFAULT_MAX_COLUMN_WIDTH) + ")");
        System.out.println();
        System.out.println("\t-l max_lines_per_row");
        System.out.println("\t\tMax lines per row (Default is " + SQLExec.printableValue(DEFAULT_MAX_LINES_PER_ROW) + ")");
        System.out.println();
        System.out.println("\t-dgiwg");
        System.out.println("\t\tDGIWG GeoPackage Profile validation");
        System.out.println();
        System.out.println("\tsqlite_file");
        System.out.println("\t\tpath to the SQLite database file");
        System.out.println();
        System.out.println("\tsql");
        System.out.println("\t\tSQL statement to execute");
        System.out.println();
    }

    private static String printableValue(Integer value) {
        return value != null && value > 0 ? value.toString() : "0 = none";
    }

    public static boolean isGeoPackage(GeoPackage database) {
        return GeoPackageValidate.hasMinimumTables((GeoPackageCore)database);
    }

    private static enum BoundsType {
        CONTENTS,
        ALL,
        TABLE;

    }
}

