/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;

public abstract class CommonByteReader
implements AutoCloseable {
    private final File file;
    private final FileInputStream fis;
    private final FileChannel fc;
    private final MappedByteBuffer byteBuffer;
    private boolean isClosed = false;

    protected CommonByteReader(File f) throws IOException {
        Objects.requireNonNull(f, "The file cannot be null.");
        this.file = f;
        this.fis = new FileInputStream(this.file);
        this.fc = this.fis.getChannel();
        this.byteBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.fc.size());
    }

    @Override
    public void close() throws IOException {
        if (this.fc != null) {
            this.fc.close();
        }
        if (this.fis != null) {
            this.fis.close();
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public MappedByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public File getFile() {
        return this.file;
    }
}

