/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.HashMap;
import java.util.Map;
import mil.nga.crs.CRSException;
import mil.nga.crs.common.Unit;
import mil.nga.crs.common.UnitType;

public enum Units {
    MICROMETRE(UnitType.LENGTHUNIT, "micrometre", 1.0E-6),
    MILLIMETRE(UnitType.LENGTHUNIT, "millimetre", 0.001),
    METRE(UnitType.LENGTHUNIT, "metre", 1.0),
    KILOMETRE(UnitType.LENGTHUNIT, "kilometre", 1000.0),
    GERMAN_LEGAL_METRE(UnitType.LENGTHUNIT, "German legal metre", 1.0000135965),
    US_SURVEY_FOOT(UnitType.LENGTHUNIT, "US survey foot", 0.304800609601219),
    FOOT(UnitType.LENGTHUNIT, "foot", 0.3048),
    MICRORADIAN(UnitType.ANGLEUNIT, "microradian", 1.0E-6),
    MILLIRADIAN(UnitType.ANGLEUNIT, "milliradian", 0.001),
    RADIAN(UnitType.ANGLEUNIT, "radian", 1.0),
    ARC_SECOND(UnitType.ANGLEUNIT, "arc-second", 4.84813681109536E-6),
    ARC_MINUTE(UnitType.ANGLEUNIT, "arc-minute", 2.908882086657216E-4),
    DEGREE(UnitType.ANGLEUNIT, "degree", Math.PI / 180),
    GRAD(UnitType.ANGLEUNIT, "grad", 0.015707963267949),
    UNITY(UnitType.SCALEUNIT, "unity", 1.0),
    BIN(UnitType.SCALEUNIT, "bin", 1.0),
    PARTS_PER_MILLION(UnitType.SCALEUNIT, "parts per million", 1.0E-6),
    PASCAL(UnitType.PARAMETRICUNIT, "pascal", 1.0),
    HECTOPASCAL(UnitType.PARAMETRICUNIT, "hectopascal", 100.0),
    MICROSECOND(UnitType.TIMEUNIT, "microsecond", 1.0E-6),
    MILLISECOND(UnitType.TIMEUNIT, "millisecond", 0.001),
    SECOND(UnitType.TIMEUNIT, "second", 1.0),
    MINUTE(UnitType.TIMEUNIT, "minute", 60.0),
    HOUR(UnitType.TIMEUNIT, "hour", 3600.0),
    DAY(UnitType.TIMEUNIT, "day", 86400.0),
    YEAR(UnitType.TIMEUNIT, "year", 3.15576E7),
    CALENDAR_SECOND(UnitType.TIMEUNIT, "calendar second"),
    CALENDAR_MONTH(UnitType.TIMEUNIT, "calendar month");

    private static final Map<String, Units> nameTypes;
    private final UnitType type;
    private final String name;
    private final Double conversionFactor;

    private Units(UnitType type, String name) {
        this.type = type;
        this.name = name;
        this.conversionFactor = null;
    }

    private Units(UnitType type, String name, double conversionFactor) {
        this.type = type;
        this.name = name;
        this.conversionFactor = conversionFactor;
    }

    public UnitType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasConversionFactor() {
        return this.conversionFactor != null;
    }

    public Double getConversionFactor() {
        return this.conversionFactor;
    }

    public Unit createUnit() {
        Unit unit = null;
        unit = this.hasConversionFactor() ? new Unit(this.type, this.name, this.conversionFactor) : new Unit(this.type, this.name);
        return unit;
    }

    public static Units fromName(String name) {
        return nameTypes.get(name.toLowerCase());
    }

    public static Units fromUnit(Unit unit) {
        return Units.fromName(unit.getName());
    }

    public static UnitType getUnitType(String name) {
        UnitType type = null;
        Units unit = Units.fromName(name);
        if (unit != null) {
            type = unit.getType();
        }
        return type;
    }

    public static Units getDefaultUnit(UnitType type) {
        Units defaultUnit = null;
        switch (type) {
            case LENGTHUNIT: {
                defaultUnit = METRE;
                break;
            }
            case ANGLEUNIT: {
                defaultUnit = DEGREE;
                break;
            }
            case SCALEUNIT: {
                defaultUnit = UNITY;
                break;
            }
        }
        return defaultUnit;
    }

    public static Unit createDefaultUnit(UnitType type) {
        Unit defaultUnit = null;
        Units defaultUnits = Units.getDefaultUnit(type);
        if (defaultUnits != null) {
            defaultUnit = defaultUnits.createUnit();
        }
        return defaultUnit;
    }

    public static boolean canConvert(Unit unit1, Unit unit2) {
        return unit1 != null && unit2 != null && (unit1.getType() == unit2.getType() || unit1.getType() == UnitType.UNIT || unit2.getType() == UnitType.UNIT) && unit1.hasConversionFactor() && unit2.hasConversionFactor();
    }

    public static double convert(double value, Unit from, Unit to) {
        if (from.getType() != to.getType() && from.getType() != UnitType.UNIT && to.getType() != UnitType.UNIT) {
            throw new CRSException("Can't convert value '" + value + "' from unit type " + from.getType().name() + " to unit type " + to.getType().name());
        }
        if (!from.hasConversionFactor()) {
            throw new CRSException("Can't convert value '" + value + "' from unit type " + from.getType().name() + " without a conversion factor.");
        }
        if (!to.hasConversionFactor()) {
            throw new CRSException("Can't convert value '" + value + "' to unit type " + to.getType().name() + " without a conversion factor.");
        }
        return value * (from.getConversionFactor() / to.getConversionFactor());
    }

    public static boolean canConvert(Units unit1, Units unit2) {
        return Units.canConvert(unit1.createUnit(), unit2.createUnit());
    }

    public static double convert(double value, Units from, Units to) {
        return Units.convert(value, from.createUnit(), to.createUnit());
    }

    static {
        nameTypes = new HashMap<String, Units>();
        for (Units type : Units.values()) {
            String lowercase = type.getName().toLowerCase();
            nameTypes.put(lowercase, type);
            if (!lowercase.contains("metre")) continue;
            nameTypes.put(lowercase.replaceAll("metre", "meter"), type);
        }
    }
}

