/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.util.Version;
import org.apache.sis.util.internal.Strings;

public class ProbeResult
implements Serializable {
    private static final long serialVersionUID = -4977853847503500550L;
    public static final ProbeResult SUPPORTED = new Constant(true, "SUPPORTED");
    public static final ProbeResult UNSUPPORTED_STORAGE = new Constant(false, "UNSUPPORTED_STORAGE");
    public static final ProbeResult INSUFFICIENT_BYTES = new Constant(false, "INSUFFICIENT_BYTES");
    public static final ProbeResult UNDETERMINED = new Constant(false, "UNDETERMINED");
    private final boolean isSupported;
    private final String mimeType;
    private final Version version;

    public ProbeResult(boolean isSupported, String mimeType, Version version) {
        this.isSupported = isSupported;
        this.mimeType = mimeType;
        this.version = version;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.isSupported, this.mimeType, this.version) ^ 0xABBE0AFA;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ProbeResult other = (ProbeResult)object;
            return this.isSupported == other.isSupported && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.version, other.version);
        }
        return false;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"isSupported", this.isSupported, "mimeType", this.mimeType, "version", this.version});
    }

    private static final class Constant
    extends ProbeResult {
        private static final long serialVersionUID = -5239064423134309133L;
        private final String name;

        Constant(boolean isSupported, String name) {
            super(isSupported, null, null);
            this.name = name;
        }

        Object readResolve() throws ObjectStreamException {
            try {
                return ProbeResult.class.getField(this.name).get(null);
            }
            catch (ReflectiveOperationException e) {
                return this;
            }
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Constant && this.name.equals(((Constant)object).name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() ^ 0x37B154F3;
        }

        @Override
        public String toString() {
            return Strings.bracket(ProbeResult.class, (Object)this.name);
        }
    }
}

