/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import java.util.logging.Logger;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.provider.AbridgedMolodensky;
import org.apache.sis.referencing.operation.provider.Affine;
import org.apache.sis.referencing.operation.provider.DatumShiftMethod;
import org.apache.sis.referencing.operation.provider.GeocentricTranslation;
import org.apache.sis.referencing.operation.provider.GeocentricTranslation2D;
import org.apache.sis.referencing.operation.provider.GeocentricTranslation3D;
import org.apache.sis.referencing.operation.provider.GeodeticOperation;
import org.apache.sis.referencing.operation.provider.Geographic2Dto3D;
import org.apache.sis.referencing.operation.provider.Geographic3Dto2D;
import org.apache.sis.referencing.operation.provider.Molodensky;
import org.apache.sis.referencing.operation.provider.PositionVector7Param;
import org.apache.sis.referencing.operation.provider.PositionVector7Param2D;
import org.apache.sis.referencing.operation.provider.PositionVector7Param3D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public abstract class GeocentricAffine
extends GeodeticOperation {
    private static final long serialVersionUID = 5597594719123422532L;
    private static final double BURSAWOLF_TOLERANCE = 1.0E-6;
    public static final ParameterDescriptor<Double> TX;
    public static final ParameterDescriptor<Double> TY;
    public static final ParameterDescriptor<Double> TZ;
    static final ParameterDescriptor<Double> RX;
    static final ParameterDescriptor<Double> RY;
    static final ParameterDescriptor<Double> RZ;
    static final ParameterDescriptor<Double> DS;
    private final Type type;

    private static ParameterDescriptor<Double> createRotation(ParameterBuilder builder, String name, String alias) {
        return ((ParameterBuilder)((ParameterBuilder)builder.addName(name)).addName((Citation)Citations.OGC, alias)).createBounded(-648000.0, 648000.0, 0.0, Units.ARC_SECOND);
    }

    @Deprecated
    GeocentricAffine(GeocentricAffine copy) {
        super(copy);
        this.type = copy.type;
    }

    GeocentricAffine(Type operationType, ParameterDescriptorGroup parameters, int indexOfDim, Class<? extends CoordinateSystem> sourceCSType, boolean sourceOnEllipsoid, Class<? extends CoordinateSystem> targetCSType, boolean targetOnEllipsoid) {
        super(operationType == Type.CONVERSION ? Conversion.class : Transformation.class, parameters, indexOfDim, sourceCSType, sourceOnEllipsoid, targetCSType, targetOnEllipsoid);
        this.type = operationType;
    }

    GeocentricAffine(Type operationType, ParameterDescriptorGroup parameters) {
        this(operationType, parameters, 3, CartesianCS.class, false, CartesianCS.class, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        BursaWolfParameters parameters = new BursaWolfParameters(null, null);
        Parameters pv = Parameters.castOrWrap(values);
        boolean reverseRotation = false;
        switch (this.type) {
            default: {
                throw new AssertionError((Object)this.type);
            }
            case FRAME_ROTATION: {
                reverseRotation = true;
            }
            case SEVEN_PARAM: {
                parameters.rX = pv.doubleValue(RX);
                parameters.rY = pv.doubleValue(RY);
                parameters.rZ = pv.doubleValue(RZ);
                parameters.dS = pv.doubleValue(DS);
            }
            case TRANSLATION: 
        }
        parameters.tX = pv.doubleValue(TX);
        parameters.tY = pv.doubleValue(TY);
        parameters.tZ = pv.doubleValue(TZ);
        if (reverseRotation) {
            parameters.reverseRotation();
        }
        return MathTransforms.linear(parameters.getPositionVectorTransformation(null));
    }

    private static Parameters createParameters(ParameterDescriptorGroup descriptor, BursaWolfParameters parameters, boolean isTranslation) {
        Parameters values = Parameters.castOrWrap(descriptor.createValue());
        values.getOrCreate(TX).setValue(parameters.tX);
        values.getOrCreate(TY).setValue(parameters.tY);
        values.getOrCreate(TZ).setValue(parameters.tZ);
        if (!isTranslation) {
            values.getOrCreate(RX).setValue(parameters.rX);
            values.getOrCreate(RY).setValue(parameters.rY);
            values.getOrCreate(RZ).setValue(parameters.rZ);
            values.getOrCreate(DS).setValue(parameters.dS);
        }
        return values;
    }

    public static ParameterValueGroup createParameters(CoordinateSystem sourceCS, CoordinateSystem targetCS, Matrix datumShift, DatumShiftMethod method) {
        ParameterDescriptorGroup descriptor;
        boolean isEllipsoidal = sourceCS instanceof EllipsoidalCS;
        if (!(!isEllipsoidal ? targetCS instanceof CartesianCS && sourceCS instanceof CartesianCS : targetCS instanceof EllipsoidalCS)) {
            return null;
        }
        int dimension = sourceCS.getDimension();
        if (dimension != targetCS.getDimension()) {
            dimension = 4;
        }
        if (method == DatumShiftMethod.NONE) {
            if (dimension <= 3) {
                return Affine.identity(dimension);
            }
            if (isEllipsoidal) {
                ParameterDescriptorGroup descriptor2;
                switch (sourceCS.getDimension()) {
                    case 2: {
                        descriptor2 = Geographic2Dto3D.PARAMETERS;
                        break;
                    }
                    case 3: {
                        descriptor2 = Geographic3Dto2D.PARAMETERS;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return descriptor2.createValue();
            }
            return null;
        }
        BursaWolfParameters parameters = new BursaWolfParameters(null, null);
        if (datumShift != null) {
            try {
                parameters.setPositionVectorTransformation(datumShift, 1.0E-6);
            }
            catch (IllegalArgumentException e) {
                GeocentricAffine.recoverableException(GeocentricAffine.class, e);
                return null;
            }
        } else {
            method = DatumShiftMethod.ABRIDGED_MOLODENSKY;
        }
        boolean isTranslation = parameters.isTranslation();
        if (!isEllipsoidal) {
            method = DatumShiftMethod.GEOCENTRIC_DOMAIN;
            descriptor = isTranslation ? GeocentricTranslation.PARAMETERS : PositionVector7Param.PARAMETERS;
        } else if (!isTranslation) {
            method = DatumShiftMethod.GEOCENTRIC_DOMAIN;
            descriptor = dimension >= 3 ? PositionVector7Param3D.PARAMETERS : PositionVector7Param2D.PARAMETERS;
        } else {
            switch (method) {
                case GEOCENTRIC_DOMAIN: {
                    descriptor = dimension >= 3 ? GeocentricTranslation3D.PARAMETERS : GeocentricTranslation2D.PARAMETERS;
                    break;
                }
                case MOLODENSKY: {
                    descriptor = Molodensky.PARAMETERS;
                    break;
                }
                case ABRIDGED_MOLODENSKY: {
                    descriptor = AbridgedMolodensky.PARAMETERS;
                    break;
                }
                default: {
                    throw new AssertionError((Object)method);
                }
            }
        }
        Parameters values = GeocentricAffine.createParameters(descriptor, parameters, isTranslation);
        switch (method) {
            case MOLODENSKY: 
            case ABRIDGED_MOLODENSKY: {
                values.getOrCreate(Molodensky.DIMENSION).setValue(Math.min(dimension, 3));
            }
        }
        return values;
    }

    public static void asDatumShift(List<Object> transforms) {
        int i = transforms.size() - 2;
        while (--i >= 0) {
            Object step;
            if (!GeocentricAffine.isOperation("Ellipsoid_To_Geocentric", transforms.get(i)) || !GeocentricAffine.isOperation("Geocentric_To_Ellipsoid", transforms.get(i + 2)) || !((step = transforms.get(i + 1)) instanceof LinearTransform)) continue;
            BursaWolfParameters parameters = new BursaWolfParameters(null, null);
            try {
                parameters.setPositionVectorTransformation(((LinearTransform)step).getMatrix(), 1.0E-6);
            }
            catch (IllegalArgumentException e) {
                Logging.recoverableException((Logger)WKTUtilities.LOGGER, GeocentricAffine.class, (String)"asDatumShift", (Throwable)e);
                continue;
            }
            boolean isTranslation = parameters.isTranslation();
            final Parameters values = GeocentricAffine.createParameters(isTranslation ? GeocentricTranslation.PARAMETERS : PositionVector7Param.PARAMETERS, parameters, isTranslation);
            transforms.set(i + 1, new FormattableObject(){

                @Override
                protected String formatTo(Formatter formatter) {
                    WKTUtilities.appendParamMT(values, formatter);
                    return "Param_MT";
                }
            });
        }
    }

    private static boolean isOperation(String expected, Object actual) {
        return actual instanceof Parameterized && IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)((Parameterized)actual).getParameterDescriptors(), expected);
    }

    static {
        ParameterBuilder builder = GeocentricAffine.builder();
        TX = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8605")).addName("X-axis translation")).addName((Citation)Citations.OGC, "dx"));
        TY = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8606")).addName("Y-axis translation")).addName((Citation)Citations.OGC, "dy"));
        TZ = GeocentricAffine.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8607")).addName("Z-axis translation")).addName((Citation)Citations.OGC, "dz"));
        RX = GeocentricAffine.createRotation((ParameterBuilder)builder.addIdentifier("8608"), "X-axis rotation", "ex");
        RY = GeocentricAffine.createRotation((ParameterBuilder)builder.addIdentifier("8609"), "Y-axis rotation", "ey");
        RZ = GeocentricAffine.createRotation((ParameterBuilder)builder.addIdentifier("8610"), "Z-axis rotation", "ez");
        DS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8611")).addName("Scale difference")).addName((Citation)Citations.OGC, "ppm")).create(0.0, Units.PPM);
    }

    protected static enum Type {
        TRANSLATION,
        SEVEN_PARAM,
        FRAME_ROTATION,
        MOLODENSKY,
        CONVERSION;

    }
}

