/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.runtime.interop.JavaScriptLanguageView;

@GeneratedBy(value=JavaScriptLanguageView.class)
final class JavaScriptLanguageViewGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private JavaScriptLanguageViewGen() {
    }

    static {
        LibraryExport.register(JavaScriptLanguageView.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JavaScriptLanguageView.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet(INTEROP_LIBRARY_, (String[])new String[]{"hasLanguage", "getLanguage", "toDisplayString", "hasMetaObject", "getMetaObject"});
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, JavaScriptLanguageView.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JavaScriptLanguageView);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)UNCACHED);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JavaScriptLanguageView);
            return (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=JavaScriptLanguageView.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((JavaScriptLanguageView)receiver_).delegate;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JavaScriptLanguageView) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JavaScriptLanguageView;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptLanguageView)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptLanguageView)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptLanguageView)receiver).toDisplayString(allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JavaScriptLanguageView arg0Value = (JavaScriptLanguageView)arg0Value_;
                return arg0Value.hasMetaObject((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.delegate));
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JavaScriptLanguageView arg0Value = (JavaScriptLanguageView)arg0Value_;
                return arg0Value.getMetaObject((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.delegate));
            }
        }

        @GeneratedBy(value=JavaScriptLanguageView.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverDelegateInteropLibrary_;

            protected Cached(Object receiver) {
                JavaScriptLanguageView castReceiver = (JavaScriptLanguageView)receiver;
                this.receiverDelegateInteropLibrary_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(castReceiver.delegate)));
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((JavaScriptLanguageView)receiver_).delegate;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverDelegateInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JavaScriptLanguageView) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof JavaScriptLanguageView)) {
                    return false;
                }
                return this.receiverDelegateInteropLibrary_.accepts(((JavaScriptLanguageView)receiver).delegate);
            }

            public boolean hasLanguage(Object receiver) {
                assert (receiver instanceof JavaScriptLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptLanguageView)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof JavaScriptLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptLanguageView)receiver).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (receiver instanceof JavaScriptLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptLanguageView)receiver).toDisplayString(allowSideEffects);
            }

            public boolean hasMetaObject(Object arg0Value_) {
                assert (arg0Value_ instanceof JavaScriptLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                JavaScriptLanguageView arg0Value = (JavaScriptLanguageView)arg0Value_;
                InteropLibrary delegateLibrary__ = this.receiverDelegateInteropLibrary_;
                return arg0Value.hasMetaObject(delegateLibrary__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public Object getMetaObject(Object arg0Value_) throws UnsupportedMessageException {
                assert (arg0Value_ instanceof JavaScriptLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                JavaScriptLanguageView arg0Value = (JavaScriptLanguageView)arg0Value_;
                InteropLibrary delegateLibrary__ = this.receiverDelegateInteropLibrary_;
                return arg0Value.getMetaObject(delegateLibrary__);
            }
        }
    }
}

