/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainDateFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalPlainDateFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainDateFunction> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainDateFunctionBuiltins();

    protected TemporalPlainDateFunctionBuiltins() {
        super(JSTemporalPlainDate.CLASS_NAME, TemporalPlainDateFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainDateFunction builtinEnum) {
        switch (builtinEnum) {
            case from: {
                return TemporalPlainDateFunctionBuiltinsFactory.JSTemporalPlainDateFromNodeGen.create(context, builtin, TemporalPlainDateFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case compare: {
                return TemporalPlainDateFunctionBuiltinsFactory.JSTemporalPlainDateCompareNodeGen.create(context, builtin, TemporalPlainDateFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainDateFunction implements BuiltinEnum<TemporalPlainDateFunction>
    {
        from(1),
        compare(2);

        private final int length;

        private TemporalPlainDateFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSTemporalPlainDateFromNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainDateFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateObject from(Object item, Object optParam, @Cached TemporalGetOptionNode getOptionNode, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            if (this.isObject(item) && JSTemporalPlainDate.isJSTemporalPlainDate(item)) {
                JSTemporalPlainDateObject dtItem = (JSTemporalPlainDateObject)item;
                TemporalUtil.toTemporalOverflow(options, getOptionNode);
                return JSTemporalPlainDate.create(this.getContext(), dtItem.getYear(), dtItem.getMonth(), dtItem.getDay(), dtItem.getCalendar(), this, errorBranch);
            }
            return toTemporalDate.execute(item, options);
        }
    }

    public static abstract class JSTemporalPlainDateCompareNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainDateCompareNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int compare(Object obj1, Object obj2, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            JSTemporalPlainDateObject one = toTemporalDate.execute(obj1, Undefined.instance);
            JSTemporalPlainDateObject two = toTemporalDate.execute(obj2, Undefined.instance);
            return TemporalUtil.compareISODate(one.getYear(), one.getMonth(), one.getDay(), two.getYear(), two.getMonth(), two.getDay());
        }
    }
}

