/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.geotiff.DeferredEntry;
import org.apache.sis.storage.geotiff.GeoTIFF;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.ImageFileDirectory;
import org.apache.sis.storage.geotiff.MultiResolutionImage;
import org.apache.sis.storage.geotiff.Tags;
import org.apache.sis.storage.geotiff.Type;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.util.NameFactory;

final class Reader
extends GeoTIFF {
    final ChannelDataInput input;
    final long origin;
    final byte intSizeExpansion;
    private ImageFileDirectory lastIFD;
    private long nextIFD;
    private final Set<Long> doneIFD;
    private final List<GridCoverageResource> images = new ArrayList<GridCoverageResource>();
    private final LinkedList<DeferredEntry> deferredEntries = new LinkedList();
    private boolean deferredNeedsSort;
    final NameFactory nameFactory;

    Reader(GeoTiffStore store, ChannelDataInput input) throws IOException, DataStoreException {
        super(store);
        boolean isBigEndian;
        this.input = input;
        this.origin = input.getStreamPosition();
        this.doneIFD = new HashSet<Long>();
        this.nameFactory = DefaultNameFactory.provider();
        short order = input.readShort();
        boolean bl = isBigEndian = order == 19789;
        if (isBigEndian || order == 18761) {
            input.buffer.order(isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            switch (input.readShort()) {
                case 42: {
                    this.intSizeExpansion = 0;
                    this.readNextImageOffset();
                    return;
                }
                case 43: {
                    int numBits = input.readUnsignedShort();
                    int powerOf2 = Integer.numberOfTrailingZeros(numBits);
                    if ((long)numBits != 1L << powerOf2 || input.readShort() != 0) break;
                    this.intSizeExpansion = (byte)(powerOf2 - 2);
                    if (this.intSizeExpansion != 1) break;
                    this.readNextImageOffset();
                    return;
                }
            }
        }
        throw new DataStoreContentException(store.errors().getString((short)139, (Object)"TIFF", (Object)input.filename));
    }

    private void readNextImageOffset() throws IOException, DataStoreException {
        this.nextIFD = this.readUnsignedInt();
        if (!this.doneIFD.add(this.nextIFD)) {
            throw new DataStoreContentException(this.resources().getString((short)1, this.input.filename));
        }
    }

    private long readUnsignedInt() throws IOException, DataStoreException {
        if (this.intSizeExpansion == 0) {
            return this.input.readUnsignedInt();
        }
        long pointer = this.input.readLong();
        if (pointer >= 0L) {
            return pointer;
        }
        throw new DataStoreContentException(this.store.getLocale(), "TIFF", this.input.filename, null);
    }

    private long readUnsignedShort() throws IOException, DataStoreException {
        if (this.intSizeExpansion == 0) {
            return this.input.readUnsignedShort();
        }
        long entry = this.input.readLong();
        if (entry >= 0L) {
            return entry;
        }
        throw new DataStoreContentException(this.store.getLocale(), "TIFF", this.input.filename, null);
    }

    private ImageFileDirectory getImageFileDirectory(int index) throws IOException, DataStoreException {
        if (this.nextIFD == 0L) {
            return null;
        }
        this.resolveDeferredEntries(null, this.nextIFD);
        this.input.seek(Math.addExact(this.origin, this.nextIFD));
        this.nextIFD = 0L;
        int offsetSize = 4 << this.intSizeExpansion;
        ImageFileDirectory dir = new ImageFileDirectory(this, index);
        long remaining = this.readUnsignedShort();
        while (--remaining >= 0L) {
            long size;
            short tag = (short)this.input.readUnsignedShort();
            Type type = Type.valueOf(this.input.readShort());
            long count = this.readUnsignedInt();
            long l = size = type != null ? Math.multiplyExact((long)type.size, count) : 0L;
            if (size <= (long)offsetSize) {
                long position = this.input.getStreamPosition();
                if (size != 0L) {
                    Object error;
                    try {
                        error = dir.addEntry(tag, type, count);
                    }
                    catch (IOException | DataStoreException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        error = e;
                    }
                    if (error != null) {
                        this.warning(tag, error);
                    }
                }
                this.input.seek(position + (long)offsetSize);
                continue;
            }
            this.deferredEntries.add(new DeferredEntry(dir, tag, type, count, this.readUnsignedInt()));
            dir.hasDeferredEntries = true;
            this.deferredNeedsSort = true;
        }
        this.readNextImageOffset();
        return dir;
    }

    final void resolveDeferredEntries(ImageFileDirectory dir) throws IOException, DataStoreException {
        if (dir.hasDeferredEntries) {
            this.resolveDeferredEntries(dir, Long.MAX_VALUE);
            dir.hasDeferredEntries = false;
        }
        dir.validateMandatoryTags();
    }

    private void resolveDeferredEntries(ImageFileDirectory dir, long ignoreAfter) throws IOException, DataStoreException {
        Iterator<DeferredEntry> it;
        if (this.deferredNeedsSort) {
            this.deferredEntries.sort(null);
            this.deferredNeedsSort = false;
        }
        long ignoreBefore = this.input.getStreamPosition() - this.origin;
        DeferredEntry stopAfter = null;
        if (dir != null) {
            it = this.deferredEntries.descendingIterator();
            while (it.hasNext()) {
                stopAfter = it.next();
                if (stopAfter.owner != dir) continue;
            }
        }
        it = this.deferredEntries.iterator();
        while (it.hasNext()) {
            DeferredEntry entry = it.next();
            if (entry.owner == dir || entry.offset >= ignoreBefore && entry.offset <= ignoreAfter) {
                Object error;
                this.input.seek(Math.addExact(this.origin, entry.offset));
                try {
                    error = entry.owner.addEntry(entry.tag, entry.type, entry.count);
                }
                catch (IOException | DataStoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    error = e;
                }
                if (error != null) {
                    this.warning(entry.tag, error);
                }
                it.remove();
            }
            if (entry != stopAfter) continue;
            break;
        }
    }

    final GridCoverageResource getImage(int index) throws IOException, DataStoreException {
        while (index >= this.images.size()) {
            ImageFileDirectory image;
            int imageIndex = this.images.size();
            ImageFileDirectory fullResolution = this.lastIFD;
            if (fullResolution == null && (fullResolution = this.getImageFileDirectory(imageIndex)) == null) {
                return null;
            }
            this.lastIFD = null;
            ++imageIndex;
            ArrayList<ImageFileDirectory> overviews = new ArrayList<ImageFileDirectory>();
            while ((image = this.getImageFileDirectory(imageIndex)) != null) {
                if (image.isReducedResolution()) {
                    overviews.add(image);
                    continue;
                }
                this.lastIFD = image;
                break;
            }
            if (overviews.isEmpty()) {
                this.images.add((GridCoverageResource)fullResolution);
                continue;
            }
            overviews.add(0, fullResolution);
            this.images.add((GridCoverageResource)new MultiResolutionImage(overviews));
        }
        GridCoverageResource image = this.images.get(index);
        if (image instanceof ImageFileDirectory) {
            this.resolveDeferredEntries((ImageFileDirectory)image);
        }
        return image;
    }

    private void warning(short tag, Object error) {
        Exception exception;
        Object[] args;
        short key;
        if (error instanceof Exception) {
            key = 15;
            args = new Object[1];
            exception = (Exception)error;
        } else {
            key = 146;
            args = new Object[2];
            args[1] = error;
            exception = null;
        }
        args[0] = Tags.name(tag);
        this.store.listeners().warning(this.errors().getString(key, (Object)args), exception);
    }

    @Override
    public void close() throws IOException {
        this.input.channel.close();
    }
}

