/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.j2d;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWithCRS;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.geometry.wrapper.j2d.Factory;
import org.apache.sis.geometry.wrapper.j2d.PointWrapper;
import org.apache.sis.geometry.wrapper.j2d.ShapeProperties;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.referencing.util.j2d.AbstractShape;
import org.apache.sis.referencing.util.j2d.ShapeUtilities;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;

final class Wrapper
extends GeometryWithCRS {
    final Shape geometry;
    private static final BiPredicate<Wrapper, Object>[] PREDICATES = new BiPredicate[SpatialOperatorName.OVERLAPS.ordinal() + 1];

    Wrapper(Shape geometry) {
        this.geometry = geometry;
    }

    protected Geometries<Shape> factory() {
        return Factory.INSTANCE;
    }

    @Override
    protected Object implementation() {
        return this.geometry;
    }

    private Area area() {
        return this.geometry instanceof Area ? (Area)this.geometry : new Area(this.geometry);
    }

    @Override
    public GeneralEnvelope getEnvelope() {
        Rectangle2D bounds = this.geometry.getBounds2D();
        GeneralEnvelope env = this.createEnvelope();
        env.setRange(0, bounds.getMinX(), bounds.getMaxX());
        env.setRange(1, bounds.getMinY(), bounds.getMaxY());
        return env;
    }

    @Override
    public DirectPosition getCentroid() {
        RectangularShape frame = this.geometry instanceof RectangularShape ? (RectangularShape)this.geometry : this.geometry.getBounds2D();
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), frame.getCenterX(), frame.getCenterY());
    }

    @Override
    public double[] getPointCoordinates() {
        return null;
    }

    @Override
    public double[] getAllCoordinates() {
        List<double[]> coordinates = new ShapeProperties(this.geometry).coordinatesAsDoubles();
        switch (coordinates.size()) {
            case 0: {
                return ArraysExt.EMPTY_DOUBLE;
            }
            case 1: {
                return coordinates.get(0);
            }
        }
        double[] tgt = new double[coordinates.stream().mapToInt(a -> ((double[])a).length).sum()];
        int p = 0;
        for (double[] src : coordinates) {
            System.arraycopy(src, 0, tgt, p, src.length);
            p += src.length;
        }
        return tgt;
    }

    @Override
    public Shape mergePolylines(Iterator<?> polylines) {
        return Wrapper.mergePolylines(this.geometry, polylines);
    }

    static Shape mergePolylines(Object next, Iterator<?> polylines) {
        boolean isFloat = AbstractShape.isFloat((Object)next);
        Path2D path = isFloat ? new Path2D.Float() : new Path2D.Double();
        boolean lineTo = false;
        block0: while (true) {
            if (next instanceof Point2D) {
                double x = ((Point2D)next).getX();
                double y = ((Point2D)next).getY();
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    lineTo = false;
                } else if (lineTo) {
                    path.lineTo(x, y);
                } else {
                    path.moveTo(x, y);
                    lineTo = true;
                }
            } else {
                path.append((Shape)next, false);
                lineTo = false;
            }
            while (polylines.hasNext()) {
                next = polylines.next();
                if (next == null) continue;
                if (!isFloat || AbstractShape.isFloat((Object)next)) continue block0;
                path = new Path2D.Double(path);
                isFloat = false;
                continue block0;
            }
            break;
        }
        return ShapeUtilities.toPrimitive((Shape)path);
    }

    @Override
    protected boolean predicateSameCRS(SpatialOperatorName type, GeometryWrapper other) {
        BiPredicate<Wrapper, Object> op;
        int ordinal = type.ordinal();
        if (ordinal >= 0 && ordinal < PREDICATES.length && (op = PREDICATES[ordinal]) != null) {
            return op.test(this, other);
        }
        return super.predicateSameCRS(type, other);
    }

    @Override
    protected Object operationSameCRS(SQLMM operation, GeometryWrapper other, Object argument) {
        Shape result;
        switch (operation) {
            case ST_Dimension: 
            case ST_CoordDim: {
                return 2;
            }
            case ST_Is3D: 
            case ST_IsMeasured: {
                return Boolean.FALSE;
            }
            case ST_IsEmpty: {
                if (this.geometry instanceof RectangularShape) {
                    return ((RectangularShape)this.geometry).isEmpty();
                }
                return this.geometry.getPathIterator(null).isDone();
            }
            case ST_Overlaps: 
            case ST_Intersects: {
                return this.intersect(other);
            }
            case ST_Disjoint: {
                return !this.intersect(other);
            }
            case ST_Contains: {
                return this.contain(other);
            }
            case ST_Within: {
                return this.within(other);
            }
            case ST_Equals: {
                return this.equal(other);
            }
            case ST_Envelope: {
                return this.getEnvelope();
            }
            case ST_Boundary: {
                result = this.geometry.getBounds2D();
                break;
            }
            case ST_Centroid: {
                RectangularShape frame = this.geometry instanceof RectangularShape ? (RectangularShape)this.geometry : this.geometry.getBounds2D();
                return new Point2D.Double(frame.getCenterX(), frame.getCenterY());
            }
            case ST_Intersection: {
                Area area = new Area(this.geometry);
                area.intersect(((Wrapper)other).area());
                result = area;
                break;
            }
            case ST_Union: {
                Area area = new Area(this.geometry);
                area.add(((Wrapper)other).area());
                result = area;
                break;
            }
            case ST_Difference: {
                Area area = new Area(this.geometry);
                area.subtract(((Wrapper)other).area());
                result = area;
                break;
            }
            case ST_SymDifference: {
                Area area = new Area(this.geometry);
                area.exclusiveOr(((Wrapper)other).area());
                result = area;
                break;
            }
            default: {
                return super.operationSameCRS(operation, other, argument);
            }
        }
        return result;
    }

    private boolean equal(Object wrapper) {
        if (wrapper instanceof Wrapper) {
            Shape other = ((Wrapper)wrapper).geometry;
            PathIterator it1 = this.geometry.getPathIterator(null);
            PathIterator it2 = other.getPathIterator(null);
            if (it1.getWindingRule() == it2.getWindingRule()) {
                double[] p1 = new double[6];
                double[] p2 = new double[6];
                block5: while (!it1.isDone()) {
                    int n;
                    if (it2.isDone()) {
                        return false;
                    }
                    int c = it1.currentSegment(p1);
                    if (c != it2.currentSegment(p2)) {
                        return false;
                    }
                    it1.next();
                    it2.next();
                    switch (c) {
                        case 4: {
                            continue block5;
                        }
                        case 0: 
                        case 1: {
                            n = 2;
                            break;
                        }
                        case 2: {
                            n = 4;
                            break;
                        }
                        default: {
                            n = 6;
                        }
                    }
                    if (Arrays.equals(p1, 0, n, p2, 0, n)) continue;
                    return false;
                }
                return it2.isDone();
            }
        }
        return false;
    }

    private boolean within(Object wrapper) {
        if (wrapper instanceof Wrapper) {
            Shape other = ((Wrapper)wrapper).geometry;
            return other.contains(this.geometry.getBounds2D());
        }
        return false;
    }

    private boolean contain(Object wrapper) {
        if (wrapper instanceof PointWrapper) {
            return this.geometry.contains(((PointWrapper)wrapper).point);
        }
        Shape other = ((Wrapper)wrapper).geometry;
        return this.geometry.contains(other.getBounds2D());
    }

    private boolean intersect(Object wrapper) {
        if (wrapper instanceof PointWrapper) {
            return this.geometry.contains(((PointWrapper)wrapper).point);
        }
        Shape other = ((Wrapper)wrapper).geometry;
        return this.geometry.intersects(other.getBounds2D()) && other.intersects(this.geometry.getBounds2D());
    }

    private boolean bbox(Object wrapper) {
        if (wrapper instanceof PointWrapper) {
            return this.geometry.contains(((PointWrapper)wrapper).point);
        }
        Shape other = ((Wrapper)wrapper).geometry;
        return this.geometry.intersects(other.getBounds2D());
    }

    @Override
    public String formatWKT(double flatness) {
        return new ShapeProperties(this.geometry).toWKT(flatness);
    }

    static {
        BiPredicate<Wrapper, Object> biPredicate = Wrapper::intersect;
        Wrapper.PREDICATES[SpatialOperatorName.INTERSECTS.ordinal()] = biPredicate;
        Wrapper.PREDICATES[SpatialOperatorName.OVERLAPS.ordinal()] = biPredicate;
        Wrapper.PREDICATES[SpatialOperatorName.CONTAINS.ordinal()] = Wrapper::contain;
        Wrapper.PREDICATES[SpatialOperatorName.WITHIN.ordinal()] = Wrapper::within;
        Wrapper.PREDICATES[SpatialOperatorName.BBOX.ordinal()] = Wrapper::bbox;
        Wrapper.PREDICATES[SpatialOperatorName.EQUALS.ordinal()] = Wrapper::equal;
        Wrapper.PREDICATES[SpatialOperatorName.DISJOINT.ordinal()] = (w, o) -> !w.intersect(o);
    }
}

