/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.awt.Shape;
import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class RegionOfInterest
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -8408578541189424074L;
    private final Shape geometry;
    private final CoordinateReferenceSystem crs;

    public RegionOfInterest(Shape geometry, CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureNonNull((String)"geometry", (Object)geometry);
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)crs);
        this.geometry = geometry;
        this.crs = crs;
    }

    public Shape toShape2D(GridGeometry target) throws TransformException {
        MathTransform2D crsToGrid;
        try {
            MathTransform tr = target.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
            if (this.crs != null && target.isDefined(1)) {
                CoordinateOperation op = CRS.findOperation((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)target.getCoordinateReferenceSystem(), (GeographicBoundingBox)target.getGeographicExtent().orElse(null));
                tr = MathTransforms.concatenate((MathTransform)op.getMathTransform(), (MathTransform)tr);
            }
            crsToGrid = MathTransforms.bidimensional((MathTransform)tr);
        }
        catch (IllegalArgumentException | FactoryException e) {
            throw new TransformException(null, e);
        }
        return crsToGrid.createTransformedShape(this.geometry);
    }

    public final boolean equals(Object other) {
        return this.equals(other, ComparisonMode.STRICT);
    }

    public boolean equals(Object other, ComparisonMode mode) {
        if (other instanceof RegionOfInterest) {
            RegionOfInterest that = (RegionOfInterest)other;
            if (mode != ComparisonMode.STRICT || other.getClass() == this.getClass()) {
                return this.geometry.equals(that.geometry) && Utilities.deepEquals((Object)this.crs, (Object)that.crs, (ComparisonMode)mode);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.geometry.hashCode() + Objects.hashCode(this.crs);
    }
}

