/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging;

import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.logging.AccessLogComponent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AccessLogger {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogger.class);

    static void write(List<AccessLogComponent> format, RequestLog log) {
        VirtualHost host = ((ServiceRequestContext)log.context()).config().virtualHost();
        Logger logger = host.accessLogger();
        if (!format.isEmpty() && logger.isInfoEnabled()) {
            logger.info(AccessLogger.format(format, log));
        }
    }

    static String format(List<AccessLogComponent> format, RequestLog log) {
        StringBuilder message = new StringBuilder();
        for (AccessLogComponent component : format) {
            boolean addQuote = component.addQuote();
            try {
                Object text = component.getMessage(log);
                if (text != null) {
                    if (addQuote) {
                        AccessLogger.escapeAndQuote(message, text.toString());
                        continue;
                    }
                    message.append(text);
                    continue;
                }
                AccessLogger.appendEmptyField(message, addQuote);
            }
            catch (Throwable e) {
                logger.debug("Caught an exception while formatting an access log:", e);
                AccessLogger.appendEmptyField(message, addQuote);
            }
        }
        return message.toString();
    }

    private static void appendEmptyField(StringBuilder message, boolean addQuote) {
        if (addQuote) {
            message.append("\"-\"");
        } else {
            message.append('-');
        }
    }

    static StringBuilder escapeAndQuote(StringBuilder message, String input) {
        message.append('\"');
        boolean isEscaped = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                isEscaped = true;
            } else {
                if (c == '\"' && !isEscaped) {
                    message.append('\\');
                }
                isEscaped = false;
            }
            message.append(c);
        }
        message.append('\"');
        return message;
    }

    private AccessLogger() {
    }
}

