/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.multipart;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.multipart.BodyPart;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.DefaultStreamMessage;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.EventExecutor;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class MultipartEncoder
implements StreamMessage<HttpData> {
    private static final AtomicReferenceFieldUpdater<MultipartEncoder, CompletableFuture> completionFutureUpdater = AtomicReferenceFieldUpdater.newUpdater(MultipartEncoder.class, CompletableFuture.class, "completionFuture");
    private static final AtomicIntegerFieldUpdater<MultipartEncoder> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(MultipartEncoder.class, "subscribed");
    private static final HttpData CRLF = HttpData.ofUtf8("\r\n");
    private final String boundary;
    private final StreamMessage<BodyPart> publisher;
    private volatile int subscribed;
    @Nullable
    private Throwable closeCause;
    private volatile boolean closed;
    @Nullable
    private volatile CompletableFuture<Void> completionFuture;
    @Nullable
    private volatile StreamWriter<StreamMessage<HttpData>> emitter;

    MultipartEncoder(StreamMessage<BodyPart> publisher, String boundary) {
        Objects.requireNonNull(boundary, "boundary");
        Objects.requireNonNull(publisher, "publisher");
        this.boundary = boundary;
        this.publisher = publisher;
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        StreamWriter<StreamMessage<HttpData>> emitter = this.emitter;
        if (emitter != null) {
            return emitter.whenComplete();
        }
        CompletableFuture<Void> completionFuture = new CompletableFuture<Void>();
        if (completionFutureUpdater.compareAndSet(this, null, completionFuture)) {
            return completionFuture;
        }
        CompletableFuture<Void> oldFuture = this.completionFuture;
        assert (oldFuture != null);
        return oldFuture;
    }

    @Override
    public void subscribe(Subscriber<? super HttpData> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (!subscribedUpdater.compareAndSet(this, 0, 1)) {
            subscriber.onSubscribe((Subscription)NoopSubscription.get());
            subscriber.onError((Throwable)new IllegalStateException("Only one Subscriber allowed"));
            return;
        }
        this.publisher.subscribe((Subscriber<BodyPart>)new BodyPartSubscriber(subscriber, executor, options), executor, options);
    }

    @Override
    public void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public void abort(Throwable cause) {
        if (this.closed) {
            return;
        }
        this.closeCause = cause;
        this.closed = true;
        StreamWriter<StreamMessage<HttpData>> emitter = this.emitter;
        if (emitter != null) {
            emitter.abort(cause);
        }
    }

    @Override
    public boolean isOpen() {
        StreamWriter<StreamMessage<HttpData>> emitter = this.emitter;
        return emitter == null || emitter.isOpen();
    }

    @Override
    public boolean isEmpty() {
        StreamWriter<StreamMessage<HttpData>> emitter = this.emitter;
        return emitter == null || emitter.isEmpty();
    }

    @Override
    public long demand() {
        StreamWriter<StreamMessage<HttpData>> emitter = this.emitter;
        if (emitter == null) {
            return 0L;
        }
        return emitter.demand();
    }

    private static StreamWriter<StreamMessage<HttpData>> newEmitter(final Subscription upstream) {
        DefaultStreamMessage<StreamMessage<HttpData>> emitter = new DefaultStreamMessage<StreamMessage<HttpData>>(){

            @Override
            protected void onRequest(long n) {
                upstream.request(n);
            }
        };
        emitter.whenComplete().handle((unused, cause) -> {
            if (cause instanceof CancelledSubscriptionException) {
                upstream.cancel();
            }
            return null;
        });
        return emitter;
    }

    private StreamMessage<HttpData> createBodyPartPublisher(BodyPart bodyPart) {
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder sb = tempThreadLocals.stringBuilder();
            sb.append("--").append(this.boundary).append("\r\n");
            for (Map.Entry<AsciiString, String> header : bodyPart.headers()) {
                AsciiString headerName = header.getKey();
                String headerValue = header.getValue();
                sb.append((CharSequence)headerName).append(':').append(headerValue).append("\r\n");
            }
            sb.append("\r\n");
            StreamMessage streamMessage = StreamMessage.concat(StreamMessage.of(HttpData.ofUtf8(sb.toString())), bodyPart.content(), StreamMessage.of(CRLF));
            return streamMessage;
        }
    }

    private final class BodyPartSubscriber
    implements Subscriber<BodyPart> {
        @Nullable
        private Subscriber<? super HttpData> downstream;
        private final EventExecutor executor;
        private final SubscriptionOption[] options;
        private boolean subscribed;

        private BodyPartSubscriber(Subscriber<? super HttpData> downstream, EventExecutor executor, SubscriptionOption[] options) {
            this.downstream = downstream;
            this.executor = executor;
            this.options = options;
        }

        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            if (this.subscribed) {
                subscription.cancel();
                return;
            }
            assert (this.downstream != null);
            this.subscribed = true;
            StreamWriter newEmitter = MultipartEncoder.newEmitter(subscription);
            MultipartEncoder.this.emitter = newEmitter;
            if (MultipartEncoder.this.closed) {
                this.downstream.onError(MultipartEncoder.this.closeCause);
                newEmitter.abort(CancelledSubscriptionException.get());
                return;
            }
            CompletableFuture completionFuture = MultipartEncoder.this.completionFuture;
            if (completionFuture != null) {
                this.completeAsync(newEmitter.whenComplete(), completionFuture);
            } else if (!completionFutureUpdater.compareAndSet(MultipartEncoder.this, null, newEmitter.whenComplete())) {
                CompletableFuture oldFuture = MultipartEncoder.this.completionFuture;
                assert (oldFuture != null);
                this.completeAsync(newEmitter.whenComplete(), oldFuture);
            }
            StreamMessage.concat(StreamMessage.concat(newEmitter), StreamMessage.of(HttpData.ofUtf8("--" + MultipartEncoder.this.boundary + "--"))).subscribe(this.downstream, this.executor, this.options);
            this.downstream = null;
        }

        private void completeAsync(CompletableFuture<Void> first, CompletableFuture<Void> second) {
            first.handle((unused, cause) -> {
                if (cause != null) {
                    second.completeExceptionally((Throwable)cause);
                } else {
                    second.complete(null);
                }
                return null;
            });
        }

        public void onNext(BodyPart bodyPart) {
            Objects.requireNonNull(bodyPart, "bodyPart");
            StreamWriter emitter = MultipartEncoder.this.emitter;
            assert (emitter != null);
            emitter.write(MultipartEncoder.this.createBodyPartPublisher(bodyPart));
        }

        public void onError(Throwable cause) {
            Objects.requireNonNull(cause, "cause");
            if (MultipartEncoder.this.closed) {
                return;
            }
            MultipartEncoder.this.closed = true;
            StreamWriter emitter = MultipartEncoder.this.emitter;
            assert (emitter != null);
            emitter.abort(cause);
        }

        public void onComplete() {
            if (MultipartEncoder.this.closed) {
                return;
            }
            MultipartEncoder.this.closed = true;
            StreamWriter emitter = MultipartEncoder.this.emitter;
            assert (emitter != null);
            emitter.close();
        }
    }
}

