/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.AbstractEndpointSelector;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.client.endpoint.EndpointWeightTransition;
import com.linecorp.armeria.client.endpoint.WeightRampingUpStrategyBuilder;
import com.linecorp.armeria.client.endpoint.WeightedRandomDistributionEndpointSelector;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.ListenableAsyncCloseable;
import com.linecorp.armeria.common.util.Ticker;
import com.linecorp.armeria.internal.client.endpoint.EndpointAttributeKeys;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2LongOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.math.IntMath;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

final class WeightRampingUpStrategy
implements EndpointSelectionStrategy {
    private static final Ticker defaultTicker = Ticker.systemTicker();
    private static final WeightedRandomDistributionEndpointSelector EMPTY_SELECTOR = new WeightedRandomDistributionEndpointSelector((List<Endpoint>)ImmutableList.of());
    static final WeightRampingUpStrategy INSTANCE = new WeightRampingUpStrategy(WeightRampingUpStrategyBuilder.defaultTransition, () -> CommonPools.workerGroup().next(), 2000L, 10, 500L, defaultTicker);
    private final EndpointWeightTransition weightTransition;
    private final Supplier<EventExecutor> executorSupplier;
    private final long rampingUpIntervalNanos;
    private final int totalSteps;
    private final long rampingUpTaskWindowNanos;
    private final Ticker ticker;

    WeightRampingUpStrategy(EndpointWeightTransition weightTransition, Supplier<EventExecutor> executorSupplier, long rampingUpIntervalMillis, int totalSteps, long rampingUpTaskWindowMillis) {
        this(weightTransition, executorSupplier, rampingUpIntervalMillis, totalSteps, rampingUpTaskWindowMillis, defaultTicker);
    }

    WeightRampingUpStrategy(EndpointWeightTransition weightTransition, Supplier<EventExecutor> executorSupplier, long rampingUpIntervalMillis, int totalSteps, long rampingUpTaskWindowMillis, Ticker ticker) {
        this.weightTransition = Objects.requireNonNull(weightTransition, "weightTransition");
        this.executorSupplier = Objects.requireNonNull(executorSupplier, "executorSupplier");
        Preconditions.checkArgument(rampingUpIntervalMillis > 0L, "rampingUpIntervalMillis: %s (expected: > 0)", rampingUpIntervalMillis);
        this.rampingUpIntervalNanos = TimeUnit.MILLISECONDS.toNanos(rampingUpIntervalMillis);
        Preconditions.checkArgument(totalSteps > 0, "totalSteps: %s (expected: > 0)", totalSteps);
        this.totalSteps = totalSteps;
        Preconditions.checkArgument(rampingUpTaskWindowMillis >= 0L, "rampingUpTaskWindowMillis: %s (expected: > 0)", rampingUpTaskWindowMillis);
        this.rampingUpTaskWindowNanos = TimeUnit.MILLISECONDS.toNanos(rampingUpTaskWindowMillis);
        this.ticker = Objects.requireNonNull(ticker, "ticker");
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new RampingUpEndpointWeightSelector(endpointGroup, this.executorSupplier.get());
    }

    private static int numStep(long rampingUpIntervalNanos, Ticker ticker, long createTimestamp) {
        long timePassed = ticker.read() - createTimestamp;
        int step = Ints.saturatedCast(timePassed / rampingUpIntervalNanos);
        return IntMath.saturatedAdd(step, 1);
    }

    final class RampingUpEndpointWeightSelector
    extends AbstractEndpointSelector {
        private final EventExecutor executor;
        private volatile WeightedRandomDistributionEndpointSelector endpointSelector;
        private final List<Endpoint> endpointsFinishedRampingUp;
        final Deque<EndpointsRampingUpEntry> endpointsRampingUp;
        final Map<Long, EndpointsRampingUpEntry> rampingUpWindowsMap;
        private Object2LongOpenHashMap<Endpoint> endpointCreatedTimestamps;
        private final ReentrantShortLock lock;

        RampingUpEndpointWeightSelector(EndpointGroup endpointGroup, EventExecutor executor) {
            super(endpointGroup);
            this.endpointSelector = EMPTY_SELECTOR;
            this.endpointsFinishedRampingUp = new ArrayList<Endpoint>();
            this.endpointsRampingUp = new ArrayDeque<EndpointsRampingUpEntry>();
            this.rampingUpWindowsMap = new HashMap<Long, EndpointsRampingUpEntry>();
            this.endpointCreatedTimestamps = new Object2LongOpenHashMap();
            this.lock = new ReentrantShortLock(true);
            this.executor = executor;
            if (endpointGroup instanceof ListenableAsyncCloseable) {
                ((ListenableAsyncCloseable)((Object)endpointGroup)).whenClosed().thenRunAsync(this::close, (Executor)executor);
            }
            this.initialize();
        }

        @Override
        protected void updateNewEndpoints(List<Endpoint> endpoints) {
            this.lock.lock();
            try {
                this.updateEndpoints(endpoints);
            }
            finally {
                this.lock.unlock();
            }
        }

        private long computeCreateTimestamp(Endpoint endpoint) {
            if (EndpointAttributeKeys.hasCreatedAtNanos(endpoint)) {
                return EndpointAttributeKeys.createdAtNanos(endpoint);
            }
            if (this.endpointCreatedTimestamps.containsKey(endpoint)) {
                return this.endpointCreatedTimestamps.getLong(endpoint);
            }
            return WeightRampingUpStrategy.this.ticker.read();
        }

        @Override
        @Nullable
        public Endpoint selectNow(ClientRequestContext ctx) {
            return this.endpointSelector.selectEndpoint();
        }

        WeightedRandomDistributionEndpointSelector endpointSelector() {
            return this.endpointSelector;
        }

        private void updateEndpoints(List<Endpoint> newEndpoints) {
            for (EndpointsRampingUpEntry entry : this.rampingUpWindowsMap.values()) {
                entry.endpointAndSteps().clear();
            }
            this.endpointsFinishedRampingUp.clear();
            Object2LongOpenHashMap<Endpoint> newCreatedTimestamps = new Object2LongOpenHashMap<Endpoint>();
            for (Endpoint endpoint : newEndpoints) {
                long createTimestamp = this.computeCreateTimestamp(endpoint);
                newCreatedTimestamps.put(endpoint, createTimestamp);
                int step = WeightRampingUpStrategy.numStep(WeightRampingUpStrategy.this.rampingUpIntervalNanos, WeightRampingUpStrategy.this.ticker, createTimestamp);
                if (step >= WeightRampingUpStrategy.this.totalSteps) {
                    this.endpointsFinishedRampingUp.add(endpoint);
                    continue;
                }
                long window = this.windowIndex(createTimestamp);
                if (!this.rampingUpWindowsMap.containsKey(window)) {
                    long initialDelayNanos = this.initialDelayNanos(window);
                    io.netty.util.concurrent.ScheduledFuture scheduledFuture = this.executor.scheduleAtFixedRate(() -> this.updateWeightAndStep(window), initialDelayNanos, WeightRampingUpStrategy.this.rampingUpIntervalNanos, TimeUnit.NANOSECONDS);
                    EndpointsRampingUpEntry entry = new EndpointsRampingUpEntry((Set<EndpointsRampingUpEntry.EndpointAndStep>)new HashSet<EndpointsRampingUpEntry.EndpointAndStep>(), (ScheduledFuture<?>)scheduledFuture, WeightRampingUpStrategy.this.ticker, WeightRampingUpStrategy.this.rampingUpIntervalNanos);
                    this.rampingUpWindowsMap.put(window, entry);
                }
                EndpointsRampingUpEntry rampingUpEntry = this.rampingUpWindowsMap.get(window);
                EndpointsRampingUpEntry.EndpointAndStep endpointAndStep = new EndpointsRampingUpEntry.EndpointAndStep(endpoint, WeightRampingUpStrategy.this.weightTransition, step, WeightRampingUpStrategy.this.totalSteps);
                rampingUpEntry.addEndpoint(endpointAndStep);
            }
            this.endpointCreatedTimestamps = newCreatedTimestamps;
            this.buildEndpointSelector();
        }

        private void buildEndpointSelector() {
            ImmutableList.Builder targetEndpointsBuilder = ImmutableList.builder();
            targetEndpointsBuilder.addAll(this.endpointsFinishedRampingUp);
            for (EndpointsRampingUpEntry entry : this.rampingUpWindowsMap.values()) {
                for (EndpointsRampingUpEntry.EndpointAndStep endpointAndStep : entry.endpointAndSteps()) {
                    targetEndpointsBuilder.add(endpointAndStep.endpoint().withWeight(endpointAndStep.currentWeight()));
                }
            }
            this.endpointSelector = new WeightedRandomDistributionEndpointSelector((List<Endpoint>)((Object)targetEndpointsBuilder.build()));
        }

        long windowIndex(long timestamp) {
            long window = timestamp % WeightRampingUpStrategy.this.rampingUpIntervalNanos;
            if (WeightRampingUpStrategy.this.rampingUpTaskWindowNanos > 0L) {
                window /= WeightRampingUpStrategy.this.rampingUpTaskWindowNanos;
            }
            return window;
        }

        private long initialDelayNanos(long windowIndex) {
            long timestamp = WeightRampingUpStrategy.this.ticker.read();
            long base = (timestamp / WeightRampingUpStrategy.this.rampingUpIntervalNanos + 1L) * WeightRampingUpStrategy.this.rampingUpIntervalNanos;
            long nextTimestamp = base + windowIndex * WeightRampingUpStrategy.this.rampingUpTaskWindowNanos;
            return nextTimestamp - timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateWeightAndStep(long window) {
            this.lock.lock();
            try {
                EndpointsRampingUpEntry entry = this.rampingUpWindowsMap.get(window);
                assert (entry != null);
                Set<EndpointsRampingUpEntry.EndpointAndStep> endpointAndSteps = entry.endpointAndSteps();
                this.updateWeightAndStep(endpointAndSteps);
                if (endpointAndSteps.isEmpty()) {
                    this.rampingUpWindowsMap.remove((Object)Long.valueOf((long)window)).scheduledFuture.cancel(true);
                }
                this.buildEndpointSelector();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void updateWeightAndStep(Set<EndpointsRampingUpEntry.EndpointAndStep> endpointAndSteps) {
            Iterator<EndpointsRampingUpEntry.EndpointAndStep> i = endpointAndSteps.iterator();
            while (i.hasNext()) {
                EndpointsRampingUpEntry.EndpointAndStep endpointAndStep = i.next();
                int step = endpointAndStep.incrementAndGetStep();
                Endpoint endpoint = endpointAndStep.endpoint();
                if (step < WeightRampingUpStrategy.this.totalSteps) continue;
                this.endpointsFinishedRampingUp.add(endpoint);
                i.remove();
            }
        }

        private void close() {
            this.lock.lock();
            try {
                this.rampingUpWindowsMap.values().forEach(e -> e.scheduledFuture.cancel(true));
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    static final class EndpointsRampingUpEntry {
        private final Set<EndpointAndStep> endpointAndSteps;
        private final Ticker ticker;
        private final long rampingUpIntervalNanos;
        final ScheduledFuture<?> scheduledFuture;

        EndpointsRampingUpEntry(Set<EndpointAndStep> endpointAndSteps, ScheduledFuture<?> scheduledFuture, Ticker ticker, long rampingUpIntervalMillis) {
            this.endpointAndSteps = endpointAndSteps;
            this.scheduledFuture = scheduledFuture;
            this.ticker = ticker;
            this.rampingUpIntervalNanos = TimeUnit.MILLISECONDS.toNanos(rampingUpIntervalMillis);
        }

        Set<EndpointAndStep> endpointAndSteps() {
            return this.endpointAndSteps;
        }

        void addEndpoint(EndpointAndStep endpoint) {
            this.endpointAndSteps.add(endpoint);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("endpointAndSteps", this.endpointAndSteps).add("ticker", this.ticker).add("rampingUpIntervalNanos", this.rampingUpIntervalNanos).add("scheduledFuture", this.scheduledFuture).toString();
        }

        static final class EndpointAndStep {
            private final Endpoint endpoint;
            private final EndpointWeightTransition weightTransition;
            private int step;
            private final int totalSteps;
            private int currentWeight;

            EndpointAndStep(Endpoint endpoint, EndpointWeightTransition weightTransition, int step, int totalSteps) {
                this.endpoint = endpoint;
                this.weightTransition = weightTransition;
                this.step = step;
                this.totalSteps = totalSteps;
            }

            int incrementAndGetStep() {
                return ++this.step;
            }

            int currentWeight() {
                this.currentWeight = this.computeWeight(this.endpoint, this.step);
                return this.currentWeight;
            }

            private int computeWeight(Endpoint endpoint, int step) {
                int calculated = this.weightTransition.compute(endpoint, step, this.totalSteps);
                return Ints.constrainToRange(calculated, 0, endpoint.weight());
            }

            int step() {
                return this.step;
            }

            Endpoint endpoint() {
                return this.endpoint;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("endpoint", this.endpoint).add("currentWeight", this.currentWeight).add("weightTransition", this.weightTransition).add("step", this.step).add("totalSteps", this.totalSteps).toString();
            }
        }
    }
}

