/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.FileResource;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.net.PercentCodec;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.STATELESS)
public class FileResourceFactory
implements ResourceFactory {
    private final File cacheDir;

    public FileResourceFactory(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    static String generateUniqueCacheFileName(String requestId, String eTag, byte[] content, int off, int len) {
        StringBuilder buf = new StringBuilder();
        if (eTag != null) {
            PercentCodec.RFC3986.encode(buf, (CharSequence)eTag);
            buf.append('@');
        } else if (content != null) {
            MessageDigest sha256;
            try {
                sha256 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex);
            }
            sha256.update(content, off, len);
            buf.append(TextUtils.toHexString((byte[])sha256.digest()));
            buf.append('@');
        }
        PercentCodec.RFC3986.encode(buf, (CharSequence)requestId);
        return buf.toString();
    }

    @Override
    public Resource generate(String requestId, String eTag, byte[] content, int off, int len) throws ResourceIOException {
        Args.notNull((Object)requestId, (String)"Request id");
        String filename = FileResourceFactory.generateUniqueCacheFileName(requestId, eTag, content, off, len);
        File file = new File(this.cacheDir, filename);
        try (FileOutputStream outStream = new FileOutputStream(file, false);){
            if (content != null) {
                outStream.write(content, off, len);
            }
        }
        catch (IOException ex) {
            throw new ResourceIOException(ex.getMessage(), ex);
        }
        return new FileResource(file);
    }

    @Override
    public Resource generate(String requestId, byte[] content, int off, int len) throws ResourceIOException {
        if (content != null) {
            return this.generate(requestId, null, content, off, len);
        }
        return this.generate(requestId, null, null, 0, 0);
    }

    @Override
    public Resource generate(String requestId, byte[] content) throws ResourceIOException {
        if (content != null) {
            return this.generate(requestId, null, content, 0, content.length);
        }
        return this.generate(requestId, null, null, 0, 0);
    }

    @Override
    @Deprecated
    public Resource copy(String requestId, Resource resource) throws ResourceIOException {
        return resource;
    }
}

