/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.pipeline;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.apache.hop.ui.workflow.actions.ActionBaseDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.pipeline.ActionPipeline;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ActionPipelineDialog
extends ActionBaseDialog {
    private static final Class<?> PKG = ActionPipeline.class;
    private ActionPipeline action;
    private MetaSelectionLine<PipelineRunConfiguration> wRunConfiguration;
    private static final String[] FILE_FILTERLOGNAMES = new String[]{BaseMessages.getString(PKG, (String)"ActionPipeline.Fileformat.TXT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionPipeline.Fileformat.LOG", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionPipeline.Fileformat.All", (String[])new String[0])};

    public ActionPipelineDialog(Shell parent, ActionPipeline action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, (IAction)action, workflowMeta, variables);
        this.action = action;
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        this.backupChanged = this.action.hasChanged();
        this.createElements();
        this.getData();
        this.setActive();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    protected void createElements() {
        super.createElements();
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Header", (String[])new String[0]));
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.PipelineFile.Label", (String[])new String[0]));
        this.wPassParams.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.PassAllParameters.Label", (String[])new String[0]));
        this.wClearRows = new Button((Composite)this.gExecution, 32);
        PropsUi.setLook((Widget)this.wClearRows);
        this.wClearRows.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.ClearResultList.Label", (String[])new String[0]));
        FormData fdbClearRows = new FormData();
        fdbClearRows.left = new FormAttachment(0, 0);
        fdbClearRows.top = new FormAttachment((Control)this.wEveryRow, 10);
        this.wClearRows.setLayoutData((Object)fdbClearRows);
        this.wClearFiles = new Button((Composite)this.gExecution, 32);
        PropsUi.setLook((Widget)this.wClearFiles);
        this.wClearFiles.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.ClearResultFiles.Label", (String[])new String[0]));
        FormData fdbClearFiles = new FormData();
        fdbClearFiles.left = new FormAttachment(0, 0);
        fdbClearFiles.top = new FormAttachment((Control)this.wClearRows, 10);
        this.wClearFiles.setLayoutData((Object)fdbClearFiles);
        this.wWaitingToFinish = new Button((Composite)this.gExecution, 32);
        PropsUi.setLook((Widget)this.wWaitingToFinish);
        this.wWaitingToFinish.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.WaitToFinish.Label", (String[])new String[0]));
        FormData fdWait = new FormData();
        fdWait.top = new FormAttachment((Control)this.wClearFiles, 10);
        fdWait.left = new FormAttachment(0, 0);
        this.wWaitingToFinish.setLayoutData((Object)fdWait);
        this.wbGetParams.addListener(13, e -> this.getParameters(null));
        this.wbBrowse.addListener(13, e -> this.pickFileVFS());
        this.wbLogFilename.addListener(13, e -> this.selectLogFile(FILE_FILTERLOGNAMES));
    }

    protected ActionBase getAction() {
        return this.action;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ui/images/pipeline.svg", (int)48, (int)48);
    }

    protected int getParameterCount() {
        return this.action.getParameterDefinition().getParameters().size();
    }

    private void getParameters(PipelineMeta inputPipelineMeta) {
        try {
            if (inputPipelineMeta == null) {
                ActionPipeline jet = new ActionPipeline();
                this.getInfo(jet);
                inputPipelineMeta = jet.getPipelineMeta(this.getMetadataProvider(), this.variables);
            }
            String[] parameters = inputPipelineMeta.listParameters();
            String[] existing = this.wParameters.getItems(1);
            for (String parameter : parameters) {
                if (Const.indexOfString((String)parameter, (String[])existing) >= 0) continue;
                TableItem item = new TableItem(this.wParameters.table, 0);
                item.setText(1, parameter);
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ActionPipelineDialog.Exception.UnableToLoadPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionPipelineDialog.Exception.UnableToLoadPipeline.Message", (String[])new String[0]), e);
        }
    }

    protected Control createRunConfigurationControl() {
        this.wRunConfiguration = new MetaSelectionLine(this.variables, this.metadataProvider, PipelineRunConfiguration.class, (Composite)this.shell, 2048, null, null, true);
        return this.wRunConfiguration;
    }

    protected void pickFileVFS() {
        HopPipelineFileType pipelineFileType = new HopPipelineFileType();
        String filename = BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPath, (IVariables)this.variables, (String[])pipelineFileType.getFilterExtensions(), (String[])pipelineFileType.getFilterNames(), (boolean)false);
        if (filename != null) {
            this.replaceNameWithBaseFilename(filename);
        }
    }

    public String getEntryName(String name) {
        return "${Internal.Entry.Current.Folder}/" + name;
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        this.wPath.setText(Const.NVL((String)this.action.getFilename(), (String)""));
        ActionPipeline.ParameterDefinition parameterDefinition = this.action.getParameterDefinition();
        if (this.action.getParameterDefinition() != null) {
            for (int i = 0; i < parameterDefinition.getParameters().size(); ++i) {
                ActionPipeline.Parameter parameter = parameterDefinition.getParameters().get(i);
                TableItem item = this.wParameters.getTable().getItem(i);
                if (Utils.isEmpty((CharSequence)parameter.getName())) continue;
                item.setText(1, Const.NVL((String)parameter.getName(), (String)""));
                item.setText(2, Const.NVL((String)parameter.getField(), (String)""));
                item.setText(3, Const.NVL((String)parameter.getValue(), (String)""));
            }
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        this.wPassParams.setSelection(parameterDefinition.isPassingAllParameters());
        if (this.action.getLogfile() != null) {
            this.wLogfile.setText(this.action.getLogfile());
        }
        if (this.action.getLogext() != null) {
            this.wLogext.setText(this.action.getLogext());
        }
        this.wPrevToParams.setSelection(this.action.isParamsFromPrevious());
        this.wEveryRow.setSelection(this.action.isExecPerRow());
        this.wSetLogfile.setSelection(this.action.isSetLogfile());
        this.wAddDate.setSelection(this.action.isAddDate());
        this.wAddTime.setSelection(this.action.isAddTime());
        this.wClearRows.setSelection(this.action.isClearResultRows());
        this.wClearFiles.setSelection(this.action.isClearResultFiles());
        this.wWaitingToFinish.setSelection(this.action.isWaitingToFinish());
        this.wAppendLogfile.setSelection(this.action.isSetAppendLogfile());
        this.wCreateParentFolder.setSelection(this.action.isCreateParentFolder());
        if (this.action.getLogFileLevel() != null) {
            this.wLoglevel.select(this.action.getLogFileLevel().getLevel());
        }
        try {
            List runConfigurations = this.getMetadataProvider().getSerializer(PipelineRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "pipeline"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
            this.wRunConfiguration.setText(Const.NVL((String)this.action.getRunConfiguration(), (String)""));
            if (Utils.isEmpty((CharSequence)this.action.getRunConfiguration())) {
                this.wRunConfiguration.select(0);
            } else {
                this.wRunConfiguration.setText(this.action.getRunConfiguration());
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting pipeline run configurations", (Throwable)e);
        }
        this.setLogFileEnabled();
        this.wName.selectAll();
        this.wName.setFocus();
    }

    protected void cancel() {
        this.action.setChanged(this.backupChanged);
        this.action = null;
        this.dispose();
    }

    private void getInfo(ActionPipeline actionPipeline) throws HopException {
        actionPipeline.setName(this.wName.getText());
        actionPipeline.setRunConfiguration(this.wRunConfiguration.getText());
        actionPipeline.setFileName(this.wPath.getText());
        ActionPipeline.ParameterDefinition parameterDefinition = this.action.getParameterDefinition();
        parameterDefinition.getParameters().clear();
        int nrItems = this.wParameters.nrNonEmpty();
        for (int i = 0; i < nrItems; ++i) {
            TableItem item = this.wParameters.getNonEmpty(i);
            ActionPipeline.Parameter parameter = new ActionPipeline.Parameter();
            parameter.setName(item.getText(1));
            String fieldName = Const.trim((String)item.getText(2));
            if (!Utils.isEmpty((CharSequence)fieldName)) {
                parameter.setField(fieldName);
            } else {
                parameter.setField("");
            }
            String value = Const.trim((String)item.getText(3));
            if (!Utils.isEmpty((CharSequence)value)) {
                parameter.setValue(value);
            } else {
                parameter.setValue("");
            }
            parameterDefinition.getParameters().add(parameter);
        }
        parameterDefinition.setPassingAllParameters(this.wPassParams.getSelection());
        actionPipeline.setLogfile(this.wLogfile.getText());
        actionPipeline.setLogext(this.wLogext.getText());
        actionPipeline.setLogFileLevel(LogLevel.lookupDescription((String)this.wLoglevel.getText()));
        actionPipeline.setParamsFromPrevious(this.wPrevToParams.getSelection());
        actionPipeline.setExecPerRow(this.wEveryRow.getSelection());
        actionPipeline.setSetLogfile(this.wSetLogfile.getSelection());
        actionPipeline.setAddDate(this.wAddDate.getSelection());
        actionPipeline.setAddTime(this.wAddTime.getSelection());
        actionPipeline.setClearResultRows(this.wClearRows.getSelection());
        actionPipeline.setClearResultFiles(this.wClearFiles.getSelection());
        actionPipeline.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        actionPipeline.setRunConfiguration(this.wRunConfiguration.getText());
        actionPipeline.setSetAppendLogfile(this.wAppendLogfile.getSelection());
        actionPipeline.setWaitingToFinish(this.wWaitingToFinish.getSelection());
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox box = new MessageBox(this.shell, 33);
            box.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            box.open();
            return;
        }
        this.action.setName(this.wName.getText());
        try {
            this.getInfo(this.action);
        }
        catch (HopException hopException) {
            // empty catch block
        }
        this.action.setChanged();
        this.dispose();
    }
}

