/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.gaxx.grpc;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.gaxx.grpc.AutoValue_BigtableChannelPoolSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.Duration;
import java.util.logging.Logger;

@BetaApi(value="surface for channel pool sizing is not yet stable")
@AutoValue
public abstract class BigtableChannelPoolSettings {
    @VisibleForTesting
    static final Logger LOG = Logger.getLogger(BigtableChannelPoolSettings.class.getName());
    static final Duration RESIZE_INTERVAL = Duration.ofMinutes(1L);
    static final int MAX_RESIZE_DELTA = 2;
    private static final String CBT_LOAD_BALANCING_STRATEGY_ENV_VAR = "CBT_LOAD_BALANCING_STRATEGY";
    private static final LoadBalancingStrategy DEFAULT_LOAD_BALANCING_STRATEGY = LoadBalancingStrategy.ROUND_ROBIN;

    public abstract int getMinRpcsPerChannel();

    public abstract int getMaxRpcsPerChannel();

    public abstract int getMinChannelCount();

    public abstract int getMaxChannelCount();

    public abstract int getInitialChannelCount();

    public abstract boolean isPreemptiveRefreshEnabled();

    @InternalApi(value="Use CBT_LOAD_BALANCING_STRATEGY environment variable")
    public abstract LoadBalancingStrategy getLoadBalancingStrategy();

    boolean isStaticSize() {
        if (this.getMinChannelCount() == this.getMaxChannelCount()) {
            return true;
        }
        return this.getMinRpcsPerChannel() == 0 && this.getMaxRpcsPerChannel() == Integer.MAX_VALUE;
    }

    private static LoadBalancingStrategy loadBalancingStrategyFromEnv() {
        String strategyString = System.getenv(CBT_LOAD_BALANCING_STRATEGY_ENV_VAR);
        if (Strings.isNullOrEmpty((String)strategyString)) {
            return DEFAULT_LOAD_BALANCING_STRATEGY;
        }
        try {
            return LoadBalancingStrategy.valueOf(strategyString.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Invalid load-balancing strategy %s", strategyString));
        }
    }

    public abstract Builder toBuilder();

    public static BigtableChannelPoolSettings copyFrom(ChannelPoolSettings externalSettings) {
        return BigtableChannelPoolSettings.builder().setMinRpcsPerChannel(externalSettings.getMinRpcsPerChannel()).setMaxRpcsPerChannel(externalSettings.getMaxRpcsPerChannel()).setMinChannelCount(externalSettings.getMinChannelCount()).setMaxChannelCount(externalSettings.getMaxChannelCount()).setInitialChannelCount(externalSettings.getInitialChannelCount()).setPreemptiveRefreshEnabled(externalSettings.isPreemptiveRefreshEnabled()).setLoadBalancingStrategy(BigtableChannelPoolSettings.loadBalancingStrategyFromEnv()).build();
    }

    public static BigtableChannelPoolSettings staticallySized(int size) {
        return BigtableChannelPoolSettings.builder().setInitialChannelCount(size).setMinRpcsPerChannel(0).setMaxRpcsPerChannel(Integer.MAX_VALUE).setMinChannelCount(size).setMaxChannelCount(size).setLoadBalancingStrategy(BigtableChannelPoolSettings.loadBalancingStrategyFromEnv()).build();
    }

    public static Builder builder() {
        return new AutoValue_BigtableChannelPoolSettings.Builder().setInitialChannelCount(1).setMinChannelCount(1).setMaxChannelCount(200).setMinRpcsPerChannel(0).setMaxRpcsPerChannel(Integer.MAX_VALUE).setPreemptiveRefreshEnabled(false).setLoadBalancingStrategy(BigtableChannelPoolSettings.loadBalancingStrategyFromEnv());
    }

    public static enum LoadBalancingStrategy {
        ROUND_ROBIN,
        LEAST_IN_FLIGHT,
        POWER_OF_TWO_LEAST_IN_FLIGHT;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMinRpcsPerChannel(int var1);

        public abstract Builder setMaxRpcsPerChannel(int var1);

        public abstract Builder setMinChannelCount(int var1);

        public abstract Builder setMaxChannelCount(int var1);

        public abstract Builder setInitialChannelCount(int var1);

        public abstract Builder setPreemptiveRefreshEnabled(boolean var1);

        @InternalApi(value="Use CBT_LOAD_BALANCING_STRATEGY environment variable")
        public abstract Builder setLoadBalancingStrategy(LoadBalancingStrategy var1);

        abstract BigtableChannelPoolSettings autoBuild();

        public BigtableChannelPoolSettings build() {
            BigtableChannelPoolSettings s = this.autoBuild();
            Preconditions.checkState((s.getMinRpcsPerChannel() <= s.getMaxRpcsPerChannel() ? 1 : 0) != 0, (Object)"rpcsPerChannel range is invalid");
            Preconditions.checkState((s.getMinChannelCount() > 0 ? 1 : 0) != 0, (Object)"Minimum channel count must be at least 1");
            Preconditions.checkState((s.getMinChannelCount() <= s.getMaxRpcsPerChannel() ? 1 : 0) != 0, (Object)"absolute channel range is invalid");
            Preconditions.checkState((s.getMinChannelCount() <= s.getInitialChannelCount() ? 1 : 0) != 0, (Object)"initial channel count be at least minChannelCount");
            Preconditions.checkState((s.getInitialChannelCount() <= s.getMaxChannelCount() ? 1 : 0) != 0, (Object)"initial channel count must be less than maxChannelCount");
            Preconditions.checkState((s.getInitialChannelCount() > 0 ? 1 : 0) != 0, (Object)"Initial channel count must be greater than 0");
            return s;
        }
    }
}

