/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.internal.JwtCredentialsWithAudience;
import com.google.cloud.bigtable.data.v2.stub.BigtableChannelPrimer;
import com.google.cloud.bigtable.data.v2.stub.CookiesInterceptor;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.NoOpChannelPrimer;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.CustomOpenTelemetryMetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.DefaultMetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.ErrorCountPerConnectionMetricTracker;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.NoopMetricsProvider;
import com.google.cloud.bigtable.gaxx.grpc.BigtableTransportChannelProvider;
import com.google.cloud.bigtable.gaxx.grpc.ChannelPrimer;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import io.grpc.opentelemetry.GrpcOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@InternalApi
public class BigtableClientContext {
    private static final Logger logger = Logger.getLogger(BigtableClientContext.class.getName());
    @Nullable
    private final OpenTelemetry openTelemetry;
    @Nullable
    private final OpenTelemetrySdk internalOpenTelemetry;
    private final MetricsProvider metricsProvider;
    private final ClientContext clientContext;

    public static BigtableClientContext create(EnhancedBigtableStubSettings settings) throws IOException {
        EnhancedBigtableStubSettings.Builder builder = settings.toBuilder();
        BigtableClientContext.patchCredentials(builder);
        Credentials credentials = null;
        if (builder.getCredentialsProvider() != null) {
            credentials = builder.getCredentialsProvider().getCredentials();
        }
        builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create(credentials));
        String universeDomain = settings.getUniverseDomain();
        OpenTelemetry openTelemetry = null;
        try {
            openTelemetry = BigtableClientContext.getOpenTelemetryFromMetricsProvider(settings.getMetricsProvider(), credentials, settings.getMetricsEndpoint(), universeDomain);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to get OTEL, will skip exporting client side metrics", t);
        }
        InstantiatingGrpcChannelProvider.Builder transportProvider = builder.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider ? ((InstantiatingGrpcChannelProvider)builder.getTransportChannelProvider()).toBuilder() : null;
        OpenTelemetrySdk internalOtel = null;
        ErrorCountPerConnectionMetricTracker errorCountPerConnectionMetricTracker = null;
        if (transportProvider != null && (internalOtel = settings.getInternalMetricsProvider().createOtelProvider(settings, credentials)) != null) {
            errorCountPerConnectionMetricTracker = BigtableClientContext.setupPerConnectionErrorTracer(builder, transportProvider, (OpenTelemetry)internalOtel);
            BigtableClientContext.configureGrpcOtel(transportProvider, internalOtel);
        }
        if (transportProvider != null) {
            if (builder.getEnableRoutingCookie()) {
                BigtableClientContext.setupCookieHolder(transportProvider);
            }
            ChannelPrimer channelPrimer = NoOpChannelPrimer.create();
            if (builder.isRefreshingChannel()) {
                channelPrimer = BigtableChannelPrimer.create(builder.getProjectId(), builder.getInstanceId(), builder.getAppProfileId(), credentials, builder.getHeaderProvider().getHeaders());
            }
            BigtableTransportChannelProvider btTransportProvider = BigtableTransportChannelProvider.create(transportProvider.build(), channelPrimer);
            builder.setTransportChannelProvider(btTransportProvider);
        }
        ClientContext clientContext = ClientContext.create((StubSettings)builder.build());
        if (errorCountPerConnectionMetricTracker != null) {
            errorCountPerConnectionMetricTracker.startConnectionErrorCountTracker(clientContext.getExecutor());
        }
        return new BigtableClientContext(clientContext, openTelemetry, internalOtel, settings.getMetricsProvider());
    }

    private static void configureGrpcOtel(InstantiatingGrpcChannelProvider.Builder transportProvider, OpenTelemetrySdk otel) {
        GrpcOpenTelemetry grpcOtel = GrpcOpenTelemetry.newBuilder().sdk((OpenTelemetry)otel).addOptionalLabel("grpc.lb.locality").disableAllMetrics().enableMetrics(BuiltinMetricsConstants.GRPC_METRICS.keySet()).build();
        ApiFunction oldConfigurator = transportProvider.getChannelConfigurator();
        transportProvider.setChannelConfigurator(b -> {
            if (oldConfigurator != null) {
                b = (ManagedChannelBuilder)oldConfigurator.apply(b);
            }
            grpcOtel.configureChannelBuilder(b);
            return b;
        });
    }

    private BigtableClientContext(ClientContext clientContext, @Nullable OpenTelemetry openTelemetry, @Nullable OpenTelemetrySdk internalOtel, MetricsProvider metricsProvider) {
        this.clientContext = clientContext;
        this.openTelemetry = openTelemetry;
        this.internalOpenTelemetry = internalOtel;
        this.metricsProvider = metricsProvider;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    public void close() throws Exception {
        for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
            resource.close();
        }
        if (this.internalOpenTelemetry != null) {
            this.internalOpenTelemetry.close();
        }
        if (this.metricsProvider instanceof DefaultMetricsProvider && this.openTelemetry != null) {
            ((OpenTelemetrySdk)this.openTelemetry).close();
        }
    }

    private static OpenTelemetry getOpenTelemetryFromMetricsProvider(MetricsProvider metricsProvider, @Nullable Credentials defaultCredentials, @Nullable String metricsEndpoint, String universeDomain) throws IOException {
        if (metricsProvider instanceof CustomOpenTelemetryMetricsProvider) {
            CustomOpenTelemetryMetricsProvider customMetricsProvider = (CustomOpenTelemetryMetricsProvider)metricsProvider;
            return customMetricsProvider.getOpenTelemetry();
        }
        if (metricsProvider instanceof DefaultMetricsProvider) {
            Credentials credentials = BigtableDataSettings.getMetricsCredentials() != null ? BigtableDataSettings.getMetricsCredentials() : defaultCredentials;
            DefaultMetricsProvider defaultMetricsProvider = (DefaultMetricsProvider)metricsProvider;
            return defaultMetricsProvider.getOpenTelemetry(metricsEndpoint, universeDomain, credentials);
        }
        if (metricsProvider instanceof NoopMetricsProvider) {
            return null;
        }
        throw new IOException("Invalid MetricsProvider type " + metricsProvider);
    }

    private static void patchCredentials(EnhancedBigtableStubSettings.Builder settings) throws IOException {
        String audience = settings.getJwtAudience();
        URI audienceUri = null;
        try {
            audienceUri = new URI(audience);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("invalid JWT audience", e);
        }
        CredentialsProvider credentialsProvider = settings.getCredentialsProvider();
        if (credentialsProvider == null) {
            return;
        }
        Credentials credentials = credentialsProvider.getCredentials();
        if (credentials == null) {
            return;
        }
        if (!(credentials instanceof ServiceAccountJwtAccessCredentials)) {
            return;
        }
        ServiceAccountJwtAccessCredentials jwtCreds = (ServiceAccountJwtAccessCredentials)credentials;
        JwtCredentialsWithAudience patchedCreds = new JwtCredentialsWithAudience(jwtCreds, audienceUri);
        settings.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)patchedCreds));
    }

    private static ErrorCountPerConnectionMetricTracker setupPerConnectionErrorTracer(EnhancedBigtableStubSettings.Builder builder, InstantiatingGrpcChannelProvider.Builder transportProvider, OpenTelemetry openTelemetry) {
        ErrorCountPerConnectionMetricTracker errorCountPerConnectionMetricTracker = new ErrorCountPerConnectionMetricTracker(openTelemetry, EnhancedBigtableStub.createBuiltinAttributes(builder.build()));
        ApiFunction oldChannelConfigurator = transportProvider.getChannelConfigurator();
        transportProvider.setChannelConfigurator(managedChannelBuilder -> {
            managedChannelBuilder.intercept(new ClientInterceptor[]{errorCountPerConnectionMetricTracker.getInterceptor()});
            if (oldChannelConfigurator != null) {
                managedChannelBuilder = (ManagedChannelBuilder)oldChannelConfigurator.apply(managedChannelBuilder);
            }
            return managedChannelBuilder;
        });
        return errorCountPerConnectionMetricTracker;
    }

    private static void setupCookieHolder(InstantiatingGrpcChannelProvider.Builder transportProvider) {
        ApiFunction oldChannelConfigurator = transportProvider.getChannelConfigurator();
        transportProvider.setChannelConfigurator(managedChannelBuilder -> {
            managedChannelBuilder.intercept(new ClientInterceptor[]{new CookiesInterceptor()});
            if (oldChannelConfigurator != null) {
                managedChannelBuilder = (ManagedChannelBuilder)oldChannelConfigurator.apply(managedChannelBuilder);
            }
            return managedChannelBuilder;
        });
    }
}

