/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class BulkMutation
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3522061250439399088L;
    private final TargetId targetId;
    private transient MutateRowsRequest.Builder builder;
    private long mutationCountSum = 0L;

    @Deprecated
    public static BulkMutation create(String tableId) {
        return new BulkMutation(TableId.of(tableId));
    }

    public static BulkMutation create(TargetId targetId) {
        return new BulkMutation(targetId);
    }

    private BulkMutation(TargetId targetId) {
        Preconditions.checkNotNull((Object)targetId, (Object)"target id can't be null.");
        this.targetId = targetId;
        this.builder = MutateRowsRequest.newBuilder();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (MutateRowsRequest.Builder)MutateRowsRequest.newBuilder().mergeFrom((InputStream)input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo((OutputStream)output);
    }

    public BulkMutation add(@Nonnull String rowKey, @Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)rowKey);
        Preconditions.checkNotNull((Object)mutation);
        return this.add(ByteString.copyFromUtf8((String)rowKey), mutation);
    }

    public BulkMutation add(@Nonnull ByteString rowKey, @Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)rowKey);
        Preconditions.checkNotNull((Object)mutation);
        long mutationCount = mutation.getMutations().size();
        Preconditions.checkArgument((this.mutationCountSum + mutationCount <= 100000L ? 1 : 0) != 0, (String)"Too many mutations, got %s, limit is %s", (long)(this.mutationCountSum + mutationCount), (int)100000);
        this.mutationCountSum += mutationCount;
        this.builder.addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(rowKey).addAllMutations(mutation.getMutations()).build());
        return this;
    }

    public BulkMutation add(@Nonnull RowMutationEntry entry) {
        Preconditions.checkNotNull((Object)entry, (Object)"Row mutation entry can't be null");
        this.builder.addEntries(entry.toProto());
        return this;
    }

    public int getEntryCount() {
        return this.builder.getEntriesCount();
    }

    @InternalApi
    public MutateRowsRequest toProto(RequestContext requestContext) {
        String resourceName = this.targetId.toResourceName(requestContext.getProjectId(), requestContext.getInstanceId());
        if (this.targetId.scopedForAuthorizedView()) {
            this.builder.setAuthorizedViewName(resourceName);
        } else {
            this.builder.setTableName(resourceName);
        }
        return this.builder.setAppProfileId(requestContext.getAppProfileId()).build();
    }

    @BetaApi
    public static BulkMutation fromProto(@Nonnull MutateRowsRequest request) {
        String tableName = request.getTableName();
        String authorizedViewName = request.getAuthorizedViewName();
        BulkMutation bulkMutation = BulkMutation.create(NameUtil.extractTargetId(tableName, authorizedViewName));
        bulkMutation.builder = request.toBuilder();
        return bulkMutation;
    }

    public BulkMutation clone() {
        BulkMutation bulkMutation = BulkMutation.create(this.targetId);
        bulkMutation.builder = this.builder.clone();
        return bulkMutation;
    }
}

