/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.http;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.HttpProtocol;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.http.ActionHttp;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionHttpDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionHttp.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionHTTP.Filetype.All", (String[])new String[0])};
    private Text wName;
    private Label wlURL;
    private TextVar wURL;
    private Button wIgnoreSsl;
    private Button wRunEveryRow;
    private Label wlFieldURL;
    private TextVar wFieldURL;
    private Label wlFieldUpload;
    private TextVar wFieldUpload;
    private Label wlFieldTarget;
    private TextVar wFieldTarget;
    private Label wlTargetFile;
    private TextVar wTargetFile;
    private Button wbTargetFile;
    private Label wlAppend;
    private Button wAppend;
    private Label wlDateTimeAdded;
    private Button wDateTimeAdded;
    private Label wlTargetExt;
    private TextVar wTargetExt;
    private Label wlUploadFile;
    private TextVar wUploadFile;
    private Button wbUploadFile;
    private TextVar wUserName;
    private TextVar wPassword;
    private TextVar wProxyServer;
    private TextVar wProxyPort;
    private TextVar wNonProxyHosts;
    private TableView wHeaders;
    private Button wAddFilenameToResult;
    private ActionHttp action;
    private boolean changed;

    public ActionHttpDialog(Shell parent, ActionHttp action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionHTTP.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = this.setupButtons(margin);
        this.setupActionName(lsMod, middle, margin);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        this.setupUrlLine(lsMod, middle, margin, wGeneralComp);
        this.setupIgnoreSslLine(middle, margin, wGeneralComp);
        this.setupRunEveryRwoLine(middle, margin, wGeneralComp);
        this.setupUrlFieldLine(lsMod, middle, margin, wGeneralComp);
        this.setupUploadFileLine(lsMod, middle, margin, wGeneralComp);
        this.setupDestFileLine(lsMod, middle, margin, wGeneralComp);
        Group wAuthentication = this.setupAuthGroup(wGeneralComp);
        this.setupUsernameLine(lsMod, middle, margin, wAuthentication);
        this.setupPasswordLine(lsMod, middle, margin, wAuthentication);
        this.setupProxyServerLine(lsMod, middle, margin, wAuthentication);
        this.setupProxyPortLine(lsMod, middle, margin, wAuthentication);
        this.setupIgnoreHostLine(lsMod, middle, margin, wAuthentication);
        FormData fdAuthentication = new FormData();
        fdAuthentication.left = new FormAttachment(0, margin);
        fdAuthentication.top = new FormAttachment((Control)this.wFieldTarget, margin);
        fdAuthentication.right = new FormAttachment(100, -margin);
        wAuthentication.setLayoutData((Object)fdAuthentication);
        Group wUpLoadFile = this.setupUploadFileGroup(wGeneralComp);
        this.setupUploadFileLine(lsMod, middle, margin, wAuthentication, wUpLoadFile);
        FormData fdUpLoadFile = new FormData();
        fdUpLoadFile.left = new FormAttachment(0, margin);
        fdUpLoadFile.top = new FormAttachment((Control)wAuthentication, margin);
        fdUpLoadFile.right = new FormAttachment(100, -margin);
        wUpLoadFile.setLayoutData((Object)fdUpLoadFile);
        Group wTargetFileGroup = this.setupWebServerReplyGroup(wGeneralComp);
        this.setupTargetFileLine(lsMod, middle, margin, wTargetFileGroup);
        this.setupAppendFileLine(middle, margin, wTargetFileGroup);
        this.setupAddDateTimeLine(middle, margin, wTargetFileGroup);
        this.setupTargetExtensionLine(lsMod, middle, margin, wTargetFileGroup);
        this.setupAddFilenameLine(middle, margin, wTargetFileGroup);
        FormData fdTargetFileGroup = new FormData();
        fdTargetFileGroup.left = new FormAttachment(0, margin);
        fdTargetFileGroup.top = new FormAttachment((Control)wUpLoadFile, margin);
        fdTargetFileGroup.right = new FormAttachment(100, -margin);
        wTargetFileGroup.setLayoutData((Object)fdTargetFileGroup);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wName, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wHeadersTab = new CTabItem(wTabFolder, 0);
        wHeadersTab.setFont(GuiResource.getInstance().getFontDefault());
        wHeadersTab.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.Tab.Headers.Label", (String[])new String[0]));
        Composite wHeadersComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wHeadersComp);
        FormLayout headersLayout = new FormLayout();
        headersLayout.marginWidth = 3;
        headersLayout.marginHeight = 3;
        wHeadersComp.setLayout((Layout)headersLayout);
        this.setupHeaderTable(lsMod, margin, wHeadersTab, wHeadersComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void setupHeaderTable(ModifyListener lsMod, int margin, CTabItem wHeadersTab, Composite wHeadersComp) {
        int rows = this.action.getHeaders() == null ? 1 : (this.action.getHeaders().isEmpty() ? 0 : this.action.getHeaders().size());
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionHTTP.ColumnInfo.Name", (String[])new String[0]), 2, HttpProtocol.getRequestHeaders(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionHTTP.ColumnInfo.Value", (String[])new String[0]), 1, false)};
        colinf[0].setUsingVariables(true);
        colinf[1].setUsingVariables(true);
        this.wHeaders = new TableView(this.variables, wHeadersComp, 67586, colinf, rows, lsMod, this.props);
        FormData fdHeaders = new FormData();
        fdHeaders.left = new FormAttachment(0, margin);
        fdHeaders.top = new FormAttachment((Control)this.wName, margin);
        fdHeaders.right = new FormAttachment(100, -margin);
        fdHeaders.bottom = new FormAttachment(100, -margin);
        this.wHeaders.setLayoutData((Object)fdHeaders);
        FormData fdHeadersComp = new FormData();
        fdHeadersComp.left = new FormAttachment(0, 0);
        fdHeadersComp.top = new FormAttachment(0, 0);
        fdHeadersComp.right = new FormAttachment(100, 0);
        fdHeadersComp.bottom = new FormAttachment(100, 0);
        wHeadersComp.setLayoutData((Object)fdHeadersComp);
        wHeadersComp.layout();
        wHeadersTab.setControl((Control)wHeadersComp);
    }

    private void setupAddFilenameLine(int middle, int margin, Group wTargetFileGroup) {
        Label wlAddFilenameToResult = new Label((Composite)wTargetFileGroup, 131072);
        wlAddFilenameToResult.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.AddFilenameToResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddFilenameToResult);
        FormData fdlAddFilenameToResult = new FormData();
        fdlAddFilenameToResult.left = new FormAttachment(0, 0);
        fdlAddFilenameToResult.top = new FormAttachment((Control)this.wTargetExt, margin);
        fdlAddFilenameToResult.right = new FormAttachment(middle, -margin);
        wlAddFilenameToResult.setLayoutData((Object)fdlAddFilenameToResult);
        this.wAddFilenameToResult = new Button((Composite)wTargetFileGroup, 32);
        this.wAddFilenameToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.AddFilenameToResult.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAddFilenameToResult);
        FormData fdAddFilenameToResult = new FormData();
        fdAddFilenameToResult.left = new FormAttachment(middle, 0);
        fdAddFilenameToResult.top = new FormAttachment((Control)wlAddFilenameToResult, 0, 0x1000000);
        fdAddFilenameToResult.right = new FormAttachment(100, 0);
        this.wAddFilenameToResult.setLayoutData((Object)fdAddFilenameToResult);
    }

    private void setupTargetExtensionLine(ModifyListener lsMod, int middle, int margin, Group wTargetFileGroup) {
        this.wlTargetExt = new Label((Composite)wTargetFileGroup, 131072);
        this.wlTargetExt.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFileExt.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTargetExt);
        FormData fdlTargetExt = new FormData();
        fdlTargetExt.left = new FormAttachment(0, 0);
        fdlTargetExt.top = new FormAttachment((Control)this.wlDateTimeAdded, 2 * margin);
        fdlTargetExt.right = new FormAttachment(middle, -margin);
        this.wlTargetExt.setLayoutData((Object)fdlTargetExt);
        this.wTargetExt = new TextVar(this.variables, (Composite)wTargetFileGroup, 18436);
        PropsUi.setLook((Widget)this.wTargetExt);
        this.wTargetExt.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFileExt.Tooltip", (String[])new String[0]));
        this.wTargetExt.addModifyListener(lsMod);
        FormData fdTargetExt = new FormData();
        fdTargetExt.left = new FormAttachment(middle, 0);
        fdTargetExt.top = new FormAttachment((Control)this.wlTargetExt, 0, 0x1000000);
        fdTargetExt.right = new FormAttachment(100, 0);
        this.wTargetExt.setLayoutData((Object)fdTargetExt);
    }

    private void setupAddDateTimeLine(int middle, int margin, Group wTargetFileGroup) {
        this.wlDateTimeAdded = new Label((Composite)wTargetFileGroup, 131072);
        this.wlDateTimeAdded.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFilenameAddDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDateTimeAdded);
        FormData fdlDateTimeAdded = new FormData();
        fdlDateTimeAdded.left = new FormAttachment(0, 0);
        fdlDateTimeAdded.top = new FormAttachment((Control)this.wlAppend, 2 * margin);
        fdlDateTimeAdded.right = new FormAttachment(middle, -margin);
        this.wlDateTimeAdded.setLayoutData((Object)fdlDateTimeAdded);
        this.wDateTimeAdded = new Button((Composite)wTargetFileGroup, 32);
        PropsUi.setLook((Widget)this.wDateTimeAdded);
        this.wDateTimeAdded.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFilenameAddDate.Tooltip", (String[])new String[0]));
        FormData fdDateTimeAdded = new FormData();
        fdDateTimeAdded.left = new FormAttachment(middle, 0);
        fdDateTimeAdded.top = new FormAttachment((Control)this.wlDateTimeAdded, 0, 0x1000000);
        fdDateTimeAdded.right = new FormAttachment(100, 0);
        this.wDateTimeAdded.setLayoutData((Object)fdDateTimeAdded);
        this.wDateTimeAdded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionHttpDialog.this.setFlags();
            }
        });
    }

    private void setupAppendFileLine(int middle, int margin, Group wTargetFileGroup) {
        this.wlAppend = new Label((Composite)wTargetFileGroup, 131072);
        this.wlAppend.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFileAppend.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAppend);
        FormData fdlAppend = new FormData();
        fdlAppend.left = new FormAttachment(0, 0);
        fdlAppend.top = new FormAttachment((Control)this.wTargetFile, margin);
        fdlAppend.right = new FormAttachment(middle, -margin);
        this.wlAppend.setLayoutData((Object)fdlAppend);
        this.wAppend = new Button((Composite)wTargetFileGroup, 32);
        PropsUi.setLook((Widget)this.wAppend);
        this.wAppend.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFileAppend.Tooltip", (String[])new String[0]));
        FormData fdAppend = new FormData();
        fdAppend.left = new FormAttachment(middle, 0);
        fdAppend.top = new FormAttachment((Control)this.wlAppend, 0, 0x1000000);
        fdAppend.right = new FormAttachment(100, 0);
        this.wAppend.setLayoutData((Object)fdAppend);
    }

    private void setupTargetFileLine(ModifyListener lsMod, int middle, int margin, Group wTargetFileGroup) {
        this.wlTargetFile = new Label((Composite)wTargetFileGroup, 131072);
        this.wlTargetFile.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTargetFile);
        FormData fdlTargetFile = new FormData();
        fdlTargetFile.left = new FormAttachment(0, 0);
        fdlTargetFile.top = new FormAttachment((Control)this.wUploadFile, margin);
        fdlTargetFile.right = new FormAttachment(middle, -margin);
        this.wlTargetFile.setLayoutData((Object)fdlTargetFile);
        this.wbTargetFile = new Button((Composite)wTargetFileGroup, 0x1000008);
        PropsUi.setLook((Widget)this.wbTargetFile);
        this.wbTargetFile.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTargetFile = new FormData();
        fdbTargetFile.right = new FormAttachment(100, 0);
        fdbTargetFile.top = new FormAttachment((Control)this.wUploadFile, margin);
        this.wbTargetFile.setLayoutData((Object)fdbTargetFile);
        this.wTargetFile = new TextVar(this.variables, (Composite)wTargetFileGroup, 18436);
        PropsUi.setLook((Widget)this.wTargetFile);
        this.wTargetFile.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFile.Tooltip", (String[])new String[0]));
        this.wTargetFile.addModifyListener(lsMod);
        FormData fdTargetFile = new FormData();
        fdTargetFile.left = new FormAttachment(middle, 0);
        fdTargetFile.top = new FormAttachment((Control)this.wUploadFile, margin);
        fdTargetFile.right = new FormAttachment((Control)this.wbTargetFile, -margin);
        this.wTargetFile.setLayoutData((Object)fdTargetFile);
        this.wbTargetFile.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wTargetFile, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])FILETYPES, (boolean)true));
    }

    private Group setupWebServerReplyGroup(Composite wGeneralComp) {
        Group wTargetFileGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wTargetFileGroup);
        wTargetFileGroup.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.TargetFileGroup.Group.Label", (String[])new String[0]));
        FormLayout targetFileGroupgroupLayout = new FormLayout();
        targetFileGroupgroupLayout.marginWidth = 10;
        targetFileGroupgroupLayout.marginHeight = 10;
        wTargetFileGroup.setLayout((Layout)targetFileGroupgroupLayout);
        return wTargetFileGroup;
    }

    private void setupUploadFileLine(ModifyListener lsMod, int middle, int margin, Group wAuthentication, Group wUpLoadFile) {
        this.wlUploadFile = new Label((Composite)wUpLoadFile, 131072);
        this.wlUploadFile.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.UploadFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUploadFile);
        FormData fdlUploadFile = new FormData();
        fdlUploadFile.left = new FormAttachment(0, 0);
        fdlUploadFile.top = new FormAttachment((Control)wAuthentication, margin);
        fdlUploadFile.right = new FormAttachment(middle, -margin);
        this.wlUploadFile.setLayoutData((Object)fdlUploadFile);
        this.wbUploadFile = new Button((Composite)wUpLoadFile, 0x1000008);
        PropsUi.setLook((Widget)this.wbUploadFile);
        this.wbUploadFile.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbUploadFile = new FormData();
        fdbUploadFile.right = new FormAttachment(100, 0);
        fdbUploadFile.top = new FormAttachment((Control)wAuthentication, margin);
        this.wbUploadFile.setLayoutData((Object)fdbUploadFile);
        this.wUploadFile = new TextVar(this.variables, (Composite)wUpLoadFile, 18436);
        PropsUi.setLook((Widget)this.wUploadFile);
        this.wUploadFile.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.UploadFile.Tooltip", (String[])new String[0]));
        this.wUploadFile.addModifyListener(lsMod);
        FormData fdUploadFile = new FormData();
        fdUploadFile.left = new FormAttachment(middle, 0);
        fdUploadFile.top = new FormAttachment((Control)wAuthentication, margin);
        fdUploadFile.right = new FormAttachment((Control)this.wbUploadFile, -margin);
        this.wUploadFile.setLayoutData((Object)fdUploadFile);
        this.wUploadFile.addModifyListener(e -> this.wUploadFile.setToolTipText(this.variables.resolve(this.wUploadFile.getText())));
        this.wbUploadFile.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wUploadFile, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])FILETYPES, (boolean)true));
    }

    private Group setupUploadFileGroup(Composite wGeneralComp) {
        Group wUpLoadFile = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wUpLoadFile);
        wUpLoadFile.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.UpLoadFile.Group.Label", (String[])new String[0]));
        FormLayout upLoadFilegroupLayout = new FormLayout();
        upLoadFilegroupLayout.marginWidth = 10;
        upLoadFilegroupLayout.marginHeight = 10;
        wUpLoadFile.setLayout((Layout)upLoadFilegroupLayout);
        return wUpLoadFile;
    }

    private void setupIgnoreHostLine(ModifyListener lsMod, int middle, int margin, Group wAuthentication) {
        Label wlNonProxyHosts = new Label((Composite)wAuthentication, 131072);
        wlNonProxyHosts.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.ProxyIgnoreRegexp.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNonProxyHosts);
        FormData fdlNonProxyHosts = new FormData();
        fdlNonProxyHosts.left = new FormAttachment(0, 0);
        fdlNonProxyHosts.top = new FormAttachment((Control)this.wProxyPort, margin);
        fdlNonProxyHosts.right = new FormAttachment(middle, -margin);
        wlNonProxyHosts.setLayoutData((Object)fdlNonProxyHosts);
        this.wNonProxyHosts = new TextVar(this.variables, (Composite)wAuthentication, 18436);
        PropsUi.setLook((Widget)this.wNonProxyHosts);
        this.wNonProxyHosts.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.ProxyIgnoreRegexp.Tooltip", (String[])new String[0]));
        this.wNonProxyHosts.addModifyListener(lsMod);
        FormData fdNonProxyHosts = new FormData();
        fdNonProxyHosts.left = new FormAttachment(middle, 0);
        fdNonProxyHosts.top = new FormAttachment((Control)this.wProxyPort, margin);
        fdNonProxyHosts.right = new FormAttachment(100, 0);
        this.wNonProxyHosts.setLayoutData((Object)fdNonProxyHosts);
    }

    private void setupProxyPortLine(ModifyListener lsMod, int middle, int margin, Group wAuthentication) {
        Label wlProxyPort = new Label((Composite)wAuthentication, 131072);
        wlProxyPort.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.ProxyPort.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProxyPort);
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyServer, margin);
        fdlProxyPort.right = new FormAttachment(middle, -margin);
        wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar(this.variables, (Composite)wAuthentication, 18436);
        PropsUi.setLook((Widget)this.wProxyPort);
        this.wProxyPort.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.ProxyPort.Tooltip", (String[])new String[0]));
        this.wProxyPort.addModifyListener(lsMod);
        FormData fdProxyPort = new FormData();
        fdProxyPort.left = new FormAttachment(middle, 0);
        fdProxyPort.top = new FormAttachment((Control)this.wProxyServer, margin);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
    }

    private void setupProxyServerLine(ModifyListener lsMod, int middle, int margin, Group wAuthentication) {
        Label wlProxyServer = new Label((Composite)wAuthentication, 131072);
        wlProxyServer.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.ProxyHost.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProxyServer);
        FormData fdlProxyServer = new FormData();
        fdlProxyServer.left = new FormAttachment(0, 0);
        fdlProxyServer.top = new FormAttachment((Control)this.wPassword, 3 * margin);
        fdlProxyServer.right = new FormAttachment(middle, -margin);
        wlProxyServer.setLayoutData((Object)fdlProxyServer);
        this.wProxyServer = new TextVar(this.variables, (Composite)wAuthentication, 18436);
        PropsUi.setLook((Widget)this.wProxyServer);
        this.wProxyServer.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.ProxyHost.Tooltip", (String[])new String[0]));
        this.wProxyServer.addModifyListener(lsMod);
        FormData fdProxyServer = new FormData();
        fdProxyServer.left = new FormAttachment(middle, 0);
        fdProxyServer.top = new FormAttachment((Control)this.wPassword, 3 * margin);
        fdProxyServer.right = new FormAttachment(100, 0);
        this.wProxyServer.setLayoutData((Object)fdProxyServer);
    }

    private void setupPasswordLine(ModifyListener lsMod, int middle, int margin, Group wAuthentication) {
        Label wlPassword = new Label((Composite)wAuthentication, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.UploadPassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdlPassword.right = new FormAttachment(middle, -margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.variables, (Composite)wAuthentication, 18436);
        PropsUi.setLook((Widget)this.wPassword);
        this.wPassword.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.UploadPassword.Tooltip", (String[])new String[0]));
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
    }

    private void setupUsernameLine(ModifyListener lsMod, int middle, int margin, Group wAuthentication) {
        Label wlUserName = new Label((Composite)wAuthentication, 131072);
        wlUserName.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.UploadUser.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUserName);
        FormData fdlUserName = new FormData();
        fdlUserName.left = new FormAttachment(0, 0);
        fdlUserName.top = new FormAttachment((Control)this.wFieldTarget, margin);
        fdlUserName.right = new FormAttachment(middle, -margin);
        wlUserName.setLayoutData((Object)fdlUserName);
        this.wUserName = new TextVar(this.variables, (Composite)wAuthentication, 18436);
        PropsUi.setLook((Widget)this.wUserName);
        this.wUserName.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.UploadUser.Tooltip", (String[])new String[0]));
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(middle, 0);
        fdUserName.top = new FormAttachment((Control)this.wFieldTarget, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
    }

    private Group setupAuthGroup(Composite wGeneralComp) {
        Group wAuthentication = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wAuthentication);
        wAuthentication.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.Authentication.Group.Label", (String[])new String[0]));
        FormLayout authenticationgroupLayout = new FormLayout();
        authenticationgroupLayout.marginWidth = 10;
        authenticationgroupLayout.marginHeight = 10;
        wAuthentication.setLayout((Layout)authenticationgroupLayout);
        return wAuthentication;
    }

    private void setupDestFileLine(ModifyListener lsMod, int middle, int margin, Composite wGeneralComp) {
        this.wlFieldTarget = new Label(wGeneralComp, 131072);
        this.wlFieldTarget.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.InputFieldDest.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFieldTarget);
        FormData fdlFieldTarget = new FormData();
        fdlFieldTarget.left = new FormAttachment(0, 0);
        fdlFieldTarget.top = new FormAttachment((Control)this.wFieldUpload, margin);
        fdlFieldTarget.right = new FormAttachment(middle, -margin);
        this.wlFieldTarget.setLayoutData((Object)fdlFieldTarget);
        this.wFieldTarget = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wFieldTarget);
        this.wFieldTarget.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.InputFieldDest.Tooltip", (String[])new String[0]));
        this.wFieldTarget.addModifyListener(lsMod);
        FormData fdFieldTarget = new FormData();
        fdFieldTarget.left = new FormAttachment(middle, 0);
        fdFieldTarget.top = new FormAttachment((Control)this.wFieldUpload, margin);
        fdFieldTarget.right = new FormAttachment(100, 0);
        this.wFieldTarget.setLayoutData((Object)fdFieldTarget);
    }

    private void setupUploadFileLine(ModifyListener lsMod, int middle, int margin, Composite wGeneralComp) {
        this.wlFieldUpload = new Label(wGeneralComp, 131072);
        this.wlFieldUpload.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.InputFieldUpload.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFieldUpload);
        FormData fdlFieldUpload = new FormData();
        fdlFieldUpload.left = new FormAttachment(0, 0);
        fdlFieldUpload.top = new FormAttachment((Control)this.wFieldURL, margin);
        fdlFieldUpload.right = new FormAttachment(middle, -margin);
        this.wlFieldUpload.setLayoutData((Object)fdlFieldUpload);
        this.wFieldUpload = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wFieldUpload);
        this.wFieldUpload.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.InputFieldUpload.Tooltip", (String[])new String[0]));
        this.wFieldUpload.addModifyListener(lsMod);
        FormData fdFieldUpload = new FormData();
        fdFieldUpload.left = new FormAttachment(middle, 0);
        fdFieldUpload.top = new FormAttachment((Control)this.wFieldURL, margin);
        fdFieldUpload.right = new FormAttachment(100, 0);
        this.wFieldUpload.setLayoutData((Object)fdFieldUpload);
    }

    private void setupUrlFieldLine(ModifyListener lsMod, int middle, int margin, Composite wGeneralComp) {
        this.wlFieldURL = new Label(wGeneralComp, 131072);
        this.wlFieldURL.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.InputField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFieldURL);
        FormData fdlFieldURL = new FormData();
        fdlFieldURL.left = new FormAttachment(0, 0);
        fdlFieldURL.top = new FormAttachment((Control)this.wRunEveryRow, 2 * margin);
        fdlFieldURL.right = new FormAttachment(middle, -margin);
        this.wlFieldURL.setLayoutData((Object)fdlFieldURL);
        this.wFieldURL = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wFieldURL);
        this.wFieldURL.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.InputField.Tooltip", (String[])new String[0]));
        this.wFieldURL.addModifyListener(lsMod);
        FormData fdFieldURL = new FormData();
        fdFieldURL.left = new FormAttachment(middle, 0);
        fdFieldURL.top = new FormAttachment((Control)this.wRunEveryRow, 2 * margin);
        fdFieldURL.right = new FormAttachment(100, 0);
        this.wFieldURL.setLayoutData((Object)fdFieldURL);
    }

    private void setupRunEveryRwoLine(int middle, int margin, Composite wGeneralComp) {
        Label wlRunEveryRow = new Label(wGeneralComp, 131072);
        wlRunEveryRow.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.RunForEveryRow.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRunEveryRow);
        FormData fdlRunEveryRow = new FormData();
        fdlRunEveryRow.left = new FormAttachment(0, 0);
        fdlRunEveryRow.top = new FormAttachment((Control)this.wIgnoreSsl, margin);
        fdlRunEveryRow.right = new FormAttachment(middle, -margin);
        wlRunEveryRow.setLayoutData((Object)fdlRunEveryRow);
        this.wRunEveryRow = new Button(wGeneralComp, 32);
        this.wRunEveryRow.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.RunForEveryRow.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wRunEveryRow);
        FormData fdRunEveryRow = new FormData();
        fdRunEveryRow.left = new FormAttachment(middle, 0);
        fdRunEveryRow.top = new FormAttachment((Control)wlRunEveryRow, 0, 0x1000000);
        fdRunEveryRow.right = new FormAttachment(100, 0);
        this.wRunEveryRow.setLayoutData((Object)fdRunEveryRow);
        this.wRunEveryRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionHttpDialog.this.setFlags();
            }
        });
    }

    private Label setupIgnoreSslLine(int middle, int margin, Composite wGeneralComp) {
        Label wlIgnoreSsl = new Label(wGeneralComp, 131072);
        wlIgnoreSsl.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.IgnoreSsl.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnoreSsl);
        FormData fdlIgnoreSsl = new FormData();
        fdlIgnoreSsl.left = new FormAttachment(0, 0);
        fdlIgnoreSsl.top = new FormAttachment((Control)this.wURL, margin);
        fdlIgnoreSsl.right = new FormAttachment(middle, -margin);
        wlIgnoreSsl.setLayoutData((Object)fdlIgnoreSsl);
        this.wIgnoreSsl = new Button(wGeneralComp, 32);
        this.wIgnoreSsl.setToolTipText(BaseMessages.getString(PKG, (String)"ActionHTTP.IgnoreSsl.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wIgnoreSsl);
        FormData fdIgnoreSsl = new FormData();
        fdIgnoreSsl.left = new FormAttachment(middle, 0);
        fdIgnoreSsl.top = new FormAttachment((Control)wlIgnoreSsl, 0, 0x1000000);
        fdIgnoreSsl.right = new FormAttachment(100, 0);
        this.wIgnoreSsl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionHttpDialog.this.action.setChanged();
            }
        });
        this.wIgnoreSsl.setLayoutData((Object)fdIgnoreSsl);
        return wlIgnoreSsl;
    }

    private void setupUrlLine(ModifyListener lsMod, int middle, int margin, Composite wGeneralComp) {
        this.wlURL = new Label(wGeneralComp, 131072);
        this.wlURL.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.URL.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlURL);
        FormData fdlURL = new FormData();
        fdlURL.left = new FormAttachment(0, 0);
        fdlURL.top = new FormAttachment((Control)this.wName, 2 * margin);
        fdlURL.right = new FormAttachment(middle, -margin);
        this.wlURL.setLayoutData((Object)fdlURL);
        this.wURL = new TextVar(this.variables, wGeneralComp, 18436, BaseMessages.getString(PKG, (String)"ActionHTTP.URL.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wURL);
        this.wURL.addModifyListener(lsMod);
        FormData fdURL = new FormData();
        fdURL.left = new FormAttachment(middle, 0);
        fdURL.top = new FormAttachment((Control)this.wName, 2 * margin);
        fdURL.right = new FormAttachment(100, 0);
        this.wURL.setLayoutData((Object)fdURL);
    }

    private void setupActionName(ModifyListener lsMod, int middle, int margin) {
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionHTTP.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
    }

    private Button setupButtons(int margin) {
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        return wOk;
    }

    private void setFlags() {
        this.wlURL.setEnabled(!this.wRunEveryRow.getSelection());
        this.wURL.setEnabled(!this.wRunEveryRow.getSelection());
        this.wlFieldURL.setEnabled(this.wRunEveryRow.getSelection());
        this.wFieldURL.setEnabled(this.wRunEveryRow.getSelection());
        this.wlFieldUpload.setEnabled(this.wRunEveryRow.getSelection());
        this.wFieldUpload.setEnabled(this.wRunEveryRow.getSelection());
        this.wlFieldTarget.setEnabled(this.wRunEveryRow.getSelection());
        this.wFieldTarget.setEnabled(this.wRunEveryRow.getSelection());
        this.wlUploadFile.setEnabled(!this.wRunEveryRow.getSelection());
        this.wUploadFile.setEnabled(!this.wRunEveryRow.getSelection());
        this.wbUploadFile.setEnabled(!this.wRunEveryRow.getSelection());
        this.wlTargetFile.setEnabled(!this.wRunEveryRow.getSelection());
        this.wbTargetFile.setEnabled(!this.wRunEveryRow.getSelection());
        this.wTargetFile.setEnabled(!this.wRunEveryRow.getSelection());
        this.wlDateTimeAdded.setEnabled(!this.wRunEveryRow.getSelection());
        this.wDateTimeAdded.setEnabled(!this.wRunEveryRow.getSelection());
        this.wlAppend.setEnabled(this.wRunEveryRow.getSelection() ? false : !this.wDateTimeAdded.getSelection());
        this.wAppend.setEnabled(this.wRunEveryRow.getSelection() ? false : !this.wDateTimeAdded.getSelection());
        this.wlTargetExt.setEnabled(this.wRunEveryRow.getSelection() ? false : this.wDateTimeAdded.getSelection());
        this.wTargetExt.setEnabled(this.wRunEveryRow.getSelection() ? false : this.wDateTimeAdded.getSelection());
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        this.wURL.setText(Const.NVL((String)this.action.getUrl(), (String)""));
        this.wRunEveryRow.setSelection(this.action.isRunForEveryRow());
        this.wIgnoreSsl.setSelection(this.action.isIgnoreSsl());
        this.wFieldURL.setText(Const.NVL((String)this.action.getUrlFieldname(), (String)""));
        this.wFieldUpload.setText(Const.NVL((String)this.action.getUploadFieldname(), (String)""));
        this.wFieldTarget.setText(Const.NVL((String)this.action.getDestinationFieldname(), (String)""));
        this.wTargetFile.setText(Const.NVL((String)this.action.getTargetFilename(), (String)""));
        this.wAppend.setSelection(this.action.isFileAppended());
        this.wDateTimeAdded.setSelection(this.action.isDateTimeAdded());
        this.wTargetExt.setText(Const.NVL((String)this.action.getTargetFilenameExtension(), (String)""));
        this.wUploadFile.setText(Const.NVL((String)this.action.getUploadFilename(), (String)""));
        this.action.setDateTimeAdded(this.wDateTimeAdded.getSelection());
        this.action.setTargetFilenameExtension(this.wTargetExt.getText());
        this.wUserName.setText(Const.NVL((String)this.action.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.action.getPassword(), (String)""));
        this.wProxyServer.setText(Const.NVL((String)this.action.getProxyHostname(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.action.getProxyPort(), (String)""));
        this.wNonProxyHosts.setText(Const.NVL((String)this.action.getNonProxyHosts(), (String)""));
        if (this.action.getHeaders() != null) {
            int i;
            String[] headerNames = new String[this.action.getHeaders().size()];
            String[] headerValues = new String[this.action.getHeaders().size()];
            for (i = 0; i < this.action.getHeaders().size(); ++i) {
                headerNames[i] = this.action.getHeaders().get(i).getHeaderName();
                headerValues[i] = this.action.getHeaders().get(i).getHeaderValue();
            }
            if (headerNames != null) {
                for (i = 0; i < headerNames.length; ++i) {
                    TableItem ti = this.wHeaders.table.getItem(i);
                    if (headerNames[i] != null) {
                        ti.setText(1, headerNames[i]);
                    }
                    if (headerValues[i] == null) continue;
                    ti.setText(2, headerValues[i]);
                }
                this.wHeaders.setRowNums();
                this.wHeaders.optWidth(true);
            }
        }
        this.wAddFilenameToResult.setSelection(this.action.isAddFilenameToResult());
        this.setFlags();
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setUrl(this.wURL.getText());
        this.action.setRunForEveryRow(this.wRunEveryRow.getSelection());
        this.action.setIgnoreSsl(this.wIgnoreSsl.getSelection());
        this.action.setUrlFieldname(this.wFieldURL.getText());
        this.action.setUploadFieldname(this.wFieldUpload.getText());
        this.action.setDestinationFieldname(this.wFieldTarget.getText());
        this.action.setUsername(this.wUserName.getText());
        this.action.setPassword(this.wPassword.getText());
        this.action.setProxyHostname(this.wProxyServer.getText());
        this.action.setProxyPort(this.wProxyPort.getText());
        this.action.setNonProxyHosts(this.wNonProxyHosts.getText());
        this.action.setUploadFilename(this.wUploadFile.getText());
        this.action.setTargetFilename(this.wRunEveryRow.getSelection() ? "" : this.wTargetFile.getText());
        this.action.setFileAppended(this.wRunEveryRow.getSelection() ? false : this.wAppend.getSelection());
        this.action.setDateTimeAdded(this.wRunEveryRow.getSelection() ? false : this.wDateTimeAdded.getSelection());
        this.action.setTargetFilenameExtension(this.wRunEveryRow.getSelection() ? "" : this.wTargetExt.getText());
        this.action.setAddFilenameToResult(this.wAddFilenameToResult.getSelection());
        ArrayList<ActionHttp.Header> headers = new ArrayList<ActionHttp.Header>();
        for (int i = 0; i < this.wHeaders.nrNonEmpty(); ++i) {
            String varname = this.wHeaders.getNonEmpty(i).getText(1);
            String varvalue = this.wHeaders.getNonEmpty(i).getText(2);
            ActionHttp.Header header = new ActionHttp.Header();
            if (!Utils.isEmpty((CharSequence)varname)) {
                header.setHeaderName(varname);
                header.setHeaderValue(varvalue);
            }
            headers.add(header);
        }
        this.action.setHeaders(headers);
        this.dispose();
    }
}

