/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.beam.runners.core.LateDataUtils;
import org.apache.beam.runners.core.MergingStateAccessor;
import org.apache.beam.runners.core.StateMerging;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

class WatermarkHold<@UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements Serializable {
    @VisibleForTesting
    public static final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> EXTRA_HOLD_TAG = StateTags.makeSystemTagInternal(StateTags.watermarkStateInternal("extra", TimestampCombiner.EARLIEST));
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy;
    private final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> elementHoldTag;

    public static @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> watermarkHoldTagForTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
        return StateTags.makeSystemTagInternal(StateTags.watermarkStateInternal("hold", timestampCombiner));
    }

    public WatermarkHold(@UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        this.timerInternals = timerInternals;
        this.windowingStrategy = windowingStrategy;
        this.elementHoldTag = WatermarkHold.watermarkHoldTagForTimestampCombiner(windowingStrategy.getTimestampCombiner());
    }

    public @Nullable @UnknownKeyFor @Initialized Instant addHolds(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized ProcessValueContext context) {
        Instant hold = this.addElementHold(context.timestamp(), context);
        if (hold == null) {
            hold = this.addGarbageCollectionHold(context, false);
        }
        return hold;
    }

    private @UnknownKeyFor @NonNull @Initialized Instant shift(@UnknownKeyFor @NonNull @Initialized Instant timestamp, W window) {
        Instant shifted = this.windowingStrategy.getTimestampCombiner().assign(window, timestamp);
        if (shifted.isBefore((ReadableInstant)timestamp)) {
            throw new IllegalStateException(String.format("TimestampCombiner moved element from %s to earlier time %s for window %s", BoundedWindow.formatTimestamp((Instant)timestamp), BoundedWindow.formatTimestamp((Instant)shifted), window));
        }
        Preconditions.checkState((timestamp.isAfter((ReadableInstant)window.maxTimestamp()) || !shifted.isAfter((ReadableInstant)window.maxTimestamp()) ? 1 : 0) != 0, (String)"TimestampCombiner moved element from %s to %s which is beyond end of window %s", (Object)timestamp, (Object)shifted, window);
        return shifted;
    }

    private @Nullable @UnknownKeyFor @Initialized Instant addElementHold(@UnknownKeyFor @NonNull @Initialized Instant timestamp, /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context) {
        boolean tooLate;
        String which;
        Instant elementHold = this.shift(timestamp, context.window());
        Instant outputWM = this.timerInternals.currentOutputWatermarkTime();
        Instant inputWM = this.timerInternals.currentInputWatermarkTime();
        if (outputWM != null && elementHold.isBefore((ReadableInstant)outputWM)) {
            which = "too late to effect output watermark";
            tooLate = true;
        } else if (context.window().maxTimestamp().isBefore((ReadableInstant)inputWM)) {
            which = "too late for end-of-window timer";
            tooLate = true;
        } else {
            which = "on time";
            tooLate = false;
            Preconditions.checkState((!elementHold.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE) ? 1 : 0) != 0, (String)"Element hold %s is beyond end-of-time", (Object)elementHold);
            context.state().access(this.elementHoldTag).add((Object)elementHold);
        }
        WindowTracing.trace((String)"WatermarkHold.addHolds: element hold at {} is {} for key:{}; window:{}; inputWatermark:{}; outputWatermark:{}", (Object[])new Object[]{elementHold, which, context.key(), context.window(), inputWM, outputWM});
        return tooLate ? null : elementHold;
    }

    private @Nullable @UnknownKeyFor @Initialized Instant addGarbageCollectionHold(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized boolean paneIsEmpty) {
        Instant outputWM = this.timerInternals.currentOutputWatermarkTime();
        Instant inputWM = this.timerInternals.currentInputWatermarkTime();
        Instant gcHold = LateDataUtils.garbageCollectionTime(context.window(), this.windowingStrategy);
        if (gcHold.isBefore((ReadableInstant)inputWM)) {
            WindowTracing.trace((String)"{}.addGarbageCollectionHold: gc hold would be before the input watermark for key:{}; window: {}; inputWatermark: {}; outputWatermark: {}", (Object[])new Object[]{this.getClass().getSimpleName(), context.key(), context.window(), inputWM, outputWM});
            return null;
        }
        if (paneIsEmpty && context.windowingStrategy().getClosingBehavior() == Window.ClosingBehavior.FIRE_IF_NON_EMPTY) {
            WindowTracing.trace((String)"WatermarkHold.addGarbageCollectionHold: garbage collection hold at {} is unnecessary since empty pane and FIRE_IF_NON_EMPTY for key:{}; window:{}; inputWatermark:{}; outputWatermark:{}", (Object[])new Object[]{gcHold, context.key(), context.window(), inputWM, outputWM});
            return null;
        }
        if (!gcHold.isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
            gcHold = BoundedWindow.TIMESTAMP_MAX_VALUE.minus((ReadableDuration)Duration.millis((long)1L));
        }
        Preconditions.checkState((!gcHold.isBefore((ReadableInstant)inputWM) ? 1 : 0) != 0, (String)"Garbage collection hold %s cannot be before input watermark %s", (Object)gcHold, (Object)inputWM);
        Preconditions.checkState((!gcHold.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE) ? 1 : 0) != 0, (String)"Garbage collection hold %s is beyond end-of-time", (Object)gcHold);
        context.state().access(EXTRA_HOLD_TAG).add((Object)gcHold);
        WindowTracing.trace((String)"WatermarkHold.addGarbageCollectionHold: garbage collection hold at {} is on time for key:{}; window:{}; inputWatermark:{}; outputWatermark:{}", (Object[])new Object[]{gcHold, context.key(), context.window(), inputWM, outputWM});
        return gcHold;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public void prefetchOnMerge(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MergingStateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> context) {
        Map<W, WatermarkHoldState> map = context.accessInEachMergingWindow(this.elementHoldTag);
        WatermarkHoldState result = context.access(this.elementHoldTag);
        if (map.isEmpty()) {
            return;
        }
        if (map.size() == 1 && map.values().contains(result) && result.getTimestampCombiner().dependsOnlyOnEarliestTimestamp()) {
            return;
        }
        if (result.getTimestampCombiner().dependsOnlyOnWindow()) {
            return;
        }
        for (WatermarkHoldState source : map.values()) {
            source.readLater();
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public void onMerge(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnMergeContext context) {
        WindowTracing.debug((String)"WatermarkHold.onMerge: for key:{}; window:{}; inputWatermark:{}; outputWatermark:{}", (Object[])new Object[]{context.key(), context.window(), this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime()});
        Collection<WatermarkHoldState> sources = context.state().accessInEachMergingWindow(this.elementHoldTag).values();
        WatermarkHoldState result = context.state().access(this.elementHoldTag);
        if (!(sources.isEmpty() || sources.size() == 1 && sources.contains(result) && result.getTimestampCombiner().dependsOnlyOnEarliestTimestamp())) {
            if (result.getTimestampCombiner().dependsOnlyOnWindow()) {
                for (WatermarkHoldState source : sources) {
                    source.clear();
                }
                this.addElementHold(BoundedWindow.TIMESTAMP_MIN_VALUE, context);
            } else {
                for (WatermarkHoldState source : sources) {
                    source.readLater();
                }
                Instant mergedHold = null;
                for (ReadableState readableState : sources) {
                    Instant sourceOutputTime = (Instant)readableState.read();
                    if (sourceOutputTime == null) continue;
                    if (mergedHold == null) {
                        mergedHold = sourceOutputTime;
                        continue;
                    }
                    mergedHold = result.getTimestampCombiner().merge(context.window(), new Instant[]{mergedHold, sourceOutputTime});
                }
                for (WatermarkHoldState watermarkHoldState : sources) {
                    watermarkHoldState.clear();
                }
                if (mergedHold != null) {
                    result.add(mergedHold);
                }
            }
        }
        StateMerging.clear(context.state(), EXTRA_HOLD_TAG);
        this.addGarbageCollectionHold(context, false);
    }

    public void prefetchExtract(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context) {
        context.state().access(this.elementHoldTag).readLater();
        context.state().access(EXTRA_HOLD_TAG).readLater();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized OldAndNewHolds> extractAndRelease(final /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context, final @UnknownKeyFor @NonNull @Initialized boolean isFinished) {
        WindowTracing.debug((String)"WatermarkHold.extractAndRelease: for key:{}; window:{}; inputWatermark:{}; outputWatermark:{}", (Object[])new Object[]{context.key(), context.window(), this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime()});
        final WatermarkHoldState elementHoldState = context.state().access(this.elementHoldTag);
        final WatermarkHoldState extraHoldState = context.state().access(EXTRA_HOLD_TAG);
        return new ReadableState<OldAndNewHolds>(){

            public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized OldAndNewHolds> readLater() {
                elementHoldState.readLater();
                extraHoldState.readLater();
                return this;
            }

            public @UnknownKeyFor @NonNull @Initialized OldAndNewHolds read() {
                @Nullable Instant elementHold = (Instant)elementHoldState.read();
                @Nullable Instant extraHold = (Instant)extraHoldState.read();
                Instant oldHold = elementHold == null ? extraHold : (extraHold == null ? elementHold : (elementHold.isBefore((ReadableInstant)extraHold) ? elementHold : extraHold));
                if (oldHold == null || oldHold.isAfter((ReadableInstant)context.window().maxTimestamp())) {
                    WindowTracing.debug((String)"WatermarkHold.extractAndRelease.read: clipping from {} to end of window for key:{}; window:{}", (Object[])new Object[]{oldHold, context.key(), context.window()});
                    oldHold = context.window().maxTimestamp();
                }
                WindowTracing.debug((String)"WatermarkHold.extractAndRelease.read: clearing for key:{}; window:{}", (Object[])new Object[]{context.key(), context.window()});
                elementHoldState.clear();
                extraHoldState.clear();
                Instant newHold = null;
                if (!isFinished) {
                    newHold = WatermarkHold.this.addGarbageCollectionHold(context, true);
                }
                return new OldAndNewHolds(oldHold, newHold);
            }
        };
    }

    public void clearHolds(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context) {
        WindowTracing.debug((String)"WatermarkHold.clearHolds: For key:{}; window:{}; inputWatermark:{}; outputWatermark:{}", (Object[])new Object[]{context.key(), context.window(), this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime()});
        context.state().access(this.elementHoldTag).clear();
        context.state().access(EXTRA_HOLD_TAG).clear();
    }

    public @Nullable @UnknownKeyFor @Initialized Instant getDataCurrent(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context) {
        return (Instant)context.state().access(this.elementHoldTag).read();
    }

    public static class OldAndNewHolds {
        public final @UnknownKeyFor @NonNull @Initialized Instant oldHold;
        public final @Nullable @UnknownKeyFor @Initialized Instant newHold;

        public OldAndNewHolds(@UnknownKeyFor @NonNull @Initialized Instant oldHold, @Nullable @UnknownKeyFor @Initialized Instant newHold) {
            this.oldHold = oldHold;
            this.newHold = newHold;
        }
    }
}

