/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.environment;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.DescribedVariablesConfigFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LifecycleEnvironmentDialog
extends Dialog {
    private static final Class<?> PKG = LifecycleEnvironmentDialog.class;
    public static final String CONST_ERROR = "Error";
    private final LifecycleEnvironment environment;
    private String returnValue;
    private Shell shell;
    private final PropsUi props;
    private Text wName;
    private Combo wPurpose;
    private Combo wProject;
    private TableView wConfigFiles;
    private IVariables variables;
    private Button wbEdit;
    private String originalName;
    private boolean needingEnvironmentRefresh;

    public LifecycleEnvironmentDialog(Shell parent, LifecycleEnvironment environment, IVariables variables) {
        super(parent, 67696);
        this.environment = environment;
        this.variables = variables;
        this.originalName = environment.getName();
        this.props = PropsUi.getInstance();
        this.needingEnvironmentRefresh = false;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setImage(GuiResource.getInstance().getImage("environment.svg", PKG.getClassLoader(), 16, 16));
        PropsUi.setLook((Widget)this.shell);
        int margin = PropsUi.getMargin() + 2;
        int middle = this.props.getMiddlePct();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Shell.Name", (String[])new String[0]));
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOK.addListener(13, event -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, event -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOK, wCancel}, (int)(margin * 3), null);
        Label wlName = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Label.EnvironmentName", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(100, 0);
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlPurpose = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlPurpose);
        wlPurpose.setText(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Label.EnvironmentPurpose", (String[])new String[0]));
        FormData fdlPurpose = new FormData();
        fdlPurpose.left = new FormAttachment(0, 0);
        fdlPurpose.right = new FormAttachment(middle, 0);
        fdlPurpose.top = new FormAttachment((Control)lastControl, margin);
        wlPurpose.setLayoutData((Object)fdlPurpose);
        this.wPurpose = new Combo((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPurpose);
        FormData fdPurpose = new FormData();
        fdPurpose.left = new FormAttachment(middle, margin);
        fdPurpose.right = new FormAttachment(100, 0);
        fdPurpose.top = new FormAttachment((Control)wlPurpose, 0, 0x1000000);
        this.wPurpose.setLayoutData((Object)fdPurpose);
        this.wPurpose.addListener(24, e -> {
            this.needingEnvironmentRefresh = true;
        });
        lastControl = this.wPurpose;
        Label wlProject = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlProject);
        wlProject.setText(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Label.ReferencedProject", (String[])new String[0]));
        FormData fdlProject = new FormData();
        fdlProject.left = new FormAttachment(0, 0);
        fdlProject.right = new FormAttachment(middle, 0);
        fdlProject.top = new FormAttachment((Control)lastControl, margin);
        wlProject.setLayoutData((Object)fdlProject);
        this.wProject = new Combo((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wProject);
        FormData fdProject = new FormData();
        fdProject.left = new FormAttachment(middle, margin);
        fdProject.right = new FormAttachment(100, 0);
        fdProject.top = new FormAttachment((Control)wlProject, 0, 0x1000000);
        this.wProject.setLayoutData((Object)fdProject);
        this.wProject.addListener(24, e -> {
            this.needingEnvironmentRefresh = true;
        });
        lastControl = this.wProject;
        Label wlConfigFiles = new Label((Composite)this.shell, 16384);
        PropsUi.setLook((Widget)wlConfigFiles);
        wlConfigFiles.setText(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Group.Label.ConfigurationFiles", (String[])new String[0]));
        FormData fdlConfigFiles = new FormData();
        fdlConfigFiles.left = new FormAttachment(0, 0);
        fdlConfigFiles.right = new FormAttachment(100, 0);
        fdlConfigFiles.top = new FormAttachment((Control)lastControl, margin);
        wlConfigFiles.setLayoutData((Object)fdlConfigFiles);
        Button wbSelect = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbSelect);
        wbSelect.setText(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Button.Select", (String[])new String[0]));
        FormData fdAdd = new FormData();
        fdAdd.right = new FormAttachment(100, 0);
        fdAdd.top = new FormAttachment((Control)wlConfigFiles, margin);
        wbSelect.setLayoutData((Object)fdAdd);
        wbSelect.addListener(13, this::addConfigFile);
        ColumnInfo[] columnInfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.DetailTable.Label.Filename", (String[])new String[0]), 1, false, false)};
        columnInfo[0].setUsingVariables(true);
        this.wConfigFiles = new TableView(this.variables, (Composite)this.shell, 2052, columnInfo, this.environment.getConfigurationFiles().size(), null, this.props);
        PropsUi.setLook((Widget)this.wConfigFiles);
        FormData fdConfigFiles = new FormData();
        fdConfigFiles.left = new FormAttachment(0, 0);
        fdConfigFiles.right = new FormAttachment((Control)wbSelect, -2 * margin);
        fdConfigFiles.top = new FormAttachment((Control)wlConfigFiles, margin);
        fdConfigFiles.bottom = new FormAttachment((Control)wOK, -margin * 2);
        this.wConfigFiles.setLayoutData((Object)fdConfigFiles);
        this.wConfigFiles.table.addListener(13, this::setButtonStates);
        Button wbNew = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbNew);
        wbNew.setText(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Button.New", (String[])new String[0]));
        FormData fdNew = new FormData();
        fdNew.left = new FormAttachment((Control)this.wConfigFiles, 2 * margin);
        fdNew.right = new FormAttachment(100, 0);
        fdNew.top = new FormAttachment((Control)wbSelect, margin);
        wbNew.setLayoutData((Object)fdNew);
        wbNew.addListener(13, this::newConfigFile);
        this.wbEdit = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)this.wbEdit);
        this.wbEdit.setText(BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Button.Edit", (String[])new String[0]));
        FormData fdEdit = new FormData();
        fdEdit.left = new FormAttachment((Control)this.wConfigFiles, 2 * margin);
        fdEdit.right = new FormAttachment(100, 0);
        fdEdit.top = new FormAttachment((Control)wbNew, margin);
        this.wbEdit.setLayoutData((Object)fdEdit);
        this.wbEdit.addListener(13, this::editConfigFile);
        this.getData();
        this.wName.setFocus();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.returnValue;
    }

    private void editConfigFile(Event event) {
        try {
            int index = this.wConfigFiles.getSelectionIndex();
            if (index < 0) {
                return;
            }
            String configFilename = this.wConfigFiles.getItem(index, 1);
            if (StringUtils.isEmpty((String)configFilename)) {
                return;
            }
            String realConfigFilename = this.variables.resolve(configFilename);
            DescribedVariablesConfigFile variablesConfigFile = new DescribedVariablesConfigFile(realConfigFilename);
            FileObject file = HopVfs.getFileObject((String)realConfigFilename);
            if (!file.exists()) {
                MessageBox box = new MessageBox(this.shell, 196);
                box.setText("Create file?");
                box.setMessage("This configuration file doesn't exist.  Do you want to create it?");
                int answer = box.open();
                if ((answer & 0x80) != 0) {
                    return;
                }
            } else {
                variablesConfigFile.readFromFile();
            }
            boolean changed = HopGui.editConfigFile((Shell)this.shell, (String)realConfigFilename, (DescribedVariablesConfigFile)variablesConfigFile, null);
            if (changed) {
                this.needingEnvironmentRefresh = true;
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error editing configuration file", e);
        }
    }

    private void addConfigFile(Event event) {
        String configFile = BaseDialog.presentFileDialog((Shell)this.shell, null, (IVariables)this.variables, (String[])new String[]{"*.json", "*"}, (String[])new String[]{"Config JSON files", "All files"}, (boolean)true);
        if (configFile != null) {
            TableItem item = new TableItem(this.wConfigFiles.table, 0);
            item.setText(1, configFile);
            this.wConfigFiles.removeEmptyRows();
            this.wConfigFiles.setRowNums();
            this.wConfigFiles.optWidth(true);
            this.wConfigFiles.table.setSelection(item);
            this.needingEnvironmentRefresh = true;
        }
    }

    private void newConfigFile(Event event) {
        try {
            FileObject fileObject;
            String configFile;
            ProjectConfig projectConfig;
            Object filename = "environment-conf.json";
            String projectName = this.wProject.getText();
            if (StringUtils.isNotEmpty((String)projectName) && (projectConfig = ProjectsConfigSingleton.getConfig().findProjectConfig(projectName)) != null) {
                String environmentName = Const.NVL((String)this.wName.getText(), (String)projectName);
                filename = projectConfig.getProjectHome() + Const.FILE_SEPARATOR + ".." + Const.FILE_SEPARATOR + environmentName + "-config.json";
            }
            if ((configFile = BaseDialog.presentFileDialog((boolean)true, (Shell)this.shell, null, (IVariables)this.variables, (FileObject)(fileObject = HopVfs.getFileObject((String)filename)), (String[])new String[]{"*.json", "*"}, (String[])new String[]{"Config JSON files", "All files"}, (boolean)true)) != null) {
                TableItem item = new TableItem(this.wConfigFiles.table, 0);
                item.setText(1, configFile);
                this.wConfigFiles.removeEmptyRows();
                this.wConfigFiles.setRowNums();
                this.wConfigFiles.optWidth(true);
                this.wConfigFiles.table.setSelection(item);
                this.needingEnvironmentRefresh = true;
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), CONST_ERROR, "Error creating new environment configuration file", e);
        }
    }

    private void setButtonStates(Event event) {
        int index = this.wConfigFiles.getSelectionIndex();
        this.wbEdit.setEnabled(index >= 0);
        this.wbEdit.setGrayed(index < 0);
    }

    private void ok() {
        try {
            String environmentName = this.wName.getText();
            if (StringUtils.isEmpty((String)environmentName)) {
                throw new HopException("Please give your environment a name");
            }
            if (StringUtils.isNotEmpty((String)this.originalName) && !this.originalName.equals(environmentName)) {
                this.wName.setText(this.originalName);
                throw new HopException("Sorry, renaming environment '" + this.originalName + "' is not supported.");
            }
            this.getInfo(this.environment);
            this.returnValue = this.environment.getName();
            this.dispose();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, CONST_ERROR, "There is a configuration error in the environment", e);
        }
    }

    private void cancel() {
        this.needingEnvironmentRefresh = false;
        this.returnValue = null;
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void getData() {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        this.wProject.setItems(config.listProjectConfigNames().toArray(new String[0]));
        this.wPurpose.setItems(new String[]{BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Purpose.Text.Development", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Purpose.Text.Testing", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Purpose.Text.Acceptance", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Purpose.Text.Production", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Purpose.Text.CI", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LifecycleEnvironmentDialog.Purpose.Text.CB", (String[])new String[0])});
        this.wName.setText(Const.NVL((String)this.environment.getName(), (String)""));
        this.wPurpose.setText(Const.NVL((String)this.environment.getPurpose(), (String)""));
        this.wProject.setText(Const.NVL((String)this.environment.getProjectName(), (String)""));
        for (int i = 0; i < this.environment.getConfigurationFiles().size(); ++i) {
            String configurationFile = this.environment.getConfigurationFiles().get(i);
            TableItem item = this.wConfigFiles.table.getItem(i);
            item.setText(1, Const.NVL((String)configurationFile, (String)""));
        }
        this.wConfigFiles.setRowNums();
        this.wConfigFiles.optWidth(true);
        if (!this.environment.getConfigurationFiles().isEmpty()) {
            this.wConfigFiles.setSelection(new int[]{0});
        }
    }

    private void getInfo(LifecycleEnvironment env) {
        env.setName(this.wName.getText());
        env.setPurpose(this.wPurpose.getText());
        env.setProjectName(this.wProject.getText());
        env.getConfigurationFiles().clear();
        for (TableItem item : this.wConfigFiles.getNonEmptyItems()) {
            env.getConfigurationFiles().add(item.getText(1));
        }
    }

    public boolean isNeedingEnvironmentRefresh() {
        return this.needingEnvironmentRefresh;
    }
}

