/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.config;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.util.ProjectsUtil;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="ProjectsConfigOptionPlugin", description="Configuration options for the global projects plugin")
@GuiPlugin(description="i18n::ProjectConfig.Tab.Name")
public class ProjectsConfigOptionPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    protected static final Class<?> PKG = ProjectsConfigOptionPlugin.class;
    private static final String WIDGET_ID_ENABLE_PROJECTS = "10000-enable-projects-plugin";
    private static final String WIDGET_ID_PROJECT_MANDATORY = "10010-project-mandatory";
    private static final String WIDGET_ID_ENVIRONMENT_MANDATORY = "10020-environment-mandatory";
    private static final String WIDGET_ID_DEFAULT_PROJECT = "10030-default-project";
    private static final String WIDGET_ID_DEFAULT_ENVIRONMENT = "10040-default-environment";
    private static final String WIDGET_ID_STANDARD_PARENT_PROJECT = "10050-standard-parent-project";
    private static final String WIDGET_ID_STANDARD_PROJECTS_FOLDER = "10060-standard-projects-folder";
    private static final String WIDGET_ID_RESTRICT_ENVIRONMENTS_TO_ACTIVE_PROJECT = "10070-restrict-environments-to-active-project";
    private static final String WIDGET_ID_CLEAR_DB_CACHE = "10080-clear-db-cache";
    private static final String WIDGET_ID_DEFAULT_PROJECT_CONFIG_FILENAME = "10070-default-project-config-filename";
    private static final String WIDGET_ID_SORT_BY_NAME_LAST_USED_PROJECTS = "10080-sort-by-name-last-used-project";
    @GuiWidgetElement(id="10000-enable-projects-plugin", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, label="i18n::ProjectConfig.EnableProjectPlugin.Message")
    @CommandLine.Option(names={"-pn", "--projects-enabled"}, description={"Enable or disable the projects plugin"})
    private Boolean projectsEnabled;
    @GuiWidgetElement(id="10010-project-mandatory", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, label="i18n::ProjectConfig.ProjectMandatory.Message")
    @CommandLine.Option(names={"-py", "--project-mandatory"}, description={"Make it mandatory to reference a project"})
    private Boolean projectMandatory;
    @GuiWidgetElement(id="10020-environment-mandatory", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, label="i18n::ProjectConfig.EnvironmentMandatory.Message")
    @CommandLine.Option(names={"-ey", "--environment-mandatory"}, description={"Make it mandatory to reference an environment"})
    private Boolean environmentMandatory;
    @GuiWidgetElement(id="10030-default-project", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.COMBO, comboValuesMethod="getProjectsList", variables=true, label="i18n::ProjectConfig.DefaultProject.Message")
    @CommandLine.Option(names={"-dp", "--default-project"}, description={"The default project to use when none is specified"})
    private String defaultProject;
    @GuiWidgetElement(id="10040-default-environment", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::ProjectConfig.DefaultEnvironment.Message")
    @CommandLine.Option(names={"-de", "--default-environment"}, description={"The name of the default environment to use when none is specified"})
    private String defaultEnvironment;
    @GuiWidgetElement(id="10050-standard-parent-project", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.COMBO, comboValuesMethod="getProjectsList", variables=true, label="i18n::ProjectConfig.ParentProject.Message")
    @CommandLine.Option(names={"-sp", "--standard-parent-project"}, description={"The name of the standard project to use as a parent when creating new projects"})
    private String standardParentProject;
    @GuiWidgetElement(id="10060-standard-projects-folder", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.FOLDER, variables=true, label="i18n::ProjectConfig.StdProjectFolder.Message")
    @CommandLine.Option(names={"-sj", "--standard-projects-folder"}, description={"The standard projects folder for new projects"})
    private String standardProjectsFolder;
    @GuiWidgetElement(id="10070-default-project-config-filename", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::ProjectConfig.StdProjectFilename.Message")
    @CommandLine.Option(names={"-dc", "--default-projects-folder"}, description={"The project configuration filename for new projects"})
    private String defaultProjectConfigFile;
    @GuiWidgetElement(id="10070-restrict-environments-to-active-project", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, variables=false, label="i18n::ProjectConfig.RestrictEnvsToActiveProject.Message")
    @CommandLine.Option(names={"-eap", "--environments-for-active-project"}, description={"Restrict environment list to active project"})
    private Boolean environmentsForActiveProject;
    @GuiWidgetElement(id="10080-clear-db-cache", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, variables=false, label="i18n::ProjectConfig.ClearDbCache.Message")
    @CommandLine.Option(names={"-cdb", "--clear-db-when-env-switching"}, description={"Clear database cache when switching project/environment"})
    private Boolean clearingDbCacheWhenSwitching;
    @GuiWidgetElement(id="10080-sort-by-name-last-used-project", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, variables=false, label="i18n::ProjectConfig.SortByNameLastUsedProjects.Message")
    private Boolean sortByNameLastUsedProjects;

    public static ProjectsConfigOptionPlugin getInstance() {
        ProjectsConfigOptionPlugin instance = new ProjectsConfigOptionPlugin();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        instance.projectsEnabled = config.isEnabled();
        instance.defaultProject = config.getDefaultProject();
        instance.defaultEnvironment = config.getDefaultEnvironment();
        instance.projectMandatory = config.isProjectMandatory();
        instance.environmentMandatory = config.isEnvironmentMandatory();
        instance.standardParentProject = config.getStandardParentProject();
        instance.standardProjectsFolder = config.getStandardProjectsFolder();
        instance.defaultProjectConfigFile = config.getDefaultProjectConfigFile();
        instance.environmentsForActiveProject = config.isEnvironmentsForActiveProject();
        instance.sortByNameLastUsedProjects = config.isSortByNameLastUsedProjects();
        instance.clearingDbCacheWhenSwitching = config.isClearingDbCacheWhenSwitching();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.projectsEnabled != null) {
                config.setEnabled(this.projectsEnabled);
                if (this.projectsEnabled.booleanValue()) {
                    log.logBasic("Enabled the projects system");
                } else {
                    log.logBasic("Disabled the projects system");
                }
                changed = true;
            }
            if (this.projectMandatory != null) {
                config.setProjectMandatory(this.projectMandatory);
                if (this.projectMandatory.booleanValue()) {
                    log.logBasic("Using a project is set to be mandatory");
                } else {
                    log.logBasic("Using a project is set to be optional");
                }
                changed = true;
            }
            if (this.environmentMandatory != null) {
                config.setEnvironmentMandatory(this.environmentMandatory);
                if (this.environmentMandatory.booleanValue()) {
                    log.logBasic("Using an environment is set to be mandatory");
                } else {
                    log.logBasic("Using an environment is set to be optional");
                }
                changed = true;
            }
            if (this.defaultProject != null) {
                config.setDefaultProject(this.defaultProject);
                log.logBasic("The default project is set to '" + this.defaultProject + "'");
                changed = true;
            }
            if (this.defaultEnvironment != null) {
                config.setDefaultEnvironment(this.defaultEnvironment);
                log.logBasic("The default environment is set to '" + this.defaultEnvironment + "'");
                changed = true;
            }
            if (this.standardParentProject != null) {
                config.setStandardParentProject(this.standardParentProject);
                log.logBasic("The standard project to inherit from when creating a project is set to '" + this.standardParentProject + "'");
                changed = true;
            }
            if (this.standardProjectsFolder != null) {
                config.setStandardProjectsFolder(this.standardProjectsFolder);
                log.logBasic("The standard projects folder to browse to in the GUI is set to '" + this.standardProjectsFolder + "'");
                changed = true;
            }
            if (this.defaultProjectConfigFile != null) {
                config.setDefaultProjectConfigFile(this.defaultProjectConfigFile);
                log.logBasic("The default project configuration filename is set to '" + this.defaultProjectConfigFile + "'");
                changed = true;
            }
            if (this.environmentsForActiveProject != null) {
                config.setEnvironmentsForActiveProject(this.environmentsForActiveProject);
                if (this.environmentsForActiveProject.booleanValue()) {
                    log.logBasic("Only listing environments for the active project");
                } else {
                    log.logBasic("Listing all environments, regardless of the active project");
                }
                changed = true;
            }
            if (this.clearingDbCacheWhenSwitching != null) {
                config.setClearingDbCacheWhenSwitching(this.clearingDbCacheWhenSwitching);
                if (this.clearingDbCacheWhenSwitching.booleanValue()) {
                    log.logBasic("Clearing database cache when switching project or environment.");
                } else {
                    log.logBasic("Keeping the database cache when switching between projects or environments.");
                }
                changed = true;
            }
            if (changed) {
                ProjectsConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling projects plugin configuration options", (Throwable)e);
        }
    }

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-enable-projects-plugin": {
                    this.projectsEnabled = ((Button)control).getSelection();
                    ProjectsConfigSingleton.getConfig().setEnabled(this.projectsEnabled);
                    break;
                }
                case "10010-project-mandatory": {
                    this.projectMandatory = ((Button)control).getSelection();
                    ProjectsConfigSingleton.getConfig().setProjectMandatory(this.projectMandatory);
                    break;
                }
                case "10020-environment-mandatory": {
                    this.environmentMandatory = ((Button)control).getSelection();
                    ProjectsConfigSingleton.getConfig().setEnvironmentMandatory(this.environmentMandatory);
                    break;
                }
                case "10030-default-project": {
                    String defProject = ((ComboVar)control).getText();
                    if (StringUtils.isEmpty((String)defProject)) break;
                    boolean defParentPrjExists = ProjectsUtil.projectExists(defProject);
                    if (!defParentPrjExists) {
                        MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 33);
                        box.setText(BaseMessages.getString(PKG, (String)"ProjectConfig.ProjectNotExists.Error.Header", (String[])new String[0]));
                        box.setMessage(BaseMessages.getString(PKG, (String)"ProjectConfig.ProjectNotExists.DefaultProject.Error.Message", (String[])new String[]{defProject}));
                        box.open();
                        break;
                    }
                    this.defaultProject = defProject;
                    ProjectsConfigSingleton.getConfig().setDefaultProject(this.defaultProject);
                    break;
                }
                case "10040-default-environment": {
                    this.defaultEnvironment = ((TextVar)control).getText();
                    ProjectsConfigSingleton.getConfig().setDefaultEnvironment(this.defaultEnvironment);
                    break;
                }
                case "10050-standard-parent-project": {
                    String stdParentProject = ((ComboVar)control).getText();
                    if (StringUtils.isEmpty((String)stdParentProject)) break;
                    boolean stdParentPrjExists = ProjectsUtil.projectExists(stdParentProject);
                    if (!stdParentPrjExists) {
                        MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 33);
                        box.setText(BaseMessages.getString(PKG, (String)"ProjectConfig.ProjectNotExists.Error.Header", (String[])new String[0]));
                        box.setMessage(BaseMessages.getString(PKG, (String)"ProjectConfig.ProjectNotExists.StandardProject.Error.Message", (String[])new String[]{stdParentProject}));
                        box.open();
                        break;
                    }
                    this.standardParentProject = stdParentProject;
                    ProjectsConfigSingleton.getConfig().setStandardParentProject(this.standardParentProject);
                    break;
                }
                case "10060-standard-projects-folder": {
                    this.standardProjectsFolder = ((TextVar)control).getText();
                    ProjectsConfigSingleton.getConfig().setStandardProjectsFolder(this.standardProjectsFolder);
                    break;
                }
                case "10070-default-project-config-filename": {
                    this.defaultProjectConfigFile = ((TextVar)control).getText();
                    ProjectsConfigSingleton.getConfig().setDefaultProjectConfigFile(this.defaultProjectConfigFile);
                    break;
                }
                case "10070-restrict-environments-to-active-project": {
                    this.environmentsForActiveProject = ((Button)control).getSelection();
                    ProjectsConfigSingleton.getConfig().setEnvironmentsForActiveProject(this.environmentsForActiveProject);
                    break;
                }
                case "10080-sort-by-name-last-used-project": {
                    this.sortByNameLastUsedProjects = ((Button)control).getSelection();
                    ProjectsConfigSingleton.getConfig().setSortByNameLastUsedProjects(this.sortByNameLastUsedProjects);
                    break;
                }
                case "10080-clear-db-cache": {
                    this.clearingDbCacheWhenSwitching = ((Button)control).getSelection();
                    ProjectsConfigSingleton.getConfig().setClearingDbCacheWhenSwitching(this.clearingDbCacheWhenSwitching);
                    break;
                }
            }
        }
        try {
            ProjectsConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ProjectConfig.SavingOption.ErrorDialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectConfig.SavingOption.ErrorDialog.Message", (String[])new String[0]), e);
        }
    }

    public List<String> getProjectsList(ILogChannel log, IHopMetadataProvider metadataProvider) {
        ProjectsConfig prjsConfig = ProjectsConfigSingleton.getConfig();
        List<String> prjs = prjsConfig.listProjectConfigNames();
        ArrayList<String> prjsList = new ArrayList<String>();
        prjsList.add("");
        prjsList.addAll(prjs);
        return prjsList;
    }

    @Generated
    public Boolean getProjectsEnabled() {
        return this.projectsEnabled;
    }

    @Generated
    public Boolean getProjectMandatory() {
        return this.projectMandatory;
    }

    @Generated
    public Boolean getEnvironmentMandatory() {
        return this.environmentMandatory;
    }

    @Generated
    public String getDefaultProject() {
        return this.defaultProject;
    }

    @Generated
    public String getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    @Generated
    public String getStandardParentProject() {
        return this.standardParentProject;
    }

    @Generated
    public String getStandardProjectsFolder() {
        return this.standardProjectsFolder;
    }

    @Generated
    public String getDefaultProjectConfigFile() {
        return this.defaultProjectConfigFile;
    }

    @Generated
    public Boolean getEnvironmentsForActiveProject() {
        return this.environmentsForActiveProject;
    }

    @Generated
    public Boolean getClearingDbCacheWhenSwitching() {
        return this.clearingDbCacheWhenSwitching;
    }

    @Generated
    public void setProjectsEnabled(Boolean projectsEnabled) {
        this.projectsEnabled = projectsEnabled;
    }

    @Generated
    public void setProjectMandatory(Boolean projectMandatory) {
        this.projectMandatory = projectMandatory;
    }

    @Generated
    public void setEnvironmentMandatory(Boolean environmentMandatory) {
        this.environmentMandatory = environmentMandatory;
    }

    @Generated
    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
    }

    @Generated
    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    @Generated
    public void setStandardParentProject(String standardParentProject) {
        this.standardParentProject = standardParentProject;
    }

    @Generated
    public void setStandardProjectsFolder(String standardProjectsFolder) {
        this.standardProjectsFolder = standardProjectsFolder;
    }

    @Generated
    public void setDefaultProjectConfigFile(String defaultProjectConfigFile) {
        this.defaultProjectConfigFile = defaultProjectConfigFile;
    }

    @Generated
    public void setEnvironmentsForActiveProject(Boolean environmentsForActiveProject) {
        this.environmentsForActiveProject = environmentsForActiveProject;
    }

    @Generated
    public void setClearingDbCacheWhenSwitching(Boolean clearingDbCacheWhenSwitching) {
        this.clearingDbCacheWhenSwitching = clearingDbCacheWhenSwitching;
    }

    @Generated
    public Boolean getSortByNameLastUsedProjects() {
        return this.sortByNameLastUsedProjects;
    }

    @Generated
    public void setSortByNameLastUsedProjects(Boolean sortByNameLastUsedProjects) {
        this.sortByNameLastUsedProjects = sortByNameLastUsedProjects;
    }
}

