/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class PartitionStartRecord
implements ChangeStreamRecord {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1446342293580399634L;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp;
    private @UnknownKeyFor @NonNull @Initialized String recordSequence;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> partitionTokens;
    @org.apache.avro.reflect.Nullable
    private @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata;

    private PartitionStartRecord() {
    }

    public PartitionStartRecord(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized String recordSequence, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> partitionTokens, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata) {
        this.startTimestamp = startTimestamp;
        this.recordSequence = recordSequence;
        this.partitionTokens = partitionTokens;
        this.metadata = metadata;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordTimestamp() {
        return this.getStartTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRecordSequence() {
        return this.recordSequence;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getPartitionTokens() {
        return this.partitionTokens;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionStartRecord)) {
            return false;
        }
        PartitionStartRecord that = (PartitionStartRecord)o;
        return Objects.equals(this.startTimestamp, that.startTimestamp) && Objects.equals(this.recordSequence, that.recordSequence) && Objects.equals(this.partitionTokens, that.partitionTokens);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.startTimestamp, this.recordSequence, this.partitionTokens);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "PartitionStartRecord{startTimestamp=" + this.startTimestamp + ", recordSequence='" + this.recordSequence + '\'' + ", partitionTokens=" + this.partitionTokens + ", metadata=" + this.metadata + '}';
    }
}

