/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class PartitionEndRecord
implements ChangeStreamRecord {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 5406538761724655621L;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp;
    private @UnknownKeyFor @NonNull @Initialized String recordSequence;
    @org.apache.avro.reflect.Nullable
    private @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata;

    private PartitionEndRecord() {
    }

    public PartitionEndRecord(@UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp, @UnknownKeyFor @NonNull @Initialized String recordSequence, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata) {
        this.endTimestamp = endTimestamp;
        this.recordSequence = recordSequence;
        this.metadata = metadata;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordTimestamp() {
        return this.getEndTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getEndTimestamp() {
        return this.endTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRecordSequence() {
        return this.recordSequence;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionEndRecord)) {
            return false;
        }
        PartitionEndRecord that = (PartitionEndRecord)o;
        return Objects.equals(this.endTimestamp, that.endTimestamp) && Objects.equals(this.recordSequence, that.recordSequence);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.endTimestamp, this.recordSequence);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "PartitionEndRecord{endTimestamp=" + this.endTimestamp + ", recordSequence='" + this.recordSequence + '\'' + ", metadata=" + this.metadata + '}';
    }
}

