/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.Mutation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerWriteSchemaTransformProvider_SpannerWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class SpannerWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<SpannerWriteSchemaTransformConfiguration> {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:spanner_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized String description() {
        return "Performs a bulk write to a Google Cloud Spanner table.\n\nExample configuration for performing a write to a single table: ::\n\n    - type: ReadFromSpanner\n      config:\n        project_id: 'my-project-id'\n        instance_id: 'my-instance-id'\n        database_id: 'my-database'\n        table: 'my-table'\n\nNote: See <a href=\"https://beam.apache.org/releases/javadoc/current/org/apache/beam/sdk/io/gcp/spanner/SpannerIO.html\">SpannerIO</a> for more advanced information.";
    }

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration> configurationClass() {
        return SpannerWriteSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration configuration) {
        return new SpannerSchemaTransformWrite(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Arrays.asList("post-write", "errors");
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class SpannerWriteSchemaTransformConfiguration
    implements Serializable {
        @SchemaFieldDescription(value="Specifies the Cloud Spanner instance.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getInstanceId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner database.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getDatabaseId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner table.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getTableId();

        @SchemaFieldDescription(value="Specifies the GCP project.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getProjectId();

        @SchemaFieldDescription(value="Whether and how to handle write errors.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized ErrorHandling getErrorHandling();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_SpannerWriteSchemaTransformProvider_SpannerWriteSchemaTransformConfiguration.Builder();
        }

        public void validate() {
            String invalidConfigMessage = "Invalid Spanner Write configuration: ";
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getInstanceId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Instance ID for a Spanner Write must be specified."));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getDatabaseId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Database ID for a Spanner Write must be specified."));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTableId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Table ID for a Spanner Write must be specified."));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabaseId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

            public abstract @UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration build();
        }
    }

    static class SpannerSchemaTransformWrite
    extends SchemaTransform
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration configuration;

        SpannerSchemaTransformWrite(@UnknownKeyFor @NonNull @Initialized SpannerWriteSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@NonNull @UnknownKeyFor @Initialized PCollectionRowTuple input) {
            boolean handleErrors = ErrorHandling.hasOutput((ErrorHandling)this.configuration.getErrorHandling());
            SpannerWriteResult result = (SpannerWriteResult)((PCollection)input.get("input").apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Mutation.class)).via((SerializableFunction & Serializable)row -> MutationUtils.createMutationFromBeamRows(Mutation.newInsertOrUpdateBuilder((String)this.configuration.getTableId()), Objects.requireNonNull(row))))).apply((PTransform)SpannerIO.write().withProjectId(this.configuration.getProjectId()).withDatabaseId(this.configuration.getDatabaseId()).withInstanceId(this.configuration.getInstanceId()).withFailureMode(handleErrors ? SpannerIO.FailureMode.REPORT_FAILURES : SpannerIO.FailureMode.FAIL_FAST));
            PCollection postWrite = ((PCollection)result.getFailedMutations().apply("post-write", (PTransform)ParDo.of(new NoOutputDoFn()))).setRowSchema(Schema.of((Schema.Field[])new Schema.Field[0]));
            if (!handleErrors) {
                return PCollectionRowTuple.of((String)"post-write", (PCollection)postWrite);
            }
            Schema inputSchema = input.get("input").getSchema();
            Schema failureSchema = ErrorHandling.errorSchema((Schema)inputSchema);
            PCollection failures = ((PCollection)((PCollection)result.getFailedMutations().apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)mtg -> StreamSupport.stream(Objects.requireNonNull(mtg).spliterator(), false).map(mutation -> Row.withSchema((Schema)failureSchema).withFieldValue("error_message", (Object)String.format("%s operation failed at instance: %s, database: %s, table: %s", mutation.getOperation(), this.configuration.getInstanceId(), this.configuration.getDatabaseId(), mutation.getTable())).withFieldValue("failed_row", (Object)MutationUtils.createRowFromMutation(inputSchema, mutation)).build()).collect(Collectors.toList())))).setRowSchema(failureSchema).apply("error-count", (PTransform)ParDo.of((DoFn)new ElementCounterFn("Spanner-write-error-counter")))).setRowSchema(failureSchema);
            return PCollectionRowTuple.of((String)"post-write", (PCollection)postWrite).and(this.configuration.getErrorHandling().getOutput(), failures);
        }

        private static class NoOutputDoFn<@UnknownKeyFor T>
        extends DoFn<T, Row> {
            private NoOutputDoFn() {
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            }
        }

        private static class ElementCounterFn
        extends DoFn<Row, Row> {
            private @UnknownKeyFor @NonNull @Initialized Counter spannerGenericElementCounter;
            private @UnknownKeyFor @NonNull @Initialized Long elementsInBundle = 0L;

            ElementCounterFn(@UnknownKeyFor @NonNull @Initialized String name) {
                this.spannerGenericElementCounter = Metrics.counter(SpannerSchemaTransformWrite.class, (String)name);
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                this.elementsInBundle = this.elementsInBundle + 1L;
                c.output((Object)((Row)c.element()));
            }

            @DoFn.FinishBundle
            public void finish(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
                this.spannerGenericElementCounter.inc(this.elementsInBundle.longValue());
                this.elementsInBundle = 0L;
            }
        }
    }
}

