/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.metrics.MetricsLogger;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfo;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfoCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.SinkMetrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

class BatchedStreamingWrite<@UnknownKeyFor ErrorT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<String, TableRowInfo<ElementT>>>, PCollectionTuple> {
    private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @Nullable @Initialized Void> mainOutputTag = new TupleTag("mainOutput");
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> SUCCESSFUL_ROWS_TAG = new TupleTag("successfulRows");
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<ErrorT> failedOutputTag;
    private final @UnknownKeyFor @NonNull @Initialized AtomicCoder<ErrorT> failedOutputCoder;
    private final @UnknownKeyFor @NonNull @Initialized ErrorContainer<ErrorT> errorContainer;
    private final @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds;
    private final @UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful;
    @javax.annotation.Nullable
    private final @UnknownKeyFor @Nullable @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow;
    @javax.annotation.Nullable
    private final @UnknownKeyFor @Nullable @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowedMetricUrns;
    private @UnknownKeyFor @NonNull @Initialized Counter byteCounter = SinkMetrics.bytesWritten();
    private final @UnknownKeyFor @NonNull @Initialized boolean batchViaStateful;
    private static final @UnknownKeyFor @NonNull @Initialized Duration BATCH_MAX_BUFFERING_DURATION = Duration.millis((long)200L);

    public BatchedStreamingWrite(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy, @UnknownKeyFor @NonNull @Initialized TupleTag<ErrorT> failedOutputTag, @UnknownKeyFor @NonNull @Initialized AtomicCoder<ErrorT> failedOutputCoder, @UnknownKeyFor @NonNull @Initialized ErrorContainer<ErrorT> errorContainer, @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds, @UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow) {
        this.bqServices = bqServices;
        this.retryPolicy = retryPolicy;
        this.failedOutputTag = failedOutputTag;
        this.failedOutputCoder = failedOutputCoder;
        this.errorContainer = errorContainer;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.propagateSuccessful = propagateSuccessful;
        this.toTableRow = toTableRow;
        this.toFailsafeTableRow = toFailsafeTableRow;
        this.allowedMetricUrns = BatchedStreamingWrite.getAllowedMetricUrns();
        this.batchViaStateful = false;
    }

    private BatchedStreamingWrite(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy, @UnknownKeyFor @NonNull @Initialized TupleTag<ErrorT> failedOutputTag, @UnknownKeyFor @NonNull @Initialized AtomicCoder<ErrorT> failedOutputCoder, @UnknownKeyFor @NonNull @Initialized ErrorContainer<ErrorT> errorContainer, @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds, @UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow, @UnknownKeyFor @NonNull @Initialized boolean batchViaStateful) {
        this.bqServices = bqServices;
        this.retryPolicy = retryPolicy;
        this.failedOutputTag = failedOutputTag;
        this.failedOutputCoder = failedOutputCoder;
        this.errorContainer = errorContainer;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.propagateSuccessful = propagateSuccessful;
        this.toTableRow = toTableRow;
        this.toFailsafeTableRow = toFailsafeTableRow;
        this.allowedMetricUrns = BatchedStreamingWrite.getAllowedMetricUrns();
        this.batchViaStateful = batchViaStateful;
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getAllowedMetricUrns() {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        setBuilder.add((Object)MonitoringInfoConstants.Urns.API_REQUEST_COUNT);
        setBuilder.add((Object)MonitoringInfoConstants.Urns.API_REQUEST_LATENCIES);
        return setBuilder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized BatchedStreamingWrite<ErrorT, ElementT> viaDoFnFinalization() {
        return new BatchedStreamingWrite<ErrorT, ElementT>(this.bqServices, this.retryPolicy, this.failedOutputTag, this.failedOutputCoder, this.errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.propagateSuccessful, this.toTableRow, this.toFailsafeTableRow, false);
    }

    public @UnknownKeyFor @NonNull @Initialized BatchedStreamingWrite<ErrorT, ElementT> viaStateful() {
        return new BatchedStreamingWrite<ErrorT, ElementT>(this.bqServices, this.retryPolicy, this.failedOutputTag, this.failedOutputCoder, this.errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.propagateSuccessful, this.toTableRow, this.toFailsafeTableRow, true);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>>> input) {
        return this.batchViaStateful ? (PCollectionTuple)input.apply((PTransform)new ViaStateful()) : (PCollectionTuple)input.apply((PTransform)new ViaBundleFinalization());
    }

    private void flushRows(@UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService, @UnknownKeyFor @NonNull @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow>> tableRows, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> uniqueIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<ErrorT>> failedInserts, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow>> successfulInserts) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        if (!tableRows.isEmpty()) {
            try {
                long totalBytes = datasetService.insertAll(tableReference, tableRows, uniqueIds, this.retryPolicy, failedInserts, this.errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, successfulInserts);
                this.byteCounter.inc(totalBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void reportStreamingApiLogging(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) {
        MetricsContainer processWideContainer = MetricsEnvironment.getProcessWideContainer();
        if (processWideContainer instanceof MetricsLogger) {
            MetricsLogger processWideMetricsLogger = (MetricsLogger)processWideContainer;
            processWideMetricsLogger.tryLoggingMetrics("API call Metrics: \n", this.allowedMetricUrns, (long)options.getBqStreamingApiLoggingFrequencySec().intValue() * 1000L);
        }
    }

    private class ViaStateful
    extends PTransform<PCollection<KV<String, TableRowInfo<ElementT>>>, PCollectionTuple> {
        private ViaStateful() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>>> input) {
            BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
            Duration maxBufferingDuration = options.getMaxBufferingDurationMilliSec() > 0 ? Duration.millis((long)options.getMaxBufferingDurationMilliSec().intValue()) : BATCH_MAX_BUFFERING_DURATION;
            KvCoder inputCoder = (KvCoder)input.getCoder();
            TableRowInfoCoder valueCoder = (TableRowInfoCoder)((Object)inputCoder.getCoderArguments().get(1));
            PCollectionTuple result = (PCollectionTuple)((PCollection)((PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply((PTransform)GroupIntoBatches.ofSize((long)options.getMaxStreamingRowsToBatch()).withMaxBufferingDuration(maxBufferingDuration).withShardedKey())).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<ShardedKey<String>, Iterable<TableRowInfo<ElementT>>>, KV<String, TableRowInfo<ElementT>>>(){

                @DoFn.ProcessElement
                public void apply(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>>> element) {
                    String key = (String)((ShardedKey)element.getKey()).getKey();
                    for (TableRowInfo value : (Iterable)element.getValue()) {
                        context.output((Object)KV.of((Object)key, (Object)value));
                    }
                }
            }))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)valueCoder)).apply((PTransform)ParDo.of((DoFn)new BatchAndInsertElements(BatchedStreamingWrite.this.propagateSuccessful)).withOutputTags(mainOutputTag, BatchedStreamingWrite.this.propagateSuccessful ? TupleTagList.of((TupleTag)BatchedStreamingWrite.this.failedOutputTag).and(SUCCESSFUL_ROWS_TAG) : TupleTagList.of((TupleTag)BatchedStreamingWrite.this.failedOutputTag)));
            result.get(BatchedStreamingWrite.this.failedOutputTag).setCoder((Coder)BatchedStreamingWrite.this.failedOutputCoder);
            if (BatchedStreamingWrite.this.propagateSuccessful) {
                result.get(SUCCESSFUL_ROWS_TAG).setCoder((Coder)TableRowJsonCoder.of());
            }
            return result;
        }
    }

    @VisibleForTesting
    private class BatchAndInsertElements
    extends DoFn<KV<String, TableRowInfo<ElementT>>, Void> {
        @javax.annotation.Nullable
        private transient @UnknownKeyFor @Nullable @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow>>> tableRows = null;
        @javax.annotation.Nullable
        private transient @UnknownKeyFor @Nullable @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> uniqueIdsForTableRows = null;
        @javax.annotation.Nullable
        private transient @UnknownKeyFor @Nullable @Initialized BigQueryServices.DatasetService datasetService;
        private final @UnknownKeyFor @NonNull @Initialized boolean propagateSuccessfulInserts;

        BatchAndInsertElements(boolean propagateSuccessful) {
            this.propagateSuccessfulInserts = propagateSuccessful;
        }

        private @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService getDatasetService(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.datasetService == null) {
                this.datasetService = BatchedStreamingWrite.this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
            return this.datasetService;
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.tableRows = new HashMap<String, List<FailsafeValueInSingleWindow<TableRow, TableRow>>>();
            this.uniqueIdsForTableRows = new HashMap<String, List<String>>();
        }

        @DoFn.ProcessElement
        @RequiresNonNull(value={"tableRows", "uniqueIdsForTableRows", "toTableRow", "toFailsafeTableRow"})
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>> element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
            Map<String, List<FailsafeValueInSingleWindow<TableRow, TableRow>>> tableRows = this.tableRows;
            Map<String, List<String>> uniqueIdsForTableRows = this.uniqueIdsForTableRows;
            String tableSpec = (String)element.getKey();
            TableRow tableRow = (TableRow)BatchedStreamingWrite.this.toTableRow.apply(((TableRowInfo)element.getValue()).tableRow);
            TableRow failsafeTableRow = (TableRow)BatchedStreamingWrite.this.toFailsafeTableRow.apply(((TableRowInfo)element.getValue()).tableRow);
            tableRows.computeIfAbsent(tableSpec, k -> new ArrayList()).add(FailsafeValueInSingleWindow.of((Object)tableRow, (Instant)timestamp, (BoundedWindow)window, (PaneInfo)paneInfo, (Object)failsafeTableRow));
            uniqueIdsForTableRows.computeIfAbsent(tableSpec, k -> new ArrayList()).add(((TableRowInfo)element.getValue()).uniqueId);
        }

        @DoFn.FinishBundle
        @RequiresNonNull(value={"tableRows", "uniqueIdsForTableRows"})
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Map<String, List<FailsafeValueInSingleWindow<TableRow, TableRow>>> tableRows = this.tableRows;
            Map<String, List<String>> uniqueIdsForTableRows = this.uniqueIdsForTableRows;
            ArrayList failedInserts = Lists.newArrayList();
            ArrayList successfulInserts = Lists.newArrayList();
            BigQueryOptions options = (BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class);
            for (Map.Entry<String, List<FailsafeValueInSingleWindow<TableRow, TableRow>>> entry : tableRows.entrySet()) {
                TableReference tableReference = BigQueryHelpers.parseTableSpec(entry.getKey());
                BatchedStreamingWrite.this.flushRows(this.getDatasetService(options), tableReference, entry.getValue(), uniqueIdsForTableRows.get(entry.getKey()), failedInserts, successfulInserts);
            }
            tableRows.clear();
            uniqueIdsForTableRows.clear();
            for (ValueInSingleWindow row : failedInserts) {
                context.output(BatchedStreamingWrite.this.failedOutputTag, row.getValue(), row.getTimestamp(), row.getWindow());
            }
            if (this.propagateSuccessfulInserts) {
                for (ValueInSingleWindow row : successfulInserts) {
                    context.output(SUCCESSFUL_ROWS_TAG, (Object)((TableRow)row.getValue()), row.getTimestamp(), row.getWindow());
                }
            }
            BatchedStreamingWrite.this.reportStreamingApiLogging(options);
        }

        @DoFn.Teardown
        public void onTeardown() {
            try {
                if (this.datasetService != null) {
                    this.datasetService.close();
                    this.datasetService = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ViaBundleFinalization
    extends PTransform<PCollection<KV<String, TableRowInfo<ElementT>>>, PCollectionTuple> {
        private ViaBundleFinalization() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>>> input) {
            PCollectionTuple result = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new BatchAndInsertElements(BatchedStreamingWrite.this.propagateSuccessful)).withOutputTags(mainOutputTag, BatchedStreamingWrite.this.propagateSuccessful ? TupleTagList.of((TupleTag)BatchedStreamingWrite.this.failedOutputTag).and(SUCCESSFUL_ROWS_TAG) : TupleTagList.of((TupleTag)BatchedStreamingWrite.this.failedOutputTag)));
            result.get(BatchedStreamingWrite.this.failedOutputTag).setCoder((Coder)BatchedStreamingWrite.this.failedOutputCoder);
            if (BatchedStreamingWrite.this.propagateSuccessful) {
                result.get(SUCCESSFUL_ROWS_TAG).setCoder((Coder)TableRowJsonCoder.of());
            }
            return result;
        }
    }
}

