/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.DataTypeUtils;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.data_formats.internal.InetAddressConverter;
import com.clickhouse.client.internal.com.google.common.collect.ImmutableMap;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.Tuple;
import com.clickhouse.jdbc.types.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Function;

public class JdbcUtils {
    public static final Map<ClickHouseDataType, SQLType> CLICKHOUSE_TO_SQL_TYPE_MAP = JdbcUtils.generateTypeMap();
    public static final Map<String, SQLType> CLICKHOUSE_TYPE_NAME_TO_SQL_TYPE_MAP = Collections.unmodifiableMap(JdbcUtils.generateTypeMap().entrySet().stream().collect(HashMap::new, (map, entry) -> map.put(((ClickHouseDataType)entry.getKey()).name(), (SQLType)entry.getValue()), HashMap::putAll));
    public static final Map<SQLType, Class<?>> SQL_TYPE_TO_CLASS_MAP = JdbcUtils.generateClassMap();
    public static final Set<ClickHouseDataType> INVALID_TARGET_TYPES = EnumSet.of(ClickHouseDataType.Nested, new ClickHouseDataType[]{ClickHouseDataType.Enum8, ClickHouseDataType.Enum16, ClickHouseDataType.Enum, ClickHouseDataType.Tuple, ClickHouseDataType.Map, ClickHouseDataType.Nothing, ClickHouseDataType.Nullable, ClickHouseDataType.Variant});
    public static final Map<ClickHouseDataType, Class<?>> DATA_TYPE_CLASS_MAP = JdbcUtils.getDataTypeClassMap();
    public static final Map<SQLType, ClickHouseDataType> SQL_TO_CLICKHOUSE_TYPE_MAP = JdbcUtils.createSQLToClickHouseDataTypeMap();

    private static Map<ClickHouseDataType, SQLType> generateTypeMap() {
        TreeMap<ClickHouseDataType, JDBCType> map = new TreeMap<ClickHouseDataType, JDBCType>();
        map.put(ClickHouseDataType.Int8, JDBCType.TINYINT);
        map.put(ClickHouseDataType.Int16, JDBCType.SMALLINT);
        map.put(ClickHouseDataType.Int32, JDBCType.INTEGER);
        map.put(ClickHouseDataType.Int64, JDBCType.BIGINT);
        map.put(ClickHouseDataType.Int128, JDBCType.OTHER);
        map.put(ClickHouseDataType.Int256, JDBCType.OTHER);
        map.put(ClickHouseDataType.UInt8, JDBCType.SMALLINT);
        map.put(ClickHouseDataType.UInt16, JDBCType.INTEGER);
        map.put(ClickHouseDataType.UInt32, JDBCType.BIGINT);
        map.put(ClickHouseDataType.UInt64, JDBCType.OTHER);
        map.put(ClickHouseDataType.UInt128, JDBCType.OTHER);
        map.put(ClickHouseDataType.UInt256, JDBCType.OTHER);
        map.put(ClickHouseDataType.Float32, JDBCType.FLOAT);
        map.put(ClickHouseDataType.Float64, JDBCType.DOUBLE);
        map.put(ClickHouseDataType.Bool, JDBCType.BOOLEAN);
        map.put(ClickHouseDataType.Decimal, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal32, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal64, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal128, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.String, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.FixedString, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum8, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum16, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Date, JDBCType.DATE);
        map.put(ClickHouseDataType.Date32, JDBCType.DATE);
        map.put(ClickHouseDataType.DateTime, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.DateTime32, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.DateTime64, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.Time, JDBCType.TIME);
        map.put(ClickHouseDataType.Time64, JDBCType.TIME);
        map.put(ClickHouseDataType.Array, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Nested, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Map, JDBCType.JAVA_OBJECT);
        map.put(ClickHouseDataType.Point, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Ring, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Polygon, JDBCType.ARRAY);
        map.put(ClickHouseDataType.LineString, JDBCType.ARRAY);
        map.put(ClickHouseDataType.MultiPolygon, JDBCType.ARRAY);
        map.put(ClickHouseDataType.MultiLineString, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Tuple, JDBCType.OTHER);
        map.put(ClickHouseDataType.Nothing, JDBCType.OTHER);
        return ImmutableMap.copyOf(map);
    }

    private static Map<SQLType, Class<?>> generateClassMap() {
        HashMap<JDBCType, Class<SQLXML>> map = new HashMap<JDBCType, Class<SQLXML>>();
        map.put(JDBCType.CHAR, String.class);
        map.put(JDBCType.VARCHAR, String.class);
        map.put(JDBCType.LONGVARCHAR, String.class);
        map.put(JDBCType.NUMERIC, BigDecimal.class);
        map.put(JDBCType.DECIMAL, BigDecimal.class);
        map.put(JDBCType.BIT, Boolean.class);
        map.put(JDBCType.BOOLEAN, Boolean.class);
        map.put(JDBCType.TINYINT, Byte.class);
        map.put(JDBCType.SMALLINT, Short.class);
        map.put(JDBCType.INTEGER, Integer.class);
        map.put(JDBCType.BIGINT, Long.class);
        map.put(JDBCType.REAL, Float.class);
        map.put(JDBCType.FLOAT, Float.class);
        map.put(JDBCType.DOUBLE, Double.class);
        map.put(JDBCType.BINARY, byte[].class);
        map.put(JDBCType.VARBINARY, byte[].class);
        map.put(JDBCType.LONGVARBINARY, byte[].class);
        map.put(JDBCType.DATE, Date.class);
        map.put(JDBCType.TIME, Time.class);
        map.put(JDBCType.TIMESTAMP, Timestamp.class);
        map.put(JDBCType.TIME_WITH_TIMEZONE, Time.class);
        map.put(JDBCType.TIMESTAMP_WITH_TIMEZONE, Timestamp.class);
        map.put(JDBCType.CLOB, Clob.class);
        map.put(JDBCType.BLOB, Blob.class);
        map.put(JDBCType.ARRAY, java.sql.Array.class);
        map.put(JDBCType.STRUCT, Struct.class);
        map.put(JDBCType.REF, Ref.class);
        map.put(JDBCType.DATALINK, URL.class);
        map.put(JDBCType.ROWID, RowId.class);
        map.put(JDBCType.NCHAR, String.class);
        map.put(JDBCType.NVARCHAR, String.class);
        map.put(JDBCType.LONGNVARCHAR, String.class);
        map.put(JDBCType.NCLOB, NClob.class);
        map.put(JDBCType.SQLXML, SQLXML.class);
        return ImmutableMap.copyOf(map);
    }

    private static Map<ClickHouseDataType, Class<?>> getDataTypeClassMap() {
        HashMap map = new HashMap();
        block11: for (Map.Entry<ClickHouseDataType, SQLType> e : CLICKHOUSE_TO_SQL_TYPE_MAP.entrySet()) {
            if (e.getValue().equals(JDBCType.OTHER)) {
                switch (e.getKey()) {
                    case UInt64: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case UInt128: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case UInt256: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case Int128: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case Int256: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case Point: {
                        map.put(e.getKey(), double[].class);
                        continue block11;
                    }
                    case LineString: 
                    case Ring: {
                        map.put(e.getKey(), double[][].class);
                        continue block11;
                    }
                    case Polygon: 
                    case MultiLineString: {
                        map.put(e.getKey(), double[][][].class);
                        continue block11;
                    }
                    case MultiPolygon: {
                        map.put(e.getKey(), double[][][][].class);
                        continue block11;
                    }
                }
                map.put(e.getKey(), Object.class);
                continue;
            }
            if (e.getValue().equals(JDBCType.STRUCT)) {
                map.put(e.getKey(), Object.class);
                continue;
            }
            map.put(e.getKey(), SQL_TYPE_TO_CLASS_MAP.get(e.getValue()));
        }
        return map;
    }

    private static Map<SQLType, ClickHouseDataType> createSQLToClickHouseDataTypeMap() {
        HashMap<JDBCType, ClickHouseDataType> map = new HashMap<JDBCType, ClickHouseDataType>();
        map.put(JDBCType.TINYINT, ClickHouseDataType.Int8);
        map.put(JDBCType.SMALLINT, ClickHouseDataType.Int16);
        map.put(JDBCType.INTEGER, ClickHouseDataType.Int32);
        map.put(JDBCType.BIGINT, ClickHouseDataType.Int64);
        map.put(JDBCType.FLOAT, ClickHouseDataType.Float32);
        map.put(JDBCType.REAL, ClickHouseDataType.Float32);
        map.put(JDBCType.DOUBLE, ClickHouseDataType.Float64);
        map.put(JDBCType.BOOLEAN, ClickHouseDataType.Bool);
        map.put(JDBCType.DATE, ClickHouseDataType.Date32);
        map.put(JDBCType.TIME, ClickHouseDataType.Time);
        map.put(JDBCType.TIMESTAMP, ClickHouseDataType.DateTime64);
        map.put(JDBCType.TIMESTAMP_WITH_TIMEZONE, ClickHouseDataType.DateTime64);
        map.put(JDBCType.BINARY, ClickHouseDataType.String);
        map.put(JDBCType.VARBINARY, ClickHouseDataType.String);
        map.put(JDBCType.LONGVARBINARY, ClickHouseDataType.String);
        map.put(JDBCType.CHAR, ClickHouseDataType.String);
        map.put(JDBCType.NCHAR, ClickHouseDataType.String);
        map.put(JDBCType.VARCHAR, ClickHouseDataType.String);
        map.put(JDBCType.LONGNVARCHAR, ClickHouseDataType.String);
        map.put(JDBCType.NVARCHAR, ClickHouseDataType.String);
        map.put(JDBCType.DECIMAL, ClickHouseDataType.Decimal32);
        map.put(JDBCType.ARRAY, ClickHouseDataType.Array);
        return Collections.unmodifiableMap(map);
    }

    public static SQLType convertToSqlType(ClickHouseDataType clickhouseType) {
        if (clickhouseType == null) {
            return JDBCType.OTHER;
        }
        return CLICKHOUSE_TO_SQL_TYPE_MAP.getOrDefault(clickhouseType, JDBCType.OTHER);
    }

    public static Class<?> convertToJavaClass(ClickHouseDataType clickhouseType) {
        return DATA_TYPE_CLASS_MAP.get(clickhouseType);
    }

    private static Class<?> unwrapPrimitiveType(Class<?> type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        return type;
    }

    public static Object convert(Object value, Class<?> type) throws SQLException {
        return JdbcUtils.convert(value, type, null);
    }

    public static Object convert(Object value, Class<?> type, ClickHouseColumn column) throws SQLException {
        if (value == null || type == null) {
            return value;
        }
        if ((type = JdbcUtils.unwrapPrimitiveType(type)).isInstance(value)) {
            return value;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            if (type != java.sql.Array.class) {
                return JdbcUtils.convertList(listValue, type, column.getArrayNestedLevel());
            }
            if (column != null && column.getArrayBaseColumn() != null) {
                ClickHouseDataType baseType = column.getArrayBaseColumn().getDataType();
                Object[] convertedValues = JdbcUtils.convertList(listValue, JdbcUtils.convertToJavaClass(baseType), column.getArrayNestedLevel());
                return new Array(column, convertedValues);
            }
            return new Array(column, listValue.toArray());
        }
        if (value.getClass().isArray()) {
            if (type == java.sql.Array.class) {
                return new Array(column, JdbcUtils.arrayToObjectArray(value));
            }
            if (type == Tuple.class) {
                return new Tuple(true, value);
            }
        }
        if (type == java.sql.Array.class && value instanceof BinaryStreamReader.ArrayValue) {
            BinaryStreamReader.ArrayValue arrayValue = (BinaryStreamReader.ArrayValue)value;
            if (column != null && column.getArrayBaseColumn() != null) {
                ClickHouseDataType baseType = column.getArrayBaseColumn().getDataType();
                Object[] convertedValues = JdbcUtils.convertArray(arrayValue.getArray(), JdbcUtils.convertToJavaClass(baseType), column.getArrayNestedLevel());
                return new Array(column, convertedValues);
            }
            return new Array(column, arrayValue.getArrayOfObjects());
        }
        return JdbcUtils.convertObject(value, type, column);
    }

    public static Object convertObject(Object value, Class<?> type, ClickHouseColumn column) throws SQLException {
        if (value == null || type == null) {
            return value;
        }
        try {
            if (type == String.class) {
                return value.toString();
            }
            if (type == Boolean.class) {
                String str = value.toString();
                return !"false".equalsIgnoreCase(str) && !"0".equalsIgnoreCase(str);
            }
            if (type == Byte.class) {
                return Byte.parseByte(value.toString());
            }
            if (type == Short.class) {
                return Short.parseShort(value.toString());
            }
            if (type == Integer.class) {
                return Integer.parseInt(value.toString());
            }
            if (type == Long.class) {
                return Long.parseLong(value.toString());
            }
            if (type == Float.class) {
                return Float.valueOf(Float.parseFloat(value.toString()));
            }
            if (type == Double.class) {
                return Double.parseDouble(value.toString());
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(value.toString());
            }
            if (value instanceof TemporalAccessor) {
                TemporalAccessor temporalValue = (TemporalAccessor)value;
                if (type == LocalDate.class) {
                    return LocalDate.from(temporalValue);
                }
                if (type == LocalDateTime.class) {
                    return LocalDateTime.from(temporalValue);
                }
                if (type == OffsetDateTime.class) {
                    return OffsetDateTime.from(temporalValue);
                }
                if (type == ZonedDateTime.class) {
                    return ZonedDateTime.from(temporalValue);
                }
                if (type == Instant.class) {
                    return Instant.from(temporalValue);
                }
                if (type == Date.class) {
                    return Date.valueOf(LocalDate.from(temporalValue));
                }
                if (type == Timestamp.class) {
                    return Timestamp.valueOf(LocalDateTime.from(temporalValue));
                }
                if (type == Time.class) {
                    return Time.valueOf(LocalTime.from(temporalValue));
                }
            } else {
                if (type == Time.class && value instanceof Integer) {
                    return new Time((long)((Integer)value).intValue() * 1000L);
                }
                if (type == Time.class && value instanceof Long) {
                    Instant instant = DataTypeUtils.instantFromTime64Integer(column.getScale(), (Long)value);
                    return new Time(instant.getEpochSecond() * 1000L + (long)(instant.getNano() / 1000000));
                }
                if (type == Inet4Address.class && value instanceof Inet6Address) {
                    return InetAddressConverter.convertToIpv4((InetAddress)value);
                }
                if (type == Inet6Address.class && value instanceof Inet4Address) {
                    return InetAddressConverter.convertToIpv6((InetAddress)value);
                }
            }
        }
        catch (Exception e) {
            throw new SQLException("Failed to convert from " + value.getClass().getName() + " to " + type.getName(), "22000", e);
        }
        throw new SQLException("Unsupported conversion from " + value.getClass().getName() + " to " + type.getName(), "22000");
    }

    public static <T> T[] convertList(List<?> values, Class<T> type, int dimensions) throws SQLException {
        if (values == null) {
            return null;
        }
        int[] arrayDimensions = new int[dimensions];
        arrayDimensions[0] = values.size();
        Object[] convertedValues = (Object[])java.lang.reflect.Array.newInstance(type, arrayDimensions);
        Stack<ArrayProcessingCursor> stack = new Stack<ArrayProcessingCursor>();
        stack.push(new ArrayProcessingCursor(convertedValues, values, values.size()));
        while (!stack.isEmpty()) {
            ArrayProcessingCursor cursor = (ArrayProcessingCursor)stack.pop();
            for (int i = 0; i < cursor.size; ++i) {
                Object value = cursor.getValue(i);
                if (value == null) continue;
                if (value instanceof List) {
                    List srcList = (List)value;
                    arrayDimensions = new int[Math.max(dimensions - stack.size() - 1, 1)];
                    arrayDimensions[0] = srcList.size();
                    Object[] targetArray = (Object[])java.lang.reflect.Array.newInstance(type, arrayDimensions);
                    stack.push(new ArrayProcessingCursor(targetArray, value, srcList.size()));
                    java.lang.reflect.Array.set(cursor.targetArray, i, targetArray);
                    continue;
                }
                java.lang.reflect.Array.set(cursor.targetArray, i, JdbcUtils.convert(value, type));
            }
        }
        return convertedValues;
    }

    public static <T> T[] convertArray(Object values, Class<T> type, int dimensions) throws SQLException {
        if (values == null) {
            return null;
        }
        int[] arrayDimensions = new int[dimensions];
        arrayDimensions[0] = java.lang.reflect.Array.getLength(values);
        Object[] convertedValues = (Object[])java.lang.reflect.Array.newInstance(type, arrayDimensions);
        Stack<ArrayProcessingCursor> stack = new Stack<ArrayProcessingCursor>();
        stack.push(new ArrayProcessingCursor(convertedValues, values, arrayDimensions[0]));
        while (!stack.isEmpty()) {
            ArrayProcessingCursor cursor = (ArrayProcessingCursor)stack.pop();
            for (int i = 0; i < cursor.size; ++i) {
                Object value = cursor.getValue(i);
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    arrayDimensions = new int[Math.max(dimensions - stack.size() - 1, 1)];
                    arrayDimensions[0] = java.lang.reflect.Array.getLength(value);
                    Object[] targetArray = (Object[])java.lang.reflect.Array.newInstance(type, arrayDimensions);
                    stack.push(new ArrayProcessingCursor(targetArray, value, arrayDimensions[0]));
                    java.lang.reflect.Array.set(cursor.targetArray, i, targetArray);
                    continue;
                }
                java.lang.reflect.Array.set(cursor.targetArray, i, JdbcUtils.convert(value, type));
            }
        }
        return convertedValues;
    }

    public static Object[] arrayToObjectArray(Object array) {
        if (array == null) {
            return null;
        }
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array: " + array.getClass().getName());
        }
        if (array instanceof byte[]) {
            byte[] src = (byte[])array;
            Object[] dst = new Byte[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = src[i];
            }
            return dst;
        }
        if (array instanceof short[]) {
            short[] src = (short[])array;
            Object[] dst = new Short[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = src[i];
            }
            return dst;
        }
        if (array instanceof int[]) {
            int[] src = (int[])array;
            Object[] dst = new Integer[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = src[i];
            }
            return dst;
        }
        if (array instanceof long[]) {
            long[] src = (long[])array;
            Object[] dst = new Long[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = src[i];
            }
            return dst;
        }
        if (array instanceof float[]) {
            float[] src = (float[])array;
            Object[] dst = new Float[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = Float.valueOf(src[i]);
            }
            return dst;
        }
        if (array instanceof double[]) {
            double[] src = (double[])array;
            Object[] dst = new Double[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = src[i];
            }
            return dst;
        }
        if (array instanceof char[]) {
            char[] src = (char[])array;
            Object[] dst = new Character[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = Character.valueOf(src[i]);
            }
            return dst;
        }
        if (array instanceof boolean[]) {
            boolean[] src = (boolean[])array;
            Object[] dst = new Boolean[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = src[i];
            }
            return dst;
        }
        throw new IllegalArgumentException("Cannot convert " + array.getClass().getName() + " to an Object[]");
    }

    private static final class ArrayProcessingCursor {
        private final Object targetArray;
        private final int size;
        private final Function<Integer, Object> valueGetter;

        public ArrayProcessingCursor(Object targetArray, Object srcArray, int size) {
            this.targetArray = targetArray;
            this.size = size;
            if (srcArray instanceof List) {
                List list = (List)srcArray;
                this.valueGetter = list::get;
            } else {
                this.valueGetter = i -> java.lang.reflect.Array.get(srcArray, i);
            }
        }

        public Object getValue(int i) {
            return this.valueGetter.apply(i);
        }
    }
}

