/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.http.protocol;

import com.clickhouse.client.internal.org.apache.hc.core5.annotation.Contract;
import com.clickhouse.client.internal.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.clickhouse.client.internal.org.apache.hc.core5.http.EntityDetails;
import com.clickhouse.client.internal.org.apache.hc.core5.http.Header;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpException;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpRequest;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpVersion;
import com.clickhouse.client.internal.org.apache.hc.core5.http.Method;
import com.clickhouse.client.internal.org.apache.hc.core5.http.ProtocolException;
import com.clickhouse.client.internal.org.apache.hc.core5.http.ProtocolVersion;
import com.clickhouse.client.internal.org.apache.hc.core5.http.message.MessageSupport;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.HttpContext;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestContent
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestContent();
    private final boolean overwrite;

    public RequestContent() {
        this(false);
    }

    public RequestContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.TRACE.isSame(method) && entity != null) {
            throw new ProtocolException("TRACE request may not enclose an entity");
        }
        if (this.overwrite) {
            request.removeHeaders("Transfer-Encoding");
            request.removeHeaders("Content-Length");
        } else {
            if (request.containsHeader("Transfer-Encoding")) {
                throw new ProtocolException("Transfer-encoding header already present");
            }
            if (request.containsHeader("Content-Length")) {
                throw new ProtocolException("Content-Length header already present");
            }
        }
        if (entity == null && this.isContentEnclosingMethod(method)) {
            request.addHeader("Content-Length", "0");
            return;
        }
        if (entity != null) {
            this.validateOptionsContentType(request);
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity.isChunked() || entity.getContentLength() < 0L) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + ver);
                }
                request.addHeader("Transfer-Encoding", "chunked");
                MessageSupport.addTrailerHeader(request, entity);
            } else {
                request.addHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
            MessageSupport.addContentTypeHeader(request, entity);
            MessageSupport.addContentEncodingHeader(request, entity);
        }
    }

    private boolean isContentEnclosingMethod(String method) {
        return Method.POST.isSame(method) || Method.PUT.isSame(method) || Method.PATCH.isSame(method);
    }

    public void validateOptionsContentType(HttpRequest request) throws ProtocolException {
        Header header;
        if (Method.OPTIONS.isSame(request.getMethod()) && (header = request.getFirstHeader("Content-Type")) == null) {
            throw new ProtocolException("OPTIONS request must have Content-Type header");
        }
    }
}

