/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceinput;

import lombok.Generated;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputMeta;

public class SalesforceInputField
implements Cloneable {
    private static final Class<?> PKG = SalesforceInputMeta.class;
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Both", (String[])new String[0])};
    public static final String CONST_FIELD = "field";
    public static final String CONST_SPACES = "        ";
    @HopMetadataProperty(key="name", injectionKey="NAME", injectionKeyDescription="SalesforceInputMeta.Injection.NAME")
    private String name;
    @HopMetadataProperty(key="field", injectionKey="FIELD", injectionKeyDescription="SalesforceInputMeta.Injection.FIELD")
    private String field;
    @HopMetadataProperty(key="type", injectionKey="TYPE", injectionKeyDescription="SalesforceInputMeta.Injection.TYPE")
    private String type;
    private int typeCode;
    @HopMetadataProperty(key="length", injectionKey="LENGTH", injectionKeyDescription="SalesforceInputMeta.Injection.LENGTH")
    private int length;
    @HopMetadataProperty(key="format", injectionKey="FORMAT", injectionKeyDescription="SalesforceInputMeta.Injection.FORMAT")
    private String format;
    @HopMetadataProperty(key="trimtype", injectionKey="TRIM_TYPE", injectionKeyDescription="SalesforceInputMeta.Injection.TRIM_TYPE")
    private int trimType;
    @HopMetadataProperty(key="precision", injectionKey="PRECISION", injectionKeyDescription="SalesforceInputMeta.Injection.PRECISION")
    private int precision;
    @HopMetadataProperty(key="currency", injectionKey="CURRENCY", injectionKeyDescription="SalesforceInputMeta.Injection.CURRENCY")
    private String currencySymbol;
    @HopMetadataProperty(key="decimal", injectionKey="DECIMAL", injectionKeyDescription="SalesforceInputMeta.Injection.DECIMAL")
    private String decimalSymbol;
    @HopMetadataProperty(key="group", injectionKey="GROUP", injectionKeyDescription="SalesforceInputMeta.Injection.GROUP")
    private String groupSymbol;
    @HopMetadataProperty(key="repeat", injectionKey="REPEAT", injectionKeyDescription="SalesforceInputMeta.Injection.REPEAT")
    private boolean repeated;
    @HopMetadataProperty(key="idlookup", injectionKey="ISIDLOOKUP", injectionKeyDescription="SalesforceInputMeta.Injection.ISIDLOOKUP")
    private boolean idLookup;
    @HopMetadataProperty(key="samples")
    private String[] samples;

    public SalesforceInputField(String fieldname) {
        this.name = fieldname;
        this.field = "";
        this.length = -1;
        this.typeCode = 2;
        this.format = "";
        this.trimType = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeated = false;
        this.idLookup = false;
    }

    public SalesforceInputField() {
        this("");
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return SalesforceInputField.getTrimTypeByCode(tt);
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public Object clone() {
        try {
            return (SalesforceInputField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.typeCode);
    }

    public void setTypeCode(int typeCode) {
        this.typeCode = typeCode;
    }

    public void setTypeCode(String typeDesc) {
        this.typeCode = ValueMetaFactory.getIdForValueMeta((String)typeDesc);
    }

    public void setType(String type) {
        this.type = type;
        if (type != null && !type.isEmpty()) {
            this.typeCode = ValueMetaFactory.getIdForValueMeta((String)type);
        }
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public String getTrimTypeCode() {
        return SalesforceInputField.getTrimTypeCode(this.trimType);
    }

    public String getTrimTypeDesc() {
        return SalesforceInputField.getTrimTypeDesc(this.trimType);
    }

    public void setTrimTypeDesc(String trimTypeDesc) {
        this.trimType = SalesforceInputField.getTrimTypeByDesc(trimTypeDesc);
    }

    public void flipRepeated() {
        this.repeated = !this.repeated;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public int getTypeCode() {
        return this.typeCode;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public int getTrimType() {
        return this.trimType;
    }

    @Generated
    public int getPrecision() {
        return this.precision;
    }

    @Generated
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    @Generated
    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    @Generated
    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    @Generated
    public boolean isRepeated() {
        return this.repeated;
    }

    @Generated
    public boolean isIdLookup() {
        return this.idLookup;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setField(String field) {
        this.field = field;
    }

    @Generated
    public void setLength(int length) {
        this.length = length;
    }

    @Generated
    public void setFormat(String format) {
        this.format = format;
    }

    @Generated
    public void setTrimType(int trimType) {
        this.trimType = trimType;
    }

    @Generated
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Generated
    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    @Generated
    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    @Generated
    public void setGroupSymbol(String groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    @Generated
    public void setRepeated(boolean repeated) {
        this.repeated = repeated;
    }

    @Generated
    public void setIdLookup(boolean idLookup) {
        this.idLookup = idLookup;
    }
}

