/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.schemas;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Ascii;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ImmutableMap;

public class AwsTypes {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized MarshallingType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType> typeMapping = ImmutableMap.builder().put((Object)MarshallingType.STRING, (Object)Schema.FieldType.STRING).put((Object)MarshallingType.SHORT, (Object)Schema.FieldType.INT16).put((Object)MarshallingType.INTEGER, (Object)Schema.FieldType.INT32).put((Object)MarshallingType.LONG, (Object)Schema.FieldType.INT64).put((Object)MarshallingType.FLOAT, (Object)Schema.FieldType.FLOAT).put((Object)MarshallingType.DOUBLE, (Object)Schema.FieldType.DOUBLE).put((Object)MarshallingType.BIG_DECIMAL, (Object)Schema.FieldType.DECIMAL).put((Object)MarshallingType.BOOLEAN, (Object)Schema.FieldType.BOOLEAN).put((Object)MarshallingType.INSTANT, (Object)Schema.FieldType.DATETIME).put((Object)MarshallingType.SDK_BYTES, (Object)Schema.FieldType.BYTES).build();

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> seen) {
        MarshallingType type = field.marshallingType();
        if (type == MarshallingType.LIST) {
            return Schema.FieldType.array((Schema.FieldType)AwsTypes.fieldType(AwsTypes.elementField(field), seen));
        }
        if (type == MarshallingType.MAP) {
            return Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)AwsTypes.fieldType(AwsTypes.valueField(field), seen));
        }
        if (type == MarshallingType.SDK_POJO) {
            SdkPojo builder = (SdkPojo)field.constructor().get();
            Class<?> clazz = AwsTypes.targetClassOf(builder);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!seen.contains(clazz) ? 1 : 0) != 0, (String)"Self-recursive types are not supported: %s", clazz);
            return Schema.FieldType.row((Schema)AwsTypes.schemaFor(builder.sdkFields(), Sets.union(seen, Collections.singleton(clazz))));
        }
        Schema.FieldType fieldType = typeMapping.get(type);
        if (fieldType != null) {
            return fieldType;
        }
        throw new RuntimeException(String.format("Type %s of field %s is unknown.", type, AwsTypes.normalizedNameOf(field)));
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema schemaFor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fields, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> seen) {
        Schema.Builder builder = Schema.builder();
        for (SdkField<?> sdkField : fields) {
            builder.addField(Schema.Field.nullable((String)AwsTypes.normalizedNameOf(sdkField), (Schema.FieldType)AwsTypes.fieldType(sdkField, seen)));
        }
        return builder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Schema schemaFor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fields) {
        return AwsTypes.schemaFor(fields, ImmutableSet.of());
    }

    static @UnknownKeyFor @NonNull @Initialized String normalizedNameOf(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
        String name = field.memberName();
        return name.length() > 1 && Ascii.isLowerCase((char)name.charAt(1)) ? Ascii.toLowerCase((char)name.charAt(0)) + name.substring(1) : name.toLowerCase(Locale.ROOT);
    }

    static @UnknownKeyFor @NonNull @Initialized Instant toJavaInstant(@UnknownKeyFor @NonNull @Initialized Object instant) {
        return Instant.ofEpochMilli(((org.joda.time.Instant)instant).getMillis());
    }

    private static @UnknownKeyFor @NonNull @Initialized org.joda.time.Instant toJodaInstant(@UnknownKeyFor @NonNull @Initialized Object instant) {
        return org.joda.time.Instant.ofEpochMilli((long)((Instant)instant).toEpochMilli());
    }

    private static @UnknownKeyFor @NonNull @Initialized SdkBytes toSdkBytes(@UnknownKeyFor @NonNull @Initialized Object sdkBytes) {
        return SdkBytes.fromByteArrayUnsafe((byte[])((byte[])sdkBytes));
    }

    private static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toBytes(@UnknownKeyFor @NonNull @Initialized Object sdkBytes) {
        return ((SdkBytes)sdkBytes).asByteArrayUnsafe();
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> elementField(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
        return ((ListTrait)field.getTrait(ListTrait.class)).memberFieldInfo();
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> valueField(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
        return ((MapTrait)field.getTrait(MapTrait.class)).valueFieldInfo();
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClassOf(@UnknownKeyFor @NonNull @Initialized SdkPojo builder) {
        return (Class)Preconditions.checkArgumentNotNull(builder.getClass().getDeclaringClass(), (String)"Expected nested builder class, but got %s", builder.getClass());
    }

    static abstract class ConverterFactory
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized SerializableFunction IDENTITY = (SerializableFunction & Serializable)x -> x;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction instantConverter;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction bytesConverter;
        private final @UnknownKeyFor @NonNull @Initialized boolean convertPojoType;

        private ConverterFactory(@UnknownKeyFor @NonNull @Initialized SerializableFunction instantConverter, @UnknownKeyFor @NonNull @Initialized SerializableFunction bytesConverter, @UnknownKeyFor @NonNull @Initialized boolean convertPojoType) {
            this.instantConverter = instantConverter;
            this.bytesConverter = bytesConverter;
            this.convertPojoType = convertPojoType;
        }

        static @UnknownKeyFor @NonNull @Initialized ConverterFactory toAws(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fromRowFactory) {
            return new ToAws(fromRowFactory);
        }

        static @UnknownKeyFor @NonNull @Initialized ConverterFactory fromAws() {
            return FromAws.INSTANCE;
        }

        static <T, X1, X2> @UnknownKeyFor @NonNull @Initialized BiConsumer<T, X1> createSetter(@UnknownKeyFor @NonNull @Initialized BiConsumer<T, X2> set, @UnknownKeyFor @NonNull @Initialized SerializableFunction fn) {
            return (obj, value) -> set.accept(obj, fn.apply(value));
        }

        @UnknownKeyFor @NonNull @Initialized SerializableFunction pojoTypeConverter(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
            throw new UnsupportedOperationException();
        }

        @UnknownKeyFor @NonNull @Initialized SerializableFunction create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
            return this.create(IDENTITY, field);
        }

        @UnknownKeyFor @NonNull @Initialized SerializableFunction create(@UnknownKeyFor @NonNull @Initialized SerializableFunction fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
            SerializableFunction converter;
            MarshallingType awsType = field.marshallingType();
            if (awsType == MarshallingType.SDK_POJO) {
                converter = this.pojoTypeConverter(field);
            } else if (awsType == MarshallingType.INSTANT) {
                converter = this.instantConverter;
            } else if (awsType == MarshallingType.SDK_BYTES) {
                converter = this.bytesConverter;
            } else if (awsType == MarshallingType.LIST) {
                converter = ConverterFactory.transformList(this.create(AwsTypes.elementField(field)));
            } else if (awsType == MarshallingType.MAP) {
                converter = ConverterFactory.transformMap(this.create(AwsTypes.valueField(field)));
            } else {
                throw new IllegalStateException("Unexpected marshalling type " + awsType);
            }
            return fn != IDENTITY ? ConverterFactory.andThen(fn, ConverterFactory.nullSafe(converter)) : ConverterFactory.nullSafe(converter);
        }

        @UnknownKeyFor @NonNull @Initialized boolean needsConversion(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
            MarshallingType type = field.marshallingType();
            return this.convertPojoType && type.equals(MarshallingType.SDK_POJO) || type.equals(MarshallingType.INSTANT) || type.equals(MarshallingType.SDK_BYTES) || type.equals(MarshallingType.MAP) && this.needsConversion(AwsTypes.valueField(field)) || type.equals(MarshallingType.LIST) && this.needsConversion(AwsTypes.elementField(field));
        }

        private static @UnknownKeyFor @NonNull @Initialized SerializableFunction andThen(@UnknownKeyFor @NonNull @Initialized SerializableFunction fn1, @UnknownKeyFor @NonNull @Initialized SerializableFunction fn2) {
            return (SerializableFunction & Serializable)v -> fn2.apply(fn1.apply(v));
        }

        private static @UnknownKeyFor @NonNull @Initialized SerializableFunction nullSafe(@UnknownKeyFor @NonNull @Initialized SerializableFunction fn) {
            return (SerializableFunction & Serializable)v -> v == null ? null : fn.apply(v);
        }

        private static @UnknownKeyFor @NonNull @Initialized SerializableFunction transformList(@UnknownKeyFor @NonNull @Initialized SerializableFunction fn) {
            return (SerializableFunction & Serializable)list -> Lists.transform((List)((List)list), arg_0 -> ((SerializableFunction)fn).apply(arg_0));
        }

        private static @UnknownKeyFor @NonNull @Initialized SerializableFunction transformMap(@UnknownKeyFor @NonNull @Initialized SerializableFunction fn) {
            return (SerializableFunction & Serializable)map -> Maps.transformValues((Map)((Map)map), arg_0 -> ((SerializableFunction)fn).apply(arg_0));
        }

        private static class FromAws
        extends ConverterFactory {
            private static final @UnknownKeyFor @NonNull @Initialized ConverterFactory INSTANCE = new FromAws();

            FromAws() {
                super((SerializableFunction & Serializable)x$0 -> AwsTypes.toJodaInstant(x$0), (SerializableFunction & Serializable)x$0 -> AwsTypes.toBytes(x$0), false);
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized SerializableFunction create(@UnknownKeyFor @NonNull @Initialized SerializableFunction fn, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
                MarshallingType type = field.marshallingType();
                if (type.equals(MarshallingType.MAP)) {
                    fn = FromAws.skipDefaultMap(fn);
                } else if (type.equals(MarshallingType.LIST)) {
                    fn = FromAws.skipDefaultList(fn);
                }
                return this.needsConversion(field) ? super.create(fn, field) : fn;
            }

            private static @UnknownKeyFor @NonNull @Initialized SerializableFunction skipDefaultList(@UnknownKeyFor @NonNull @Initialized SerializableFunction fn) {
                return (SerializableFunction & Serializable)in -> {
                    Object list = fn.apply(in);
                    return list != DefaultSdkAutoConstructList.getInstance() ? list : null;
                };
            }

            private static @UnknownKeyFor @NonNull @Initialized SerializableFunction skipDefaultMap(@UnknownKeyFor @NonNull @Initialized SerializableFunction fn) {
                return (SerializableFunction & Serializable)in -> {
                    Object map = fn.apply(in);
                    return map != DefaultSdkAutoConstructMap.getInstance() ? map : null;
                };
            }
        }

        private static class ToAws
        extends ConverterFactory {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fromRowFactory;

            ToAws(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fromRowFactory) {
                super(AwsTypes::toJavaInstant, (SerializableFunction & Serializable)x$0 -> AwsTypes.toSdkBytes(x$0), true);
                this.fromRowFactory = fromRowFactory;
            }

            @Override
            protected @UnknownKeyFor @NonNull @Initialized SerializableFunction pojoTypeConverter(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> field) {
                return (SerializableFunction)this.fromRowFactory.create(TypeDescriptor.of((Class)AwsTypes.targetClassOf((SdkPojo)field.constructor().get())), null);
            }
        }
    }
}

