/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.io.aws2.options.S3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.s3.DefaultS3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.s3.SSECustomerKey;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface S3Options
extends AwsOptions {
    @Description(value="AWS S3 storage class used for creating S3 objects")
    @Default.String(value="STANDARD")
    public @UnknownKeyFor @NonNull @Initialized String getS3StorageClass();

    public void setS3StorageClass(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Size of S3 upload chunks; max upload object size is this value multiplied by 10000;default is 64MB, or 5MB in memory-constrained environments. Must be at least 5MB.")
    @Default.InstanceFactory(value=S3UploadBufferSizeBytesFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Integer getS3UploadBufferSizeBytes();

    public void setS3UploadBufferSizeBytes(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Thread pool size, limiting max concurrent S3 operations")
    @Default.Integer(value=50)
    public @UnknownKeyFor @NonNull @Initialized int getS3ThreadPoolSize();

    public void setS3ThreadPoolSize(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Algorithm for SSE-S3 encryption, e.g. AES256.")
    public @Nullable @UnknownKeyFor @Initialized String getSSEAlgorithm();

    public void setSSEAlgorithm(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="SSE key for SSE-C encryption, e.g. a base64 encoded key and the algorithm.To specify on the command-line, represent the value as a JSON object. For example: --SSECustomerKey={\"key\": \"86glyTlCN...\", \"algorithm\": \"AES256\"}")
    @Default.InstanceFactory(value=SSECustomerKeyFactory.class)
    public @UnknownKeyFor @NonNull @Initialized SSECustomerKey getSSECustomerKey();

    public void setSSECustomerKey(@UnknownKeyFor @NonNull @Initialized SSECustomerKey var1);

    @Description(value="KMS key id for SSE-KMS encryption, e.g. arn:aws:kms:....")
    public @Nullable @UnknownKeyFor @Initialized String getSSEKMSKeyId();

    public void setSSEKMSKeyId(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Enable to use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS)")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean getBucketKeyEnabled();

    public void setBucketKeyEnabled(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="Factory class that should be created and used to create a builder of S3client.Override the default value if you need a S3 client with custom properties, like path style access, etc.")
    @Default.Class(value=DefaultS3ClientBuilderFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized S3ClientBuilderFactory> getS3ClientFactoryClass();

    public void setS3ClientFactoryClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized S3ClientBuilderFactory> var1);

    public static class SSECustomerKeyFactory
    implements DefaultValueFactory<SSECustomerKey> {
        public @UnknownKeyFor @NonNull @Initialized SSECustomerKey create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return SSECustomerKey.builder().build();
        }
    }

    public static class S3UploadBufferSizeBytesFactory
    implements DefaultValueFactory<Integer> {
        public static final @UnknownKeyFor @NonNull @Initialized int REQUIRED_MEMORY_FOR_DEFAULT_BUFFER_BYTES = 0x20000000;
        public static final @UnknownKeyFor @NonNull @Initialized int MINIMUM_UPLOAD_BUFFER_SIZE_BYTES = 0x500000;
        public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_UPLOAD_BUFFER_SIZE_BYTES = 0x4000000;

        public @UnknownKeyFor @NonNull @Initialized Integer create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return Runtime.getRuntime().maxMemory() < 0x20000000L ? 0x500000 : 0x4000000;
        }
    }
}

