/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.kinesis.retrieval.AggregatorUtil;
import software.amazon.kinesis.retrieval.kpl.Messages;

@NotThreadSafe
@Internal
class RecordsAggregator {
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] MAGIC_BYTES = AggregatorUtil.AGGREGATED_RECORD_MAGIC;
    private static final @UnknownKeyFor @NonNull @Initialized int DIGEST_SIZE = 16;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int BASE_OVERHEAD = MAGIC_BYTES.length + 16;
    private final @UnknownKeyFor @NonNull @Initialized int maxAggregatedBytes;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Messages.AggregatedRecord.Builder aggBuilder;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> partitionKeys;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> explicitHashKeys;
    private @UnknownKeyFor @NonNull @Initialized int sizeBytes;
    private @UnknownKeyFor @NonNull @Initialized Instant timeout;

    RecordsAggregator(@UnknownKeyFor @NonNull @Initialized int maxAggregatedBytes, @UnknownKeyFor @NonNull @Initialized Instant timeout) {
        this.maxAggregatedBytes = maxAggregatedBytes;
        this.aggBuilder = Messages.AggregatedRecord.newBuilder();
        this.partitionKeys = new TreeMap<String, Integer>();
        this.explicitHashKeys = new TreeMap<String, Integer>();
        this.sizeBytes = BASE_OVERHEAD;
        this.timeout = timeout;
    }

    @UnknownKeyFor @NonNull @Initialized int getRecordsCount() {
        return this.aggBuilder.getRecordsCount();
    }

    @UnknownKeyFor @NonNull @Initialized boolean addRecord(@UnknownKeyFor @NonNull @Initialized String partitionKey, @Nullable @UnknownKeyFor @Initialized String explicitHashKey, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] record) {
        int recordSize = this.sizeIncrement(partitionKey, explicitHashKey, record);
        if (this.sizeBytes + recordSize > this.maxAggregatedBytes) {
            return false;
        }
        ByteString data = record != null ? ByteString.copyFrom((byte[])record) : ByteString.EMPTY;
        Messages.Record.Builder recordBuilder = Messages.Record.newBuilder().setData(data);
        recordBuilder.setPartitionKeyIndex((long)this.partitionKeys.computeIfAbsent(partitionKey, pk -> this.aggBuilder.addPartitionKeyTable(pk).getPartitionKeyTableCount() - 1).intValue());
        if (explicitHashKey != null) {
            recordBuilder.setExplicitHashKeyIndex((long)this.explicitHashKeys.computeIfAbsent(explicitHashKey, ehk -> this.aggBuilder.addExplicitHashKeyTable(ehk).getExplicitHashKeyTableCount() - 1).intValue());
        }
        this.aggBuilder.addRecords(recordBuilder.build());
        this.sizeBytes += recordSize;
        return true;
    }

    @UnknownKeyFor @NonNull @Initialized boolean hasCapacity() {
        if (this.aggBuilder.getRecordsCount() == 0) {
            return true;
        }
        int avgSize = (this.sizeBytes - BASE_OVERHEAD) / this.aggBuilder.getRecordsCount();
        return this.sizeBytes + avgSize <= this.maxAggregatedBytes;
    }

    @UnknownKeyFor @NonNull @Initialized PutRecordsRequestEntry get() {
        PutRecordsRequestEntry.Builder entryBuilder = PutRecordsRequestEntry.builder().data(SdkBytes.fromByteArrayUnsafe((byte[])this.toBytes()));
        if (this.aggBuilder.getExplicitHashKeyTableCount() > 0) {
            entryBuilder.partitionKey("a").explicitHashKey(this.aggBuilder.getExplicitHashKeyTable(0));
        } else {
            entryBuilder.partitionKey(this.aggBuilder.getPartitionKeyTable(0));
        }
        return (PutRecordsRequestEntry)entryBuilder.build();
    }

    @UnknownKeyFor @NonNull @Initialized PutRecordsRequestEntry getAndReset(@UnknownKeyFor @NonNull @Initialized Instant nextTimeout) {
        PutRecordsRequestEntry entry = this.get();
        this.reset(nextTimeout);
        return entry;
    }

    @UnknownKeyFor @NonNull @Initialized Instant timeout() {
        return this.timeout;
    }

    private void reset(@UnknownKeyFor @NonNull @Initialized Instant nextTimeout) {
        this.aggBuilder.clearRecords();
        this.aggBuilder.clearPartitionKeyTable();
        this.aggBuilder.clearExplicitHashKeyTable();
        this.partitionKeys.clear();
        this.explicitHashKeys.clear();
        this.sizeBytes = BASE_OVERHEAD;
        this.timeout = nextTimeout;
    }

    private static void sizeIncrementOfKey(@UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] size, @UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> keyTable) {
        int keyLength = key.getBytes(StandardCharsets.UTF_8).length;
        Integer idx = keyTable.get(key);
        if (idx == null) {
            size[0] = size[0] + (1 + VarInt.getLength((int)keyLength) + keyLength);
        }
        size[1] = size[1] + (1 + VarInt.getLength((int)(idx != null ? idx.intValue() : keyTable.size())));
    }

    @VisibleForTesting
    protected @UnknownKeyFor @NonNull @Initialized int sizeIncrement(@UnknownKeyFor @NonNull @Initialized String partitionKey, @Nullable @UnknownKeyFor @Initialized String hashKey, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] record) {
        int[] size = new int[]{0, 0};
        RecordsAggregator.sizeIncrementOfKey(size, partitionKey, this.partitionKeys);
        if (hashKey != null) {
            RecordsAggregator.sizeIncrementOfKey(size, hashKey, this.explicitHashKeys);
        }
        if (record != null) {
            size[1] = size[1] + (1 + VarInt.getLength((int)record.length) + record.length);
        }
        return size[0] + 1 + VarInt.getLength((int)size[1]) + size[1];
    }

    @VisibleForTesting
    protected @UnknownKeyFor @NonNull @Initialized int getSizeBytes() {
        return this.sizeBytes;
    }

    @VisibleForTesting
    protected @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toBytes() {
        try {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] body = this.aggBuilder.build().toByteArray();
            byte[] digest = md5.digest(body);
            ByteBuffer buffer = ByteBuffer.allocate(MAGIC_BYTES.length + body.length + digest.length);
            return buffer.put(MAGIC_BYTES).put(body).put(digest).array();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 not available", e);
        }
    }
}

