/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import io.netty.channel.ChannelException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.beam.sdk.io.aws2.kinesis.EFOShardSubscribersPool;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Throwables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.awssdk.services.kinesis.model.StartingPosition;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardEventStream;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponseHandler;

class EFOShardSubscriber {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(EFOShardSubscriber.class);
    private final @UnknownKeyFor @NonNull @Initialized EFOShardSubscribersPool pool;
    private final @UnknownKeyFor @NonNull @Initialized String consumerArn;
    private final @UnknownKeyFor @NonNull @Initialized String shardId;
    private final @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis;
    private volatile @UnknownKeyFor @NonNull @Initialized State state = State.INITIALIZED;
    private @MonotonicNonNull @UnknownKeyFor @Initialized StartingPosition initialPosition;
    private final @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> done = new CompletableFuture();
    private final @UnknownKeyFor @NonNull @Initialized EFOShardSubscriber. @UnknownKeyFor @NonNull @Initialized ShardEventsSubscriber eventsSubscriber = new ShardEventsSubscriber();
    private final @UnknownKeyFor @NonNull @Initialized AtomicInteger inFlight = new AtomicInteger();
    private final @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized Throwable> reSubscriptionHandler;

    private static @UnknownKeyFor @NonNull @Initialized boolean isRetryable(@UnknownKeyFor @NonNull @Initialized Throwable error) {
        Throwable cause = EFOShardSubscriber.unwrapCompletionException(error);
        if (cause instanceof SdkException && ((SdkException)cause).retryable()) {
            return true;
        }
        return (cause = Throwables.getRootCause((Throwable)cause)) instanceof ClosedChannelException || cause instanceof TimeoutException || cause instanceof ChannelException;
    }

    private static @UnknownKeyFor @NonNull @Initialized Throwable unwrapCompletionException(@UnknownKeyFor @NonNull @Initialized Throwable completionException) {
        Throwable current = completionException;
        while (current instanceof CompletionException) {
            Throwable cause = current.getCause();
            if (cause != null) {
                current = cause;
                continue;
            }
            return current;
        }
        return current;
    }

    EFOShardSubscriber(@UnknownKeyFor @NonNull @Initialized EFOShardSubscribersPool pool, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized String consumerArn, @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis, @UnknownKeyFor @NonNull @Initialized int onErrorCoolDownMs) {
        this.pool = pool;
        this.consumerArn = consumerArn;
        this.shardId = shardId;
        this.kinesis = kinesis;
        this.reSubscriptionHandler = (unused, error) -> {
            this.eventsSubscriber.cancel();
            if (error != null && !EFOShardSubscriber.isRetryable(error)) {
                this.done.completeExceptionally((Throwable)error);
                return;
            }
            if (error != null && EFOShardSubscriber.isRetryable(error) && this.state != State.STOPPED) {
                String lastContinuationSequenceNumber = this.eventsSubscriber.sequenceNumber;
                if (this.inFlight.get() == pool.getMaxCapacityPerShard()) {
                    this.state = State.PAUSED;
                } else if (lastContinuationSequenceNumber != null) {
                    pool.delayedTask(() -> this.internalReSubscribe(lastContinuationSequenceNumber), onErrorCoolDownMs);
                } else {
                    pool.delayedTask(() -> this.internalSubscribe(this.initialPosition), onErrorCoolDownMs);
                }
                return;
            }
            String lastContinuationSequenceNumber = this.eventsSubscriber.sequenceNumber;
            if (error == null && this.state != State.STOPPED && lastContinuationSequenceNumber != null) {
                this.internalReSubscribe(lastContinuationSequenceNumber);
                return;
            }
            if (error == null && this.state != State.STOPPED && lastContinuationSequenceNumber == null) {
                this.done.complete(null);
                return;
            }
            String msg = String.format("Pool %s - unknown case which is likely a bug: state=%s seqnum=%s", new Object[]{pool.getPoolId(), this.state, lastContinuationSequenceNumber});
            LOG.warn(msg);
            this.done.completeExceptionally(new IllegalStateException(msg));
        };
    }

    @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> subscribe(@UnknownKeyFor @NonNull @Initialized StartingPosition position) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0, (Object)"Subscriber was already started");
        this.initialPosition = position;
        return this.internalSubscribe(position);
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> internalReSubscribe(@UnknownKeyFor @NonNull @Initialized String sequenceNumber) {
        return this.internalSubscribe((StartingPosition)StartingPosition.builder().type(ShardIteratorType.AFTER_SEQUENCE_NUMBER).sequenceNumber(sequenceNumber).build());
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> internalSubscribe(@UnknownKeyFor @NonNull @Initialized StartingPosition position) {
        SubscribeToShardRequest request = this.subscribeRequest(position);
        LOG.info("Pool {} - shard {} starting subscribe request {}", new Object[]{this.pool.getPoolId(), this.shardId, request});
        try {
            this.kinesis.subscribeToShard(request, this.responseHandler()).whenComplete(this.reSubscriptionHandler);
            return this.done;
        }
        catch (Exception e) {
            this.done.completeExceptionally(e);
            return this.done;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized SubscribeToShardRequest subscribeRequest(@UnknownKeyFor @NonNull @Initialized StartingPosition position) {
        return (SubscribeToShardRequest)SubscribeToShardRequest.builder().consumerARN(this.consumerArn).shardId(this.shardId).startingPosition(position).build();
    }

    private @UnknownKeyFor @NonNull @Initialized SubscribeToShardResponseHandler responseHandler() {
        return ((SubscribeToShardResponseHandler.Builder)SubscribeToShardResponseHandler.builder().subscriber(() -> this.eventsSubscriber)).build();
    }

    void cancel() {
        LOG.info("Pool {} - shard {} cancelling", (Object)this.pool.getPoolId(), (Object)this.shardId);
        if (this.state != State.STOPPED && this.eventsSubscriber != null) {
            this.eventsSubscriber.cancel();
            this.state = State.STOPPED;
        }
    }

    void ackEvent() {
        Subscription s;
        int prevInFlight = this.inFlight.getAndDecrement();
        if (this.state == State.PAUSED) {
            this.state = State.RUNNING;
            this.internalReSubscribe((String)Preconditions.checkStateNotNull((Object)this.eventsSubscriber.sequenceNumber));
        } else if (prevInFlight == this.pool.getMaxCapacityPerShard() && (s = this.eventsSubscriber.subscription) != null) {
            s.request(1L);
        }
    }

    private class ShardEventsSubscriber
    implements Subscriber<SubscribeToShardEventStream>,
    SubscribeToShardResponseHandler.Visitor {
        @Nullable @UnknownKeyFor @Initialized String sequenceNumber;
        @Nullable @UnknownKeyFor @Initialized Subscription subscription;

        private ShardEventsSubscriber() {
        }

        void cancel() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            this.subscription = null;
        }

        public void onSubscribe(@UnknownKeyFor @NonNull @Initialized Subscription subscription) {
            this.subscription = subscription;
            if (EFOShardSubscriber.this.state == State.STOPPED) {
                this.cancel();
            } else if (EFOShardSubscriber.this.inFlight.get() < EFOShardSubscriber.this.pool.getMaxCapacityPerShard()) {
                subscription.request(1L);
            }
        }

        public void visit(@UnknownKeyFor @NonNull @Initialized SubscribeToShardEvent event) {
            EFOShardSubscriber.this.pool.enqueueEvent(EFOShardSubscriber.this.shardId, event);
            this.sequenceNumber = event.continuationSequenceNumber();
            int capacity = EFOShardSubscriber.this.pool.getMaxCapacityPerShard() - EFOShardSubscriber.this.inFlight.incrementAndGet();
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((capacity >= 0 ? 1 : 0) != 0, (Object)"Exceeded in-flight limit");
            if (capacity > 0 && this.subscription != null) {
                this.subscription.request(1L);
            }
        }

        public void onNext(@UnknownKeyFor @NonNull @Initialized SubscribeToShardEventStream event) {
            event.accept((SubscribeToShardResponseHandler.Visitor)this);
        }

        public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
            LOG.warn("Pool {} - shard {} subscriber got error", new Object[]{EFOShardSubscriber.this.pool.getPoolId(), EFOShardSubscriber.this.shardId, t});
        }

        public void onComplete() {
            this.subscription = null;
        }
    }

    static enum State {
        INITIALIZED,
        RUNNING,
        PAUSED,
        STOPPED;

    }
}

