/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.kinesis.EFOShardSubscribersPool;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisSource;
import org.apache.beam.sdk.io.aws2.kinesis.TransientKinesisException;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;

class EFOKinesisReader
extends UnboundedSource.UnboundedReader<KinesisRecord> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(EFOKinesisReader.class);
    private final  @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec;
    private final @UnknownKeyFor @NonNull @Initialized String consumerArn;
    private final @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis;
    private final @UnknownKeyFor @NonNull @Initialized KinesisSource source;
    private final @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint initCheckpoint;
    private @Nullable @UnknownKeyFor @Initialized KinesisRecord currentRecord = null;
    private @Nullable @UnknownKeyFor @Initialized EFOShardSubscribersPool shardSubscribersPool = null;

    EFOKinesisReader( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec, @UnknownKeyFor @NonNull @Initialized String consumerArn, @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis, @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint initCheckpoint, @UnknownKeyFor @NonNull @Initialized KinesisSource source) {
        this.spec = spec;
        this.consumerArn = consumerArn;
        this.kinesis = kinesis;
        this.initCheckpoint = initCheckpoint;
        this.source = source;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.info("Starting reader using {}", (Object)this.initCheckpoint);
        try {
            this.shardSubscribersPool = this.createPool();
            this.shardSubscribersPool().start(this.initCheckpoint);
            return this.advance();
        }
        catch (TransientKinesisException e) {
            throw new IOException(e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized EFOShardSubscribersPool shardSubscribersPool() {
        return (EFOShardSubscribersPool)Preconditions.checkStateNotNull((Object)this.shardSubscribersPool, (Object)"Reader was not started");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.currentRecord = this.shardSubscribersPool().getNextRecord();
        return this.currentRecord != null;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrentRecordId() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.getOrThrow().getUniqueId();
    }

    public @UnknownKeyFor @NonNull @Initialized KinesisRecord getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.getOrThrow();
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.getOrThrow().getApproximateArrivalTimestamp();
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (KinesisAsyncClient c = this.kinesis;){
            this.shardSubscribersPool().stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        return this.shardSubscribersPool().getWatermark();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
        return this.shardSubscribersPool().getCheckpointMark();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized KinesisRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentSource() {
        return this.source;
    }

    @UnknownKeyFor @NonNull @Initialized EFOShardSubscribersPool createPool() throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return new EFOShardSubscribersPool(this.spec, this.consumerArn, this.kinesis);
    }

    private @UnknownKeyFor @NonNull @Initialized KinesisRecord getOrThrow() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.currentRecord != null) {
            return this.currentRecord;
        }
        throw new NoSuchElementException();
    }
}

