/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import org.apache.beam.sdk.io.aws2.kinesis.KinesisIO;
import org.joda.time.Duration;

final class AutoValue_KinesisIO_RecordAggregation
extends KinesisIO.RecordAggregation {
    private final int maxBytes;
    private final Duration maxBufferedTime;
    private final double maxBufferedTimeJitter;
    private final Duration shardRefreshInterval;
    private final double shardRefreshIntervalJitter;

    private AutoValue_KinesisIO_RecordAggregation(int maxBytes, Duration maxBufferedTime, double maxBufferedTimeJitter, Duration shardRefreshInterval, double shardRefreshIntervalJitter) {
        this.maxBytes = maxBytes;
        this.maxBufferedTime = maxBufferedTime;
        this.maxBufferedTimeJitter = maxBufferedTimeJitter;
        this.shardRefreshInterval = shardRefreshInterval;
        this.shardRefreshIntervalJitter = shardRefreshIntervalJitter;
    }

    @Override
    int maxBytes() {
        return this.maxBytes;
    }

    @Override
    Duration maxBufferedTime() {
        return this.maxBufferedTime;
    }

    @Override
    double maxBufferedTimeJitter() {
        return this.maxBufferedTimeJitter;
    }

    @Override
    Duration shardRefreshInterval() {
        return this.shardRefreshInterval;
    }

    @Override
    double shardRefreshIntervalJitter() {
        return this.shardRefreshIntervalJitter;
    }

    public String toString() {
        return "RecordAggregation{maxBytes=" + this.maxBytes + ", maxBufferedTime=" + this.maxBufferedTime + ", maxBufferedTimeJitter=" + this.maxBufferedTimeJitter + ", shardRefreshInterval=" + this.shardRefreshInterval + ", shardRefreshIntervalJitter=" + this.shardRefreshIntervalJitter + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KinesisIO.RecordAggregation) {
            KinesisIO.RecordAggregation that = (KinesisIO.RecordAggregation)o;
            return this.maxBytes == that.maxBytes() && this.maxBufferedTime.equals((Object)that.maxBufferedTime()) && Double.doubleToLongBits(this.maxBufferedTimeJitter) == Double.doubleToLongBits(that.maxBufferedTimeJitter()) && this.shardRefreshInterval.equals((Object)that.shardRefreshInterval()) && Double.doubleToLongBits(this.shardRefreshIntervalJitter) == Double.doubleToLongBits(that.shardRefreshIntervalJitter());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.maxBytes;
        h$ *= 1000003;
        h$ ^= this.maxBufferedTime.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.maxBufferedTimeJitter) >>> 32 ^ Double.doubleToLongBits(this.maxBufferedTimeJitter));
        h$ *= 1000003;
        h$ ^= this.shardRefreshInterval.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(Double.doubleToLongBits(this.shardRefreshIntervalJitter) >>> 32 ^ Double.doubleToLongBits(this.shardRefreshIntervalJitter));
    }

    static final class Builder
    extends KinesisIO.RecordAggregation.Builder {
        private Integer maxBytes;
        private Duration maxBufferedTime;
        private Double maxBufferedTimeJitter;
        private Duration shardRefreshInterval;
        private Double shardRefreshIntervalJitter;

        Builder() {
        }

        @Override
        public KinesisIO.RecordAggregation.Builder maxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        @Override
        public KinesisIO.RecordAggregation.Builder maxBufferedTime(Duration maxBufferedTime) {
            if (maxBufferedTime == null) {
                throw new NullPointerException("Null maxBufferedTime");
            }
            this.maxBufferedTime = maxBufferedTime;
            return this;
        }

        @Override
        KinesisIO.RecordAggregation.Builder maxBufferedTimeJitter(double maxBufferedTimeJitter) {
            this.maxBufferedTimeJitter = maxBufferedTimeJitter;
            return this;
        }

        @Override
        public KinesisIO.RecordAggregation.Builder shardRefreshInterval(Duration shardRefreshInterval) {
            if (shardRefreshInterval == null) {
                throw new NullPointerException("Null shardRefreshInterval");
            }
            this.shardRefreshInterval = shardRefreshInterval;
            return this;
        }

        @Override
        KinesisIO.RecordAggregation.Builder shardRefreshIntervalJitter(double shardRefreshIntervalJitter) {
            this.shardRefreshIntervalJitter = shardRefreshIntervalJitter;
            return this;
        }

        @Override
        KinesisIO.RecordAggregation autoBuild() {
            if (this.maxBytes == null || this.maxBufferedTime == null || this.maxBufferedTimeJitter == null || this.shardRefreshInterval == null || this.shardRefreshIntervalJitter == null) {
                StringBuilder missing = new StringBuilder();
                if (this.maxBytes == null) {
                    missing.append(" maxBytes");
                }
                if (this.maxBufferedTime == null) {
                    missing.append(" maxBufferedTime");
                }
                if (this.maxBufferedTimeJitter == null) {
                    missing.append(" maxBufferedTimeJitter");
                }
                if (this.shardRefreshInterval == null) {
                    missing.append(" shardRefreshInterval");
                }
                if (this.shardRefreshIntervalJitter == null) {
                    missing.append(" shardRefreshIntervalJitter");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KinesisIO_RecordAggregation(this.maxBytes, this.maxBufferedTime, this.maxBufferedTimeJitter, this.shardRefreshInterval, this.shardRefreshIntervalJitter);
        }
    }
}

