/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import java.util.List;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.dynamodb.DynamoDBIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

final class AutoValue_DynamoDBIO_Write<T>
extends DynamoDBIO.Write<T> {
    private final ClientConfiguration clientConfiguration;
    private final @Nullable SerializableFunction<T, KV<String, WriteRequest>> writeItemMapperFn;
    private final List<String> deduplicateKeys;

    private AutoValue_DynamoDBIO_Write(ClientConfiguration clientConfiguration, @Nullable SerializableFunction<T, KV<String, WriteRequest>> writeItemMapperFn, List<String> deduplicateKeys) {
        this.clientConfiguration = clientConfiguration;
        this.writeItemMapperFn = writeItemMapperFn;
        this.deduplicateKeys = deduplicateKeys;
    }

    @Override
    ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @Override
    @Nullable SerializableFunction<T, KV<String, WriteRequest>> getWriteItemMapperFn() {
        return this.writeItemMapperFn;
    }

    @Override
    List<String> getDeduplicateKeys() {
        return this.deduplicateKeys;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DynamoDBIO.Write) {
            DynamoDBIO.Write that = (DynamoDBIO.Write)((Object)o);
            return this.clientConfiguration.equals(that.getClientConfiguration()) && (this.writeItemMapperFn == null ? that.getWriteItemMapperFn() == null : this.writeItemMapperFn.equals(that.getWriteItemMapperFn())) && this.deduplicateKeys.equals(that.getDeduplicateKeys());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clientConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeItemMapperFn == null ? 0 : this.writeItemMapperFn.hashCode();
        h$ *= 1000003;
        return h$ ^= this.deduplicateKeys.hashCode();
    }

    @Override
    DynamoDBIO.Write.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends DynamoDBIO.Write.Builder<T> {
        private ClientConfiguration clientConfiguration;
        private @Nullable SerializableFunction<T, KV<String, WriteRequest>> writeItemMapperFn;
        private List<String> deduplicateKeys;

        Builder() {
        }

        private Builder(DynamoDBIO.Write<T> source) {
            this.clientConfiguration = source.getClientConfiguration();
            this.writeItemMapperFn = source.getWriteItemMapperFn();
            this.deduplicateKeys = source.getDeduplicateKeys();
        }

        @Override
        DynamoDBIO.Write.Builder<T> setClientConfiguration(ClientConfiguration clientConfiguration) {
            if (clientConfiguration == null) {
                throw new NullPointerException("Null clientConfiguration");
            }
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        @Override
        DynamoDBIO.Write.Builder<T> setWriteItemMapperFn(SerializableFunction<T, KV<String, WriteRequest>> writeItemMapperFn) {
            this.writeItemMapperFn = writeItemMapperFn;
            return this;
        }

        @Override
        DynamoDBIO.Write.Builder<T> setDeduplicateKeys(List<String> deduplicateKeys) {
            if (deduplicateKeys == null) {
                throw new NullPointerException("Null deduplicateKeys");
            }
            this.deduplicateKeys = deduplicateKeys;
            return this;
        }

        @Override
        DynamoDBIO.Write<T> build() {
            if (this.clientConfiguration == null || this.deduplicateKeys == null) {
                StringBuilder missing = new StringBuilder();
                if (this.clientConfiguration == null) {
                    missing.append(" clientConfiguration");
                }
                if (this.deduplicateKeys == null) {
                    missing.append(" deduplicateKeys");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DynamoDBIO_Write(this.clientConfiguration, this.writeItemMapperFn, this.deduplicateKeys);
        }
    }
}

