/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.types;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class HtmlExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler {
    private Browser wBrowser;
    private String originalHtmlContent;

    public HtmlExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    public void renderFile(Composite composite) {
        this.wBrowser = new Browser(composite, 0);
        PropsUi.setLook((Widget)this.wBrowser);
        FormData fdBrowser = new FormData();
        fdBrowser.left = new FormAttachment(0, 0);
        fdBrowser.right = new FormAttachment(100, 0);
        fdBrowser.top = new FormAttachment(0, 0);
        fdBrowser.bottom = new FormAttachment(100, 0);
        this.wBrowser.setLayoutData((Object)fdBrowser);
        this.wBrowser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                HtmlExplorerFileTypeHandler.this.updateTitleFromPageTitle();
            }
        });
        this.reload();
    }

    public void save() throws HopException {
        try {
            String filename = this.explorerFile.getFilename();
            boolean fileExist = HopVfs.fileExists((String)filename);
            if (this.originalHtmlContent != null) {
                try (OutputStream outputStream = HopVfs.getOutputStream((String)filename, (boolean)false);){
                    outputStream.write(this.originalHtmlContent.getBytes(StandardCharsets.UTF_8));
                    outputStream.flush();
                }
            } else {
                throw new HopException("No HTML content to save");
            }
            this.clearChanged();
            this.updateGui();
            if (!fileExist) {
                this.perspective.refresh();
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to save HTML file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
        }
    }

    public void saveAs(String filename) throws HopException {
        try {
            FileObject fileObject;
            if (!((String)filename).toLowerCase().endsWith(".html") && !((String)filename).toLowerCase().endsWith(".htm")) {
                filename = (String)filename + ".html";
            }
            if ((fileObject = HopVfs.getFileObject((String)(filename = HopVfs.normalize((String)filename)))).exists()) {
                MessageBox box = new MessageBox(this.hopGui.getActiveShell(), 196);
                box.setText("Overwrite?");
                box.setMessage("Are you sure you want to overwrite file '" + (String)filename + "'?");
                int answer = box.open();
                if ((answer & 0x40) == 0) {
                    return;
                }
            }
            this.setFilename((String)filename);
            this.save();
            this.hopGui.fileRefreshDelegate.register((String)filename, (IHopFileTypeHandler)this);
        }
        catch (Exception e) {
            throw new HopException("Error validating file existence for '" + (String)filename + "'", (Throwable)e);
        }
    }

    public void reload() {
        try {
            String filename = this.explorerFile.getFilename();
            if (filename.toLowerCase().startsWith("http://") || filename.toLowerCase().startsWith("https://")) {
                this.wBrowser.setUrl(filename);
                this.updateTitleFromPageTitle();
                this.clearChanged();
                return;
            }
            String htmlContent = this.readTextFileContent("UTF-8");
            this.originalHtmlContent = Const.NVL((String)htmlContent, (String)"");
            this.wBrowser.setText(this.originalHtmlContent);
            this.clearChanged();
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error reading contents of HTML file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
            this.wBrowser.setText("<html><body><h1>Error loading HTML file</h1><p>" + Const.NVL((String)e.getMessage(), (String)"Unknown error") + "</p></body></html>");
        }
    }

    public void selectAll() {
    }

    public void unselectAll() {
    }

    public void copySelectedToClipboard() {
    }

    private void updateTitleFromPageTitle() {
        if (this.wBrowser == null || this.wBrowser.isDisposed()) {
            return;
        }
        this.hopGui.getDisplay().timerExec(500, () -> {
            if (this.wBrowser == null || this.wBrowser.isDisposed()) {
                return;
            }
            try {
                String pageTitle;
                Object result = this.wBrowser.evaluate("return document.title;");
                if (result != null && (pageTitle = result.toString()) != null && !pageTitle.isEmpty() && !pageTitle.equals("null")) {
                    Object shortTitle = pageTitle;
                    if (((String)shortTitle).length() > 30) {
                        shortTitle = ((String)shortTitle).substring(0, 27) + "...";
                    }
                    if (!((String)shortTitle).equals(this.explorerFile.getName())) {
                        this.explorerFile.setName((String)shortTitle);
                        this.perspective.updateTabItem((IHopFileTypeHandler)this);
                    }
                }
            }
            catch (Exception e) {
                LogChannel.UI.logDebug("Could not extract page title for tab: " + e.getMessage());
            }
        });
    }
}

