/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.server.HttpUtil;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;
import org.owasp.encoder.Encode;

@HopServerServlet(id="pipelineStatus", name="Get the status of a pipeline")
public class GetPipelineStatusServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = GetPipelineStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/pipelineStatus";
    private static final String CONST_HREF = "<a target=\"_blank\" href=\"";
    private static final String CONST_NAME = "?name=";
    private static final String CONST_TD = "</td>";
    private static final String CONST_TABLE_HEADER = "</th> <th class=\"cellTableHeader\">";
    private static final String CONST_DIV = "</div>";
    private static final String CONST_TABLE_CELL = "<td class=\"cellTableCell ";
    private static final String CONST_CLOSETAG = "\">";
    private static final String CONST_ID = "&id=";
    public static final String SEND_RESULT = "sendResult";
    private static final byte[] XML_HEADER = XmlHandler.getXmlHeader((String)"UTF-8").getBytes(StandardCharsets.UTF_8);

    public GetPipelineStatusServlet() {
    }

    public GetPipelineStatusServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IPipelineEngine<PipelineMeta> pipeline;
        HopServerObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.PipelineStatusRequested", (String[])new String[0]));
        }
        String pipelineName = request.getParameter("name");
        String id = request.getParameter("id");
        String root = request.getRequestURI() == null ? "/hop" : request.getRequestURI().substring(0, request.getRequestURI().indexOf(CONTEXT_PATH));
        Object prefix = this.isJettyMode() ? "/static" : root + "/content/common-ui/resources/themes";
        boolean useXml = "Y".equalsIgnoreCase(request.getParameter("xml"));
        boolean useJson = "Y".equalsIgnoreCase(request.getParameter("json"));
        int startLineNr = Const.toInt((String)request.getParameter("from"), (int)0);
        response.setStatus(200);
        if (useXml) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        }
        if (useJson) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/html;charset=UTF-8");
        }
        if (Utils.isEmpty((CharSequence)id)) {
            entry = this.getPipelineMap().getFirstServerObjectEntry(pipelineName);
            if (entry == null) {
                pipeline = null;
            } else {
                id = entry.getId();
                pipeline = this.getPipelineMap().getPipeline(entry);
            }
        } else {
            entry = new HopServerObjectEntry(pipelineName, id);
            pipeline = this.getPipelineMap().getPipeline(entry);
        }
        if (pipeline != null) {
            if (useXml || useJson) {
                try {
                    boolean sendResultXmlWithStatus = "Y".equalsIgnoreCase(request.getParameter(SEND_RESULT));
                    int lastLineNr = HopLogStore.getLastBufferLineNr();
                    String logText = this.getLogText(pipeline, startLineNr, lastLineNr);
                    HopServerPipelineStatus pipelineStatus = new HopServerPipelineStatus(pipelineName, entry.getId(), pipeline.getStatusDescription());
                    pipelineStatus.setFirstLoggingLineNr(startLineNr);
                    pipelineStatus.setLastLoggingLineNr(lastLineNr);
                    pipelineStatus.setLogDate(new Date());
                    pipelineStatus.setExecutionStartDate(pipeline.getExecutionStartDate());
                    pipelineStatus.setExecutionEndDate(pipeline.getExecutionEndDate());
                    for (IEngineComponent component : pipeline.getComponents()) {
                        if (!component.isRunning() && component.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_EMPTY) continue;
                        TransformStatus transformStatus = new TransformStatus(component);
                        pipelineStatus.getTransformStatusList().add(transformStatus);
                    }
                    String loggingString = HttpUtil.encodeBase64ZippedString((String)logText);
                    pipelineStatus.setLoggingString(loggingString);
                    pipelineStatus.setResult(pipeline.getResult());
                    pipelineStatus.setPaused(pipeline.isPaused());
                    ServletOutputStream out = response.getOutputStream();
                    if (useXml) {
                        String xml = pipelineStatus.getXml(sendResultXmlWithStatus);
                        byte[] data = xml.getBytes(StandardCharsets.UTF_8);
                        response.setContentLength(XML_HEADER.length + data.length);
                        out.write(XML_HEADER);
                        out.write(data);
                    } else {
                        ObjectMapper mapper = HopJson.newMapper();
                        String jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)pipelineStatus);
                        byte[] data = jsonString.getBytes(StandardCharsets.UTF_8);
                        response.setContentLength(data.length);
                        out.write(data);
                    }
                    out.flush();
                    response.flushBuffer();
                }
                catch (HopException e) {
                    throw new ServletException("Unable to get the pipeline status in XML or JSON format", (Throwable)e);
                }
            }
            PrintWriter out = response.getWriter();
            int lastLineNr = HopLogStore.getLastBufferLineNr();
            int tableBorder = 0;
            response.setContentType("text/html;charset=UTF-8");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.HopPipelineStatus", (String[])new String[0]) + "</TITLE>");
            if (EnvUtil.getSystemProperty((String)"HOP_SERVER_REFRESH_STATUS", (String)"N").equalsIgnoreCase("Y")) {
                out.println("<META http-equiv=\"Refresh\" content=\"10;url=" + this.convertContextPath(CONTEXT_PATH) + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + CONST_ID + URLEncoder.encode(id, StandardCharsets.UTF_8) + CONST_CLOSETAG);
            }
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("<link rel=\"icon\" type=\"image/svg+xml\" href=\"/static/images/favicon.svg\">");
            if (this.isJettyMode()) {
                out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/css/hop-server.css\" />");
            }
            out.println("</HEAD>");
            out.println("<BODY style=\"overflow: auto;\">");
            out.println("<div class=\"row\" id=\"pucHeader\">");
            out.println("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 10px;\">" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"PipelineStatusServlet.TopPipelineStatus", (String[])new String[]{pipelineName})) + CONST_DIV);
            out.println(CONST_DIV);
            try {
                out.println("<div class=\"row\" style=\"padding: 0px 0px 0px 30px\">");
                out.println("<div class=\"row\" style=\"padding-top: 30px;\">");
                out.print("<a href=\"" + this.convertContextPath("/hop/status") + CONST_CLOSETAG);
                out.print("<img src=\"" + (String)prefix + "/images/back.svg\" style=\"margin-right: 5px; width: 16px; height: 16px; vertical-align: middle;\">");
                out.print(BaseMessages.getString(PKG, (String)"HopServerStatusServlet.BackToHopServerStatus", (String[])new String[0]) + "</a>");
                out.println(CONST_DIV);
                out.println("<div class=\"row\" style=\"padding: 30px 0px 75px 0px; display: table;\">");
                out.println("<div style=\"display: table-row;\">");
                out.println("<div style=\"padding: 0px 30px 0px 0px; width: 60px; display: table-cell; vertical-align: top;\">");
                out.println("<img src=\"" + (String)prefix + "/images/pipeline.svg\" style=\"width: 60px; height: 60px;\"></img>");
                out.println(CONST_DIV);
                out.println("<div style=\"vertical-align: top; display: table-cell;\">");
                out.println("<table style=\"border-collapse: collapse;\" border=\"" + tableBorder + CONST_CLOSETAG);
                out.print("<tr class=\"cellTableRow\" style=\"border: solid; border-width: 1px 0; border-top: none; border-color: #E3E3E3; font-size: 12; text-align: left;\"> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.ServerObjectId", (String[])new String[0]) + "</th> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.PipelineStatus", (String[])new String[0]) + "</th> <th style=\"font-weight: normal; padding: 8px 10px 10px 10px\" class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.StartDate", (String[])new String[0]) + "</th> </tr>");
                out.print("<tr class=\"cellTableRow\" style=\"border: solid; border-width: 1px 0; border-bottom: none; font-size: 12; text-align: left;\">");
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell cellTableFirstColumn\">" + Encode.forHtml((String)id) + CONST_TD);
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell\" id=\"statusColor\" style=\"font-weight: bold;\">" + Encode.forHtml((String)pipeline.getStatusDescription()) + CONST_TD);
                String dateStr = XmlHandler.date2string((Date)pipeline.getExecutionStartDate());
                out.print("<td style=\"padding: 8px 10px 10px 10px\" class=\"cellTableCell cellTableLastColumn\">" + (dateStr != null ? dateStr.substring(0, dateStr.indexOf(32)) : "-") + CONST_TD);
                out.print("</tr>");
                out.print("</table>");
                out.print(CONST_DIV);
                out.println("<div style=\"padding: 0px 0px 0px 20px; width: 90px; display: table-cell; vertical-align: top;\">");
                out.print("<div style=\"display: block; margin-left: auto; margin-right: auto; padding: 5px 0px;\">");
                out.print(CONST_HREF + this.convertContextPath(CONTEXT_PATH) + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + CONST_ID + URLEncoder.encode(id, StandardCharsets.UTF_8) + "&xml=y\"><img src=\"" + (String)prefix + "/images/download.svg\" style=\"display: block; margin: auto; width: 22px; height: 22px;\"></a>");
                out.print(CONST_DIV);
                out.println("<div style=\"text-align: center; padding-top: 12px; font-size: 12px;\">");
                out.print(CONST_HREF + this.convertContextPath(CONTEXT_PATH) + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + CONST_ID + URLEncoder.encode(id, StandardCharsets.UTF_8) + "&xml=y\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.ShowAsXml", (String[])new String[0]) + "</a>");
                out.print(CONST_DIV);
                out.print(CONST_DIV);
                out.println("<div style=\"padding: 0px 0px 0px 20px; width: 90px; display: table-cell; vertical-align: top;\">");
                out.print("<div style=\"display: block; margin-left: auto; margin-right: auto; padding: 5px 0px;\">");
                out.print(CONST_HREF + this.convertContextPath(CONTEXT_PATH) + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + CONST_ID + URLEncoder.encode(id, StandardCharsets.UTF_8) + "&json=y\"><img src=\"" + (String)prefix + "/images/download.svg\" style=\"display: block; margin: auto; width: 22px; height: 22px;\"></a>");
                out.print(CONST_DIV);
                out.println("<div style=\"text-align: center; padding-top: 12px; font-size: 12px;\">");
                out.print(CONST_HREF + this.convertContextPath(CONTEXT_PATH) + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + CONST_ID + URLEncoder.encode(id, StandardCharsets.UTF_8) + "&json=y\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.ShowAsJson", (String[])new String[0]) + "</a>");
                out.print(CONST_DIV);
                out.print(CONST_DIV);
                out.print(CONST_DIV);
                out.print(CONST_DIV);
                out.print(CONST_DIV);
                out.print("<div class=\"row\" style=\"padding: 0px 0px 75px 0px;\">");
                out.print("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 30px 0px;\">Transform detail</div>");
                out.println("<table class=\"hop-table\" border=\"" + tableBorder + CONST_CLOSETAG);
                out.print("<tr class=\"cellTableRow\"> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.TransformName", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.CopyNr", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Read", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Written", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Input", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Output", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Updated", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Rejected", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Errors", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Active", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Time", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Speed", (String[])new String[0]) + CONST_TABLE_HEADER + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.prinout", (String[])new String[0]) + "</th> </tr>");
                boolean evenRow = true;
                for (IEngineComponent component : pipeline.getComponents()) {
                    if (!component.isRunning() && component.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_EMPTY) continue;
                    TransformStatus transformStatus = new TransformStatus(component);
                    boolean snif = false;
                    Object htmlString = "";
                    if (component.isRunning() && !component.isStopped() && !component.isPaused()) {
                        snif = true;
                        String sniffLink = " <a href=\"" + this.convertContextPath("/hop/sniffTransform") + "?pipeline=" + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + CONST_ID + URLEncoder.encode(id, StandardCharsets.UTF_8) + "&lines=50&copynr=" + component.getCopyNr() + "&type=output&transform=" + URLEncoder.encode(component.getName(), StandardCharsets.UTF_8) + CONST_CLOSETAG + Encode.forHtml((String)transformStatus.getTransformName()) + "</a>";
                        transformStatus.setTransformName(sniffLink);
                    }
                    String rowClass = evenRow ? "cellTableEvenRow" : "cellTableOddRow";
                    String cellClass = evenRow ? "cellTableEvenRowCell" : "cellTableOddRowCell";
                    htmlString = "<tr class=\"" + rowClass + "\"><td class=\"cellTableCell cellTableFirstColumn " + cellClass + CONST_CLOSETAG + transformStatus.getTransformName() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getCopy() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getLinesRead() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getLinesWritten() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getLinesInput() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getLinesOutput() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getLinesUpdated() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getLinesRejected() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getErrors() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getStatusDescription() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getSeconds() + "</td><td class=\"cellTableCell " + cellClass + CONST_CLOSETAG + transformStatus.getSpeed() + "</td><td class=\"cellTableCell cellTableLastColumn " + cellClass + CONST_CLOSETAG + transformStatus.getPriority() + "</td></tr>";
                    evenRow = !evenRow;
                    out.print((String)htmlString);
                }
                out.println("</table>");
                out.println(CONST_DIV);
                if (this.supportGraphicEnvironment) {
                    out.print("<div class=\"row\" style=\"padding: 0px 0px 75px 0px;\">");
                    out.print("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 30px 0px;\">Canvas preview</div>");
                    Point max = pipeline.getPipelineMeta().getMaximum();
                    max.x = (int)((float)max.x * 1.0f) + 100;
                    max.y = (int)((float)max.y * 1.0f) + 50;
                    out.print("<iframe height=\"" + (max.y + 100) + "px\" width=\"" + (max.x + 100) + "px\" src=\"" + this.convertContextPath("/hop/pipelineImage") + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + CONST_ID + URLEncoder.encode(id, StandardCharsets.UTF_8) + "\" frameborder=\"0\"></iframe>");
                    out.print(CONST_DIV);
                }
                out.print("<div class=\"row\" style=\"padding: 0px 0px 30px 0px;\">");
                out.print("<div class=\"workspaceHeading\" style=\"padding: 0px 0px 30px 0px;\">Pipeline log</div>");
                out.println("<textarea id=\"pipelinelog\" cols=\"120\" rows=\"20\" wrap=\"off\" name=\"Pipeline log\" readonly=\"readonly\" style=\"height: auto; width: 100%;\">" + Encode.forHtml((String)this.getLogText(pipeline, startLineNr, lastLineNr)) + "</textarea>");
                out.print(CONST_DIV);
                out.println("<script type=\"text/javascript\">");
                out.println("element = document.getElementById( 'statusColor' );");
                out.println("if( element.innerHTML == 'Running' || element.innerHTML == 'Finished' ){");
                out.println("element.style.color = '#009900';");
                out.println("} else if( element.innerHTML == 'Stopped' ) {");
                out.println("element.style.color = '#7C0B2B';");
                out.println("} else {");
                out.println("element.style.color = '#F1C40F';");
                out.println("}");
                out.println("</script>");
                out.println("<script type=\"text/javascript\"> ");
                out.println("  pipelinelog.scrollTop=pipelinelog.scrollHeight; ");
                out.println("</script> ");
            }
            catch (Exception ex) {
                out.println("<pre>");
                out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
            }
            out.println(CONST_DIV);
            out.println("</BODY>");
            out.println("</HTML>");
        } else {
            PrintWriter out = response.getWriter();
            if (useXml) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.CoundNotFindSpecPipeline", (String[])new String[]{pipelineName})));
            } else {
                out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.CoundNotFindPipeline", (String[])new String[]{pipelineName})) + "</H1>");
                out.println("<a href=\"" + this.convertContextPath("/hop/status") + CONST_CLOSETAG + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            }
        }
    }

    public String toString() {
        return "Pipeline Status IHandler";
    }

    @Override
    public String getService() {
        return "/hop/pipelineStatus (" + String.valueOf(this) + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    private String getLogText(IPipelineEngine pipeline, int startLineNr, int lastLineNr) throws HopException {
        try {
            return HopLogStore.getAppender().getBuffer(pipeline.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
        }
        catch (OutOfMemoryError error) {
            throw new HopException("Log string is too long", (Throwable)error);
        }
    }
}

