/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.start;

import java.util.Calendar;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopWorkflowException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="SPECIAL", image="org/apache/hop/images/start.svg", name="i18n::ActionStart.Name", description="i18n::ActionStart.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::ActionStart.keyword"}, documentationUrl="/workflow/actions/start.html")
public class ActionStart
extends ActionBase
implements Cloneable,
IAction {
    public static final String ID = "SPECIAL";
    public static final int NOSCHEDULING = 0;
    public static final int INTERVAL = 1;
    public static final int DAILY = 2;
    public static final int WEEKLY = 3;
    public static final int MONTHLY = 4;
    public static final String STRING_START_REPEAT_LOOP = "START_REPEAT_LOOP";
    @HopMetadataProperty
    private boolean repeat = false;
    @HopMetadataProperty
    private int schedulerType = 0;
    @HopMetadataProperty
    private String intervalSeconds = "0";
    @HopMetadataProperty
    private String intervalMinutes = "60";
    @HopMetadataProperty(key="DayOfMonth")
    private String dayOfMonth = "1";
    @HopMetadataProperty
    private String weekDay = "1";
    @HopMetadataProperty
    private String minutes = "0";
    @HopMetadataProperty
    private String hour = "12";
    @HopMetadataProperty
    private boolean doNotWaitOnFirstExecution;

    public ActionStart() {
        this((String)null);
    }

    public ActionStart(String name) {
        super(name, "");
    }

    @Override
    public ActionStart clone() {
        return (ActionStart)super.clone();
    }

    @Override
    public Result execute(Result previousResult, int nr) throws HopWorkflowException {
        try {
            boolean firstExecution = this.isFirstRepeatExecution();
            long sleepTime = this.getNextExecutionTime(firstExecution);
            if (sleepTime > 0L) {
                this.parentWorkflow.getLogChannel().logBasic(this.parentWorkflow.getWorkflowName(), new Object[]{"Sleeping: " + sleepTime / 1000L / 60L + " minutes (sleep time=" + sleepTime + ")"});
                for (long totalSleep = 0L; totalSleep < sleepTime && !this.parentWorkflow.isStopped(); totalSleep += 1000L) {
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException e) {
            throw new HopWorkflowException((Throwable)e);
        }
        previousResult.setResult(true);
        return previousResult;
    }

    private boolean isFirstRepeatExecution() {
        return this.parentWorkflow.getExtensionDataMap().get(STRING_START_REPEAT_LOOP) == null;
    }

    private long getNextExecutionTime(boolean firstExecution) {
        if (!this.isRepeat()) {
            return 0L;
        }
        this.parentWorkflow.getExtensionDataMap().put(STRING_START_REPEAT_LOOP, "NOT_FIRST");
        if (this.isDoNotWaitOnFirstExecution() && firstExecution) {
            return 0L;
        }
        return switch (this.schedulerType) {
            case 0 -> 0L;
            case 1 -> this.getNextIntervalExecutionTime();
            case 2 -> this.getNextDailyExecutionTime();
            case 3 -> this.getNextWeeklyExecutionTime();
            case 4 -> this.getNextMonthlyExecutionTime();
            default -> 0L;
        };
    }

    private long getNextIntervalExecutionTime() {
        int interval = Const.toInt((String)this.resolve(this.intervalSeconds), (int)0) * 1000;
        return interval += Const.toInt((String)this.resolve(this.intervalMinutes), (int)-1) * 1000 * 60;
    }

    private long getNextMonthlyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = Const.toInt((String)this.resolve(this.hour), (int)0);
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, Const.toInt((String)this.resolve(this.minutes), (int)0));
        calendar.set(5, Const.toInt((String)this.resolve(this.dayOfMonth), (int)1));
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(2, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    private long getNextWeeklyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = Const.toInt((String)this.resolve(this.hour), (int)0);
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, Const.toInt((String)this.resolve(this.minutes), (int)0));
        calendar.set(7, Const.toInt((String)this.resolve(this.weekDay), (int)0) + 1);
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(3, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    private long getNextDailyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = Const.toInt((String)this.resolve(this.hour), (int)0);
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, Const.toInt((String)this.resolve(this.minutes), (int)0));
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(5, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    public boolean evaluates() {
        return false;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public boolean isStart() {
        return true;
    }

    @Override
    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
    }

    @Generated
    public boolean isRepeat() {
        return this.repeat;
    }

    @Generated
    public int getSchedulerType() {
        return this.schedulerType;
    }

    @Generated
    public String getIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Generated
    public String getIntervalMinutes() {
        return this.intervalMinutes;
    }

    @Generated
    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Generated
    public String getWeekDay() {
        return this.weekDay;
    }

    @Generated
    public String getMinutes() {
        return this.minutes;
    }

    @Generated
    public String getHour() {
        return this.hour;
    }

    @Generated
    public boolean isDoNotWaitOnFirstExecution() {
        return this.doNotWaitOnFirstExecution;
    }

    @Generated
    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    @Generated
    public void setSchedulerType(int schedulerType) {
        this.schedulerType = schedulerType;
    }

    @Generated
    public void setIntervalSeconds(String intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    @Generated
    public void setIntervalMinutes(String intervalMinutes) {
        this.intervalMinutes = intervalMinutes;
    }

    @Generated
    public void setDayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    @Generated
    public void setWeekDay(String weekDay) {
        this.weekDay = weekDay;
    }

    @Generated
    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    @Generated
    public void setHour(String hour) {
        this.hour = hour;
    }

    @Generated
    public void setDoNotWaitOnFirstExecution(boolean doNotWaitOnFirstExecution) {
        this.doNotWaitOnFirstExecution = doNotWaitOnFirstExecution;
    }
}

