/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.HopVersionProvider;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.encryption.HopTwoWayPasswordEncoder;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.ISearchablesLocation;
import org.apache.hop.core.search.SearchQuery;
import org.apache.hop.core.search.SearchableAnalyserPluginType;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.hop.Hop;
import org.apache.hop.hop.plugin.HopCommand;
import org.apache.hop.hop.plugin.IHopCommand;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=HopVersionProvider.class, description={"Search in Hop metadata"}, mixinStandardHelpOptions=true)
@HopCommand(id="search", description="Search in Hop metadata")
public class HopSearch
implements Runnable,
IHasHopMetadataProvider,
IHopCommand {
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information and exit"})
    private boolean versionRequested;
    @CommandLine.Parameters(description={"The string to search for"})
    private String searchString;
    @CommandLine.Option(names={"-i", "--case-insensitive"}, description={"Perform a case insensitive search"})
    private Boolean caseInsensitive;
    @CommandLine.Option(names={"-x", "--regular-expression"}, description={"The specified search string is a regular expression"})
    private Boolean regularExpression;
    @CommandLine.Option(names={"-l", "--print-locations"}, description={"Print which locations are being looked at"})
    private Boolean printLocations;
    private CommandLine cmd;
    private IVariables variables;
    private MultiMetadataProvider metadataProvider;
    protected List<ISearchablesLocation> searchablesLocations = new ArrayList<ISearchablesLocation>();

    @Override
    public void initialize(CommandLine cmd, IVariables variables, MultiMetadataProvider metadataProvider) throws HopException {
        this.cmd = cmd;
        this.variables = variables;
        this.metadataProvider = metadataProvider;
        HopSearch.registerSearchPluginType();
        Hop.addMixinPlugins(cmd, "search");
    }

    @Override
    public void run() {
        try {
            System.setProperty("HOP_PLATFORM_RUNTIME", "SEARCH");
            LogChannel logChannel = new LogChannel((Object)"hop-search");
            logChannel.setSimplified(true);
            LogChannel log = logChannel;
            this.variables = Variables.getADefaultVariableSpace();
            this.buildMetadataProvider();
            boolean actionTaken = false;
            Map mixins = this.cmd.getMixins();
            for (String key : mixins.keySet()) {
                Object mixin = mixins.get(key);
                if (!(mixin instanceof IConfigOptions)) continue;
                IConfigOptions configOptions = (IConfigOptions)mixin;
                actionTaken = configOptions.handleOption((ILogChannel)log, (IHasHopMetadataProvider)this, this.variables) || actionTaken;
            }
            if (!actionTaken || StringUtils.isEmpty((String)this.searchString)) {
                this.cmd.usage(System.out);
                System.exit(1);
            }
            if (this.searchablesLocations.isEmpty()) {
                System.out.println("There were no locations found to search. Specify an option so that Hop knows where to look.");
                System.exit(3);
            }
            boolean isCaseSensitive = this.caseInsensitive == null || this.caseInsensitive == false;
            boolean isRegularExpression = this.regularExpression != null && this.regularExpression != false;
            SearchQuery searchQuery = new SearchQuery(this.searchString, isCaseSensitive, isRegularExpression);
            System.out.println("Searching for [" + this.searchString + "]  Case sensitive? " + isCaseSensitive + "  Regular expression? " + isRegularExpression);
            HashMap<Class, ISearchableAnalyser> searchableAnalyserMap = new HashMap<Class, ISearchableAnalyser>();
            PluginRegistry registry = PluginRegistry.getInstance();
            for (IPlugin analyserPlugin : registry.getPlugins(SearchableAnalyserPluginType.class)) {
                ISearchableAnalyser searchableAnalyser = (ISearchableAnalyser)registry.loadClass(analyserPlugin);
                searchableAnalyserMap.put(searchableAnalyser.getSearchableClass(), searchableAnalyser);
            }
            for (ISearchablesLocation searchablesLocation : this.searchablesLocations) {
                System.out.println("Searching in location : " + searchablesLocation.getLocationDescription());
                System.out.println("-----------------------------------------------------------------------------------");
                Iterator iterator = searchablesLocation.getSearchables((IHopMetadataProvider)this.metadataProvider, this.variables);
                while (iterator.hasNext()) {
                    ISearchableAnalyser searchableAnalyser;
                    ISearchable searchable = (ISearchable)iterator.next();
                    Object object = searchable.getSearchableObject();
                    if (object == null) continue;
                    if (this.printLocations != null && this.printLocations.booleanValue()) {
                        System.out.println("Checking searchable: " + searchable.getName());
                    }
                    if ((searchableAnalyser = (ISearchableAnalyser)searchableAnalyserMap.get(object.getClass())) == null) continue;
                    List searchResults = searchableAnalyser.search(searchable, (ISearchQuery)searchQuery);
                    for (ISearchResult searchResult : searchResults) {
                        String filename = this.variables.resolve(searchResult.getMatchingSearchable().getFilename());
                        if (StringUtils.isNotEmpty((String)filename)) {
                            System.out.print(filename + " : ");
                        }
                        System.out.print(searchResult.getComponent() + "(" + Const.NVL((String)searchResult.getValue(), (String)"") + ") : " + searchResult.getDescription());
                        System.out.println();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(this.cmd, "There was an error handling options", (Throwable)e);
        }
    }

    private void buildMetadataProvider() throws HopException {
        ArrayList<JsonMetadataProvider> providers = new ArrayList<JsonMetadataProvider>();
        String folder = this.variables.getVariable("HOP_METADATA_FOLDER");
        if (StringUtils.isEmpty((String)folder)) {
            providers.add(new JsonMetadataProvider());
        } else {
            ITwoWayPasswordEncoder passwordEncoder = Encr.getEncoder();
            if (passwordEncoder == null) {
                passwordEncoder = new HopTwoWayPasswordEncoder();
            }
            providers.add(new JsonMetadataProvider(passwordEncoder, folder, this.variables));
        }
        this.metadataProvider = new MultiMetadataProvider(Encr.getEncoder(), providers, this.variables);
    }

    public static void main(String[] args) {
        HopSearch hopSearch = new HopSearch();
        try {
            HopEnvironment.init();
            HopSearch.registerSearchPluginType();
            hopSearch.cmd = new CommandLine((Object)hopSearch);
            Hop.addMixinPlugins(hopSearch.cmd, "search");
            hopSearch.setCmd(hopSearch.cmd);
            CommandLine.ParseResult parseResult = hopSearch.cmd.parseArgs(args);
            if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                System.exit(1);
            } else {
                hopSearch.run();
                System.exit(0);
            }
        }
        catch (CommandLine.ParameterException e) {
            System.err.println(e.getMessage());
            hopSearch.cmd.usage(System.err);
            System.exit(9);
        }
        catch (CommandLine.ExecutionException e) {
            System.err.println("Error found during execution!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("General error found, something went horribly wrong!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(2);
        }
    }

    private static void registerSearchPluginType() throws HopPluginException {
        SearchableAnalyserPluginType searchableAnalyserPluginType = SearchableAnalyserPluginType.getInstance();
        PluginRegistry.addPluginType((IPluginType)searchableAnalyserPluginType);
        searchableAnalyserPluginType.searchPlugins();
    }

    @Generated
    public boolean isVersionRequested() {
        return this.versionRequested;
    }

    @Generated
    public String getSearchString() {
        return this.searchString;
    }

    @Generated
    public Boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Generated
    public Boolean getRegularExpression() {
        return this.regularExpression;
    }

    @Generated
    public Boolean getPrintLocations() {
        return this.printLocations;
    }

    @Generated
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public List<ISearchablesLocation> getSearchablesLocations() {
        return this.searchablesLocations;
    }

    @Generated
    public void setVersionRequested(boolean versionRequested) {
        this.versionRequested = versionRequested;
    }

    @Generated
    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    @Generated
    public void setCaseInsensitive(Boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Generated
    public void setRegularExpression(Boolean regularExpression) {
        this.regularExpression = regularExpression;
    }

    @Generated
    public void setPrintLocations(Boolean printLocations) {
        this.printLocations = printLocations;
    }

    @Generated
    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Generated
    public void setSearchablesLocations(List<ISearchablesLocation> searchablesLocations) {
        this.searchablesLocations = searchablesLocations;
    }
}

