/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.svg.HopSvgGraphics2D;
import org.apache.hop.core.svg.SvgCache;
import org.apache.hop.core.svg.SvgCacheEntry;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

public class SvgGc
implements IGc {
    private static final String CONST_FREESANS = "FreeSans";
    private static SvgFile imageLocked;
    private static SvgFile imageFailure;
    private static SvgFile imageEdit;
    private static SvgFile imageContextMenu;
    private static SvgFile imageTrue;
    private static SvgFile imageTrueDisabled;
    private static SvgFile imageFalse;
    private static SvgFile imageFalseDisabled;
    private static SvgFile imageError;
    private static SvgFile imageErrorDisabled;
    private static SvgFile imageInfo;
    private static SvgFile imageInfoDisabled;
    private static SvgFile imageTarget;
    private static SvgFile imageTargetDisabled;
    private static SvgFile imageInput;
    private static SvgFile imageOutput;
    private static SvgFile imageArrow;
    private static SvgFile imageCopyRows;
    private static SvgFile imageCopyRowsDisabled;
    private static SvgFile imageLoadBalance;
    private static SvgFile imageCheckpoint;
    private static SvgFile imageDatabase;
    private static SvgFile imageParallel;
    private static SvgFile imageParallelDisabled;
    private static SvgFile imageUnconditional;
    private static SvgFile imageUnconditionalDisabled;
    private static SvgFile imageBusy;
    private static SvgFile imageWaiting;
    private static SvgFile imageMissing;
    private static SvgFile imageDeprecated;
    private static SvgFile imageInject;
    private static SvgFile imageData;
    private static SvgFile imageArrowDefault;
    private static SvgFile imageArrowTrue;
    private static SvgFile imageArrowFalse;
    private static SvgFile imageArrowError;
    private static SvgFile imageArrowDisabled;
    protected Color background;
    protected Color black;
    protected Color red;
    protected Color yellow;
    protected Color green;
    protected Color blue;
    protected Color magenta;
    protected Color purpule;
    protected Color indigo;
    protected Color gray;
    protected Color lightGray;
    protected Color darkGray;
    protected Color lightBlue;
    protected Color crystal;
    protected Color hopDefault;
    protected Color hopTrue;
    protected Color hopFalse;
    protected Color deprecated;
    private final HopSvgGraphics2D gc;
    private final int iconSize;
    private final int miniIconSize;
    private final Map<String, SvgFile> transformImages;
    private final Map<String, SvgFile> actionImages;
    private final Point area;
    private int alpha;
    private Font fontGraph;
    private Font fontNote;
    private Font fontSmall;
    private int lineWidth;
    private IGc.ELineStyle lineStyle;
    private final int yOffset;
    private final int xOffset;
    private final AffineTransform originalTransform;

    public SvgGc(HopSvgGraphics2D gc, Point area, int iconSize, int xOffset, int yOffset) throws HopException {
        this.gc = gc;
        this.transformImages = this.getTransformImageFilenames();
        this.actionImages = this.getActionImageFilenames();
        this.iconSize = iconSize;
        this.miniIconSize = iconSize / 2;
        this.area = area;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.originalTransform = this.gc.getTransform();
        gc.setSVGCanvasSize(new Dimension(area.x, area.y));
        this.init();
    }

    private Map<String, SvgFile> getTransformImageFilenames() throws HopPluginException {
        HashMap<String, SvgFile> map = new HashMap<String, SvgFile>();
        PluginRegistry registry = PluginRegistry.getInstance();
        for (IPlugin plugin : registry.getPlugins(TransformPluginType.class)) {
            for (String id : plugin.getIds()) {
                map.put(id, new SvgFile(plugin.getImageFile(), registry.getClassLoader(plugin)));
            }
        }
        return map;
    }

    private Map<String, SvgFile> getActionImageFilenames() throws HopPluginException {
        HashMap<String, SvgFile> map = new HashMap<String, SvgFile>();
        PluginRegistry registry = PluginRegistry.getInstance();
        for (IPlugin plugin : registry.getPlugins(ActionPluginType.class)) {
            for (String id : plugin.getIds()) {
                map.put(id, new SvgFile(plugin.getImageFile(), registry.getClassLoader(plugin)));
            }
        }
        return map;
    }

    private void init() {
        this.lineStyle = IGc.ELineStyle.SOLID;
        this.lineWidth = 1;
        this.alpha = 255;
        this.background = new Color(255, 255, 255);
        this.black = new Color(0, 0, 0);
        this.red = new Color(255, 0, 0);
        this.yellow = new Color(255, 255, 0);
        this.green = new Color(0, 255, 0);
        this.blue = new Color(0, 0, 255);
        this.magenta = new Color(255, 0, 255);
        this.purpule = new Color(128, 0, 128);
        this.indigo = new Color(75, 0, 130);
        this.gray = new Color(215, 215, 215);
        this.lightGray = new Color(225, 225, 225);
        this.darkGray = new Color(100, 100, 100);
        this.lightBlue = new Color(135, 206, 250);
        this.crystal = new Color(61, 99, 128);
        this.hopDefault = new Color(61, 99, 128);
        this.hopTrue = new Color(12, 178, 15);
        this.hopFalse = new Color(255, 165, 0);
        this.deprecated = new Color(246, 196, 56);
        imageLocked = new SvgFile("ui/images/lock.svg", this.getClass().getClassLoader());
        imageFailure = new SvgFile("ui/images/failure.svg", this.getClass().getClassLoader());
        imageEdit = new SvgFile("ui/images/edit.svg", this.getClass().getClassLoader());
        imageContextMenu = new SvgFile("ui/images/settings.svg", this.getClass().getClassLoader());
        imageTrue = new SvgFile("ui/images/true.svg", this.getClass().getClassLoader());
        imageTrueDisabled = new SvgFile("ui/images/true-disabled.svg", this.getClass().getClassLoader());
        imageFalse = new SvgFile("ui/images/false.svg", this.getClass().getClassLoader());
        imageFalseDisabled = new SvgFile("ui/images/false-disabled.svg", this.getClass().getClassLoader());
        imageError = new SvgFile("ui/images/error.svg", this.getClass().getClassLoader());
        imageErrorDisabled = new SvgFile("ui/images/error-disabled.svg", this.getClass().getClassLoader());
        imageInfo = new SvgFile("ui/images/info.svg", this.getClass().getClassLoader());
        imageInfoDisabled = new SvgFile("ui/images/info-disabled.svg", this.getClass().getClassLoader());
        imageTarget = new SvgFile("ui/images/target.svg", this.getClass().getClassLoader());
        imageTargetDisabled = new SvgFile("ui/images/target-disabled.svg", this.getClass().getClassLoader());
        imageInput = new SvgFile("ui/images/input.svg", this.getClass().getClassLoader());
        imageOutput = new SvgFile("ui/images/output.svg", this.getClass().getClassLoader());
        imageArrow = new SvgFile("ui/images/arrow.svg", this.getClass().getClassLoader());
        imageCopyRows = new SvgFile("ui/images/copy-rows.svg", this.getClass().getClassLoader());
        imageCopyRowsDisabled = new SvgFile("ui/images/copy-rows-disabled.svg", this.getClass().getClassLoader());
        imageLoadBalance = new SvgFile("ui/images/scales.svg", this.getClass().getClassLoader());
        imageCheckpoint = new SvgFile("ui/images/checkpoint.svg", this.getClass().getClassLoader());
        imageDatabase = new SvgFile("ui/images/database.svg", this.getClass().getClassLoader());
        imageParallel = new SvgFile("ui/images/parallel-hop.svg", this.getClass().getClassLoader());
        imageParallelDisabled = new SvgFile("ui/images/parallel-hop-disabled.svg", this.getClass().getClassLoader());
        imageUnconditional = new SvgFile("ui/images/unconditional.svg", this.getClass().getClassLoader());
        imageUnconditionalDisabled = new SvgFile("ui/images/unconditional-disabled.svg", this.getClass().getClassLoader());
        imageBusy = new SvgFile("ui/images/busy.svg", this.getClass().getClassLoader());
        imageWaiting = new SvgFile("ui/images/waiting.svg", this.getClass().getClassLoader());
        imageInject = new SvgFile("ui/images/inject.svg", this.getClass().getClassLoader());
        imageMissing = new SvgFile("ui/images/missing.svg", this.getClass().getClassLoader());
        imageDeprecated = new SvgFile("ui/images/deprecated.svg", this.getClass().getClassLoader());
        imageArrowDefault = new SvgFile("ui/images/hop-arrow-default.svg", this.getClass().getClassLoader());
        imageArrowFalse = new SvgFile("ui/images/hop-arrow-false.svg", this.getClass().getClassLoader());
        imageArrowTrue = new SvgFile("ui/images/hop-arrow-true.svg", this.getClass().getClassLoader());
        imageArrowError = new SvgFile("ui/images/hop-arrow-error.svg", this.getClass().getClassLoader());
        imageArrowDisabled = new SvgFile("ui/images/hop-arrow-disabled.svg", this.getClass().getClassLoader());
        this.fontGraph = new Font(CONST_FREESANS, 0, 10);
        this.fontNote = new Font(CONST_FREESANS, 0, 10);
        this.fontSmall = new Font(CONST_FREESANS, 0, 8);
        this.gc.setFont(this.fontGraph);
        this.gc.setColor(this.background);
        this.gc.fillRect(0, 0, this.area.x, this.area.y);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawLine(int x, int y, int x2, int y2) {
        this.gc.drawLine(x + this.xOffset, y + this.yOffset, x2 + this.xOffset, y2 + this.yOffset);
    }

    @Override
    public void drawPoint(int x, int y) {
        this.gc.drawLine(x + this.xOffset, y + this.yOffset, x + this.xOffset, y + this.yOffset);
    }

    @Override
    public void drawPolygon(int[] polygon) {
        this.gc.drawPolygon(this.getSwingPolygon(polygon));
    }

    private Polygon getSwingPolygon(int[] polygon) {
        int nPoints = polygon.length / 2;
        int[] xPoints = new int[polygon.length / 2];
        int[] yPoints = new int[polygon.length / 2];
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = polygon[2 * i] + this.xOffset;
            yPoints[i] = polygon[2 * i + 1] + this.yOffset;
        }
        return new Polygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolyline(int[] polyline) {
        int nPoints = polyline.length / 2;
        int[] xPoints = new int[polyline.length / 2];
        int[] yPoints = new int[polyline.length / 2];
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = polyline[2 * i] + this.xOffset;
            yPoints[i] = polyline[2 * i + 1] + this.yOffset;
        }
        this.gc.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRect(x + this.xOffset, y + this.yOffset, width, height);
    }

    @Override
    public void drawRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.gc.drawRoundRect(x + this.xOffset, y + this.yOffset, width, height, circleWidth, circleHeight);
    }

    @Override
    public void drawText(String text, int x, int y) {
        String[] lines;
        int height = this.gc.getFontMetrics().getHeight();
        int descent = this.gc.getFontMetrics().getDescent();
        for (String line : lines = text.split("\n")) {
            this.gc.drawString(line, x + this.xOffset, y + height + this.yOffset - descent);
            y += height;
        }
    }

    @Override
    public void drawText(String text, int x, int y, boolean transparent) {
        this.drawText(text, x, y);
    }

    @Override
    public void fillPolygon(int[] polygon) {
        this.switchForegroundBackgroundColors();
        this.gc.fillPolygon(this.getSwingPolygon(polygon));
        this.switchForegroundBackgroundColors();
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        this.switchForegroundBackgroundColors();
        this.gc.fillRect(x + this.xOffset, y + this.yOffset, width, height);
        this.switchForegroundBackgroundColors();
    }

    @Override
    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.fillRectangle(x, y, width, height);
    }

    @Override
    public void fillRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.switchForegroundBackgroundColors();
        this.gc.fillRoundRect(x + this.xOffset, y + this.yOffset, width, height, circleWidth, circleHeight);
        this.switchForegroundBackgroundColors();
    }

    @Override
    public Point getDeviceBounds() {
        return this.area;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, alpha / 255);
        this.gc.setComposite((Composite)alphaComposite);
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setBackground(IGc.EColor color) {
        this.gc.setBackground(this.getColor(color));
    }

    private Color getColor(IGc.EColor color) {
        return switch (color) {
            case IGc.EColor.BACKGROUND -> this.background;
            case IGc.EColor.BLACK -> this.black;
            case IGc.EColor.RED -> this.red;
            case IGc.EColor.YELLOW -> this.yellow;
            case IGc.EColor.GREEN -> this.green;
            case IGc.EColor.BLUE -> this.blue;
            case IGc.EColor.MAGENTA -> this.magenta;
            case IGc.EColor.PURPULE -> this.purpule;
            case IGc.EColor.INDIGO -> this.indigo;
            case IGc.EColor.GRAY -> this.gray;
            case IGc.EColor.LIGHTGRAY -> this.lightGray;
            case IGc.EColor.DARKGRAY -> this.darkGray;
            case IGc.EColor.LIGHTBLUE -> this.lightBlue;
            case IGc.EColor.CRYSTAL -> this.crystal;
            case IGc.EColor.HOP_DEFAULT -> this.hopDefault;
            case IGc.EColor.HOP_TRUE -> this.hopTrue;
            case IGc.EColor.HOP_FALSE -> this.hopFalse;
            case IGc.EColor.DEPRECATED -> this.deprecated;
            default -> null;
        };
    }

    @Override
    public void setFont(IGc.EFont font) {
        switch (font) {
            case GRAPH: {
                this.gc.setFont(this.fontGraph);
                break;
            }
            case NOTE: {
                this.gc.setFont(this.fontNote);
                break;
            }
            case SMALL: {
                this.gc.setFont(this.fontSmall);
                break;
            }
        }
    }

    @Override
    public void setForeground(IGc.EColor color) {
        this.gc.setColor(this.getColor(color));
    }

    @Override
    public void setLineStyle(IGc.ELineStyle lineStyle) {
        this.lineStyle = lineStyle;
        this.gc.setStroke(this.createStroke());
    }

    private Stroke createStroke() {
        float[] fArray;
        switch (this.lineStyle) {
            case SOLID: {
                fArray = null;
                break;
            }
            case DOT: {
                float[] fArray2 = new float[1];
                fArray = fArray2;
                fArray2[0] = 5.0f;
                break;
            }
            case DASHDOT: {
                float[] fArray3 = new float[4];
                fArray3[0] = 10.0f;
                fArray3[1] = 5.0f;
                fArray3[2] = 5.0f;
                fArray = fArray3;
                fArray3[3] = 5.0f;
                break;
            }
            case PARALLEL: {
                float[] fArray4 = new float[4];
                fArray4[0] = 10.0f;
                fArray4[1] = 5.0f;
                fArray4[2] = 10.0f;
                fArray = fArray4;
                fArray4[3] = 5.0f;
                break;
            }
            case DASH: {
                float[] fArray5 = new float[2];
                fArray5[0] = 6.0f;
                fArray = fArray5;
                fArray5[1] = 2.0f;
                break;
            }
            default: {
                throw new RuntimeException("Unhandled line style!");
            }
        }
        float[] dash = fArray;
        return new BasicStroke(this.lineWidth, 0, 0, 2.0f, dash, 0.0f);
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width;
        this.gc.setStroke(this.createStroke());
    }

    @Override
    public void setTransform(float translationX, float translationY, float magnification) {
        AffineTransform transform = (AffineTransform)this.originalTransform.clone();
        transform.translate(translationX, translationY);
        transform.scale(magnification, magnification);
        this.gc.setTransform(transform);
    }

    @Override
    public float getMagnification() {
        return (float)this.gc.getTransform().getScaleX();
    }

    public AffineTransform getTransform() {
        return this.gc.getTransform();
    }

    @Override
    public Point textExtent(String text) {
        String[] lines = text.split(Const.CR);
        int maxWidth = 0;
        for (String line : lines) {
            Rectangle2D bounds = this.gc.getFontMetrics().getStringBounds(line, (Graphics)this.gc);
            if (!(bounds.getWidth() > (double)maxWidth)) continue;
            maxWidth = (int)bounds.getWidth();
        }
        int height = this.gc.getFontMetrics().getHeight() * lines.length;
        return new Point(maxWidth, height);
    }

    @Override
    public void setAntialias(boolean antiAlias) {
        if (antiAlias) {
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            this.gc.setRenderingHints((Map)hints);
        }
    }

    @Override
    public void setBackground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setBackground(color);
    }

    @Override
    public void setForeground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setColor(color);
    }

    private Color getColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    @Override
    public void setFont(String fontName, int fontSize, boolean fontBold, boolean fontItalic) {
        int style = 0;
        if (fontBold) {
            style = 1;
        }
        if (fontItalic) {
            style |= 2;
        }
        Font font = new Font(fontName, style, fontSize);
        this.gc.setFont(font);
    }

    public Object getImage() {
        return null;
    }

    @Override
    public void switchForegroundBackgroundColors() {
        Color fg = this.gc.getColor();
        Color bg = this.gc.getBackground();
        this.gc.setColor(bg);
        this.gc.setBackground(fg);
    }

    @Override
    public Point getArea() {
        return this.area;
    }

    public SvgFile getNativeImage(IGc.EImage image) {
        return switch (image) {
            case IGc.EImage.LOCK -> imageLocked;
            case IGc.EImage.FAILURE -> imageFailure;
            case IGc.EImage.EDIT -> imageEdit;
            case IGc.EImage.TRUE -> imageTrue;
            case IGc.EImage.TRUE_DISABLED -> imageTrueDisabled;
            case IGc.EImage.FALSE -> imageFalse;
            case IGc.EImage.FALSE_DISABLED -> imageFalseDisabled;
            case IGc.EImage.ERROR -> imageError;
            case IGc.EImage.ERROR_DISABLED -> imageErrorDisabled;
            case IGc.EImage.INFO -> imageInfo;
            case IGc.EImage.INFO_DISABLED -> imageInfoDisabled;
            case IGc.EImage.TARGET -> imageTarget;
            case IGc.EImage.TARGET_DISABLED -> imageTargetDisabled;
            case IGc.EImage.INPUT -> imageInput;
            case IGc.EImage.OUTPUT -> imageOutput;
            case IGc.EImage.COPY_ROWS -> imageCopyRows;
            case IGc.EImage.COPY_ROWS_DISABLED -> imageCopyRowsDisabled;
            case IGc.EImage.LOAD_BALANCE -> imageLoadBalance;
            case IGc.EImage.CHECKPOINT -> imageCheckpoint;
            case IGc.EImage.DB -> imageDatabase;
            case IGc.EImage.PARALLEL -> imageParallel;
            case IGc.EImage.PARALLEL_DISABLED -> imageParallelDisabled;
            case IGc.EImage.UNCONDITIONAL -> imageUnconditional;
            case IGc.EImage.UNCONDITIONAL_DISABLED -> imageUnconditionalDisabled;
            case IGc.EImage.BUSY -> imageBusy;
            case IGc.EImage.WAITING -> imageWaiting;
            case IGc.EImage.INJECT -> imageInject;
            case IGc.EImage.ARROW_DEFAULT -> imageArrowDefault;
            case IGc.EImage.ARROW_TRUE -> imageArrowTrue;
            case IGc.EImage.ARROW_FALSE -> imageArrowFalse;
            case IGc.EImage.ARROW_ERROR -> imageArrowError;
            case IGc.EImage.ARROW_DISABLED -> imageArrowDisabled;
            case IGc.EImage.DATA -> imageData;
            default -> null;
        };
    }

    @Override
    public void drawImage(IGc.EImage image, int x, int y, float magnification) throws HopException {
        SvgFile svgFile = this.getNativeImage(image);
        this.drawImage(svgFile, x + this.xOffset, y + this.yOffset, this.miniIconSize, this.miniIconSize, magnification, 0.0);
    }

    @Override
    public void drawImage(IGc.EImage image, int x, int y, float magnification, double angle) throws HopException {
        SvgFile svgFile = this.getNativeImage(image);
        this.drawImage(svgFile, x + this.xOffset - this.miniIconSize / 2, y + this.yOffset - this.miniIconSize / 2, this.miniIconSize, this.miniIconSize, magnification, angle);
    }

    @Override
    public void drawTransformIcon(int x, int y, TransformMeta transformMeta, float magnification) throws HopException {
        SvgFile svgFile;
        if (transformMeta.isMissing()) {
            svgFile = imageMissing;
        } else if (transformMeta.isDeprecated()) {
            svgFile = imageDeprecated;
        } else {
            String transformType = transformMeta.getTransformPluginId();
            svgFile = this.transformImages.get(transformType);
        }
        if (svgFile != null) {
            this.drawImage(svgFile, x + this.xOffset, y + this.xOffset, this.iconSize, this.iconSize, magnification, 0.0);
        }
    }

    @Override
    public void drawActionIcon(int x, int y, ActionMeta actionMeta, float magnification) throws HopException {
        SvgFile svgFile;
        if (actionMeta.isMissing()) {
            svgFile = imageMissing;
        } else if (actionMeta.isDeprecated()) {
            svgFile = imageDeprecated;
        } else {
            String actionType = actionMeta.getAction().getPluginId();
            svgFile = this.actionImages.get(actionType);
        }
        if (svgFile != null) {
            this.drawImage(svgFile, x + this.xOffset, y + this.xOffset, this.iconSize, this.iconSize, magnification, 0.0);
        }
    }

    @Override
    public void drawImage(SvgFile svgFile, int x, int y, int desiredWidth, int desiredHeight, float magnification, double angle) throws HopException {
        try {
            SvgCacheEntry cacheEntry = SvgCache.loadSvg((SvgFile)svgFile);
            SVGDocument svgDocument = cacheEntry.getSvgDocument();
            float xScaleFactor = magnification * (float)desiredWidth / cacheEntry.getWidth();
            float yScaleFactor = magnification * (float)desiredHeight / cacheEntry.getHeight();
            xScaleFactor = Math.min(xScaleFactor, yScaleFactor);
            yScaleFactor = Math.min(xScaleFactor, yScaleFactor);
            this.gc.embedSvg((Node)svgDocument.getRootElement(), svgFile.getFilename(), x - cacheEntry.getX(), y - cacheEntry.getY(), cacheEntry.getWidth(), cacheEntry.getHeight(), xScaleFactor, yScaleFactor, Math.toDegrees(angle));
        }
        catch (Exception e) {
            throw new HopException("Unable to load SVG file '" + svgFile.getFilename() + "'", (Throwable)e);
        }
    }

    private void copyChildren(Document domFactory, Node target, Node svgImage) {
        NodeList childNodes = svgImage.getChildNodes();
        block10: for (int c = 0; c < childNodes.getLength(); ++c) {
            Node childNode = childNodes.item(c);
            switch (childNode.getNodeName()) {
                case "metadata": {
                    continue block10;
                }
                case "defs": {
                    continue block10;
                }
                case "sodipodi:namedview": {
                    continue block10;
                }
                default: {
                    Node childNodeCopy = domFactory.importNode(childNode, true);
                    target.appendChild(childNodeCopy);
                }
            }
        }
    }
}

