/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.beam.sdk.util.GcpHsmGeneratedSecret;
import org.apache.beam.sdk.util.GcpSecret;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface Secret
extends Serializable {
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getSecretBytes();

    public static @UnknownKeyFor @NonNull @Initialized Secret parseSecretOption(@UnknownKeyFor @NonNull @Initialized String secretOption) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String param : secretOption.split(";", -1)) {
            String[] parts = param.split(":", 2);
            if (parts.length != 2) continue;
            paramMap.put(parts[0], parts[1]);
        }
        if (!paramMap.containsKey("type")) {
            throw new RuntimeException("Secret string must contain a valid type parameter");
        }
        String secretType = (String)paramMap.get("type");
        paramMap.remove("type");
        if (secretType == null) {
            throw new RuntimeException("Secret string must contain a valid value for type parameter");
        }
        switch (secretType.toLowerCase()) {
            case "gcpsecret": {
                HashSet<String> gcpSecretParams = new HashSet<String>(Arrays.asList("version_name"));
                for (String paramName : paramMap.keySet()) {
                    if (gcpSecretParams.contains(paramName)) continue;
                    throw new RuntimeException(String.format("Invalid secret parameter %s, GcpSecret only supports the following parameters: %s", paramName, gcpSecretParams));
                }
                String versionName = (String)Preconditions.checkNotNull((Object)((String)paramMap.get("version_name")), (Object)"version_name must contain a valid value for versionName parameter");
                return new GcpSecret(versionName);
            }
            case "gcphsmgeneratedsecret": {
                HashSet<String> gcpHsmGeneratedSecretParams = new HashSet<String>(Arrays.asList("project_id", "location_id", "key_ring_id", "key_id", "job_name"));
                for (String paramName : paramMap.keySet()) {
                    if (gcpHsmGeneratedSecretParams.contains(paramName)) continue;
                    throw new RuntimeException(String.format("Invalid secret parameter %s, GcpHsmGeneratedSecret only supports the following parameters: %s", paramName, gcpHsmGeneratedSecretParams));
                }
                String projectId = (String)Preconditions.checkNotNull((Object)((String)paramMap.get("project_id")), (Object)"project_id must contain a valid value for projectId parameter");
                String locationId = (String)Preconditions.checkNotNull((Object)((String)paramMap.get("location_id")), (Object)"location_id must contain a valid value for locationId parameter");
                String keyRingId = (String)Preconditions.checkNotNull((Object)((String)paramMap.get("key_ring_id")), (Object)"key_ring_id must contain a valid value for keyRingId parameter");
                String keyId = (String)Preconditions.checkNotNull((Object)((String)paramMap.get("key_id")), (Object)"key_id must contain a valid value for keyId parameter");
                String jobName = (String)Preconditions.checkNotNull((Object)((String)paramMap.get("job_name")), (Object)"job_name must contain a valid value for jobName parameter");
                return new GcpHsmGeneratedSecret(projectId, locationId, keyRingId, keyId, jobName);
            }
        }
        throw new RuntimeException(String.format("Invalid secret type %s, currently only GcpSecret and GcpHsmGeneratedSecret are supported", secretType));
    }
}

