/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.time.Instant;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Timestamp
implements Schema.LogicalType<Instant, Row> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:logical_type:timestamp:v1";
    static final @UnknownKeyFor @NonNull @Initialized int MIN_PRECISION = 0;
    static final @UnknownKeyFor @NonNull @Initialized int MAX_PRECISION = 9;
    private final @UnknownKeyFor @NonNull @Initialized int precision;
    private final @UnknownKeyFor @NonNull @Initialized int scalingFactor;
    private final @UnknownKeyFor @NonNull @Initialized Schema timestampSchema;
    public static final @UnknownKeyFor @NonNull @Initialized Timestamp MILLIS = Timestamp.of(3);
    public static final @UnknownKeyFor @NonNull @Initialized Timestamp MICROS = Timestamp.of(6);
    public static final @UnknownKeyFor @NonNull @Initialized Timestamp NANOS = Timestamp.of(9);

    public static @UnknownKeyFor @NonNull @Initialized Timestamp of(@UnknownKeyFor @NonNull @Initialized int precision) {
        return new Timestamp(precision);
    }

    public Timestamp(@UnknownKeyFor @NonNull @Initialized int precision) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((precision <= 9 && precision >= 0 ? 1 : 0) != 0, (String)"Timestamp precision must be between %s and %s (inclusive), but was %s.", (Object)0, (Object)9, (Object)precision);
        this.precision = precision;
        this.scalingFactor = (int)Math.pow(10.0, 9 - precision);
        this.timestampSchema = precision < 5 ? Schema.builder().addInt64Field("seconds").addInt16Field("subseconds").build() : Schema.builder().addInt64Field("seconds").addInt32Field("subseconds").build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getArgumentType() {
        return Schema.FieldType.INT32;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Integer getArgument() {
        return this.precision;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
        return Schema.FieldType.row(this.timestampSchema);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Row toBaseType(@UnknownKeyFor @NonNull @Initialized Instant input) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((input.getNano() % this.scalingFactor == 0 ? 1 : 0) != 0, (String)"Timestamp logical type was configured with precision %s, but encountered a Java Instant with %s nanoseconds (not evenly divisible by scaling factor %s).", (Object)this.precision, (Object)input.getNano(), (Object)this.scalingFactor);
        int subseconds = input.getNano() / this.scalingFactor;
        Row.Builder rowBuilder = Row.withSchema(this.timestampSchema).addValue(input.getEpochSecond());
        if (this.precision < 5) {
            rowBuilder.addValue((short)subseconds);
        } else {
            rowBuilder.addValue(subseconds);
        }
        return rowBuilder.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant toInputType(@NonNull @UnknownKeyFor @Initialized Row base) {
        long subseconds = this.precision < 5 ? (long)Preconditions.checkArgumentNotNull(base.getInt16(1), "While trying to convert to Instant: Row missing subseconds field").shortValue() : (long)Preconditions.checkArgumentNotNull(base.getInt32(1), "While trying to convert to Instant: Row missing subseconds field").intValue();
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((subseconds >= 0L ? 1 : 0) != 0, (String)"While trying to convert to Instant: subseconds field must be non-negative, but was %s. This likely indicates data corruption.", (long)subseconds);
        int maxSubseconds = (int)(Math.pow(10.0, this.precision) - 1.0);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((subseconds <= (long)maxSubseconds ? 1 : 0) != 0, (String)"While trying to convert to Instant: subseconds field must be <= %s for precision %s, but was %s. This likely indicates data corruption or precision mismatch.", (Object)maxSubseconds, (Object)this.precision, (Object)subseconds);
        return Instant.ofEpochSecond(Preconditions.checkArgumentNotNull(base.getInt64(0), "While trying to convert to Instant: Row missing seconds field"), subseconds * (long)this.scalingFactor);
    }
}

