/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.multimerge;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.multimerge.MultiMergeJoin;
import org.apache.hop.pipeline.transforms.multimerge.MultiMergeJoinData;
import org.w3c.dom.Node;

@Transform(id="MultiwayMergeJoin", image="multimergejoin.svg", name="i18n::MultiwayMergeJoin.Name", description="i18n::MultiwayMergeJoin.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Joins", keywords={"i18n::MultiMergeJoinMeta.keyword"}, documentationUrl="/pipeline/transforms/multimerge.html")
public class MultiMergeJoinMeta
extends BaseTransformMeta<MultiMergeJoin, MultiMergeJoinData> {
    private static final Class<?> PKG = MultiMergeJoinMeta.class;
    public static final String[] joinTypes = new String[]{"INNER", "FULL OUTER"};
    public static final boolean[] optionals = new boolean[]{false, true};
    @HopMetadataProperty(key="join_type", injectionKey="JOIN_TYPE", injectionKeyDescription="MultiMergeJoinMeta.Injection.JoinType")
    private String joinType;
    @HopMetadataProperty(key="key", groupKey="keys", injectionKey="KEY_FIELDS")
    private List<String> keyFields = new ArrayList<String>();
    @HopMetadataProperty(key="transform", groupKey="transforms", injectionKey="INPUT_TRANSFORMS")
    private List<String> inputTransforms = new ArrayList<String>();

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Deprecated(since="2.17")
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        this.readData(transformNode);
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            String numInputStreamsStr = XmlHandler.getTagValue((Node)transformNode, (String)"number_input");
            if (numInputStreamsStr == null || numInputStreamsStr.trim().isEmpty()) {
                return;
            }
            int nInputStreams = Integer.parseInt(numInputStreamsStr);
            for (int i = 0; i < nInputStreams; ++i) {
                this.inputTransforms.add(XmlHandler.getTagValue((Node)transformNode, (String)("transform" + i)));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.joinType = joinTypes[0];
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        ITransformIOMeta ioMeta = this.getTransformIOMeta();
        ioMeta.getInfoStreams().clear();
        for (int i = 0; i < this.inputTransforms.size(); ++i) {
            String inputTransformName = this.inputTransforms.get(i);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, TransformMeta.findTransform(transforms, (String)inputTransformName), BaseMessages.getString(PKG, (String)"MultiMergeJoin.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, inputTransformName));
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.CheckResult.TransformNotVerified", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (info != null) {
            for (IRowMeta iRowMeta : info) {
                if (iRowMeta == null) continue;
                r.mergeRowMeta(iRowMeta);
            }
        }
        for (int i = 0; i < r.size(); ++i) {
            r.getValueMeta(i).setOrigin(name);
        }
    }

    public void resetTransformIoMeta() {
    }

    public boolean cleanAfterHopToRemove(TransformMeta fromTransform) {
        if (fromTransform == null || fromTransform.getName() == null) {
            return false;
        }
        if (this.inputTransforms == null || this.inputTransforms.isEmpty()) {
            return false;
        }
        String fromTransformName = fromTransform.getName();
        for (int i = 0; i < this.inputTransforms.size(); ++i) {
            if (!fromTransformName.equals(this.inputTransforms.get(i))) continue;
            this.inputTransforms.remove(i);
            if (this.keyFields != null && i < this.keyFields.size()) {
                this.keyFields.remove(i);
            }
            return true;
        }
        return false;
    }

    @Generated
    public String getJoinType() {
        return this.joinType;
    }

    @Generated
    public List<String> getKeyFields() {
        return this.keyFields;
    }

    @Generated
    public List<String> getInputTransforms() {
        return this.inputTransforms;
    }

    @Generated
    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    @Generated
    public void setKeyFields(List<String> keyFields) {
        this.keyFields = keyFields;
    }

    @Generated
    public void setInputTransforms(List<String> inputTransforms) {
        this.inputTransforms = inputTransforms;
    }
}

