/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git.info;

import org.apache.hop.core.variables.IVariables;
import org.apache.hop.ui.core.widget.StyledTextVar;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DiffStyledTextComp
extends StyledTextVar {
    private static final Color COLOR_ADDITION = new Color((Device)Display.getDefault(), 0, 128, 0);
    private static final Color COLOR_DELETION = new Color((Device)Display.getDefault(), 255, 0, 0);
    private static final Color COLOR_FILE_HEADER = new Color((Device)Display.getDefault(), 0, 128, 128);
    private static final Color COLOR_HUNK_HEADER = new Color((Device)Display.getDefault(), 153, 102, 0);

    public DiffStyledTextComp(IVariables variables, Composite parent, int style) {
        super(variables, parent, style, false, false);
        this.getTextWidget().setEditable(false);
    }

    public void setDiffText(String diffText) {
        if (diffText == null || diffText.isEmpty()) {
            this.setText("");
            return;
        }
        this.setText(diffText);
        this.applyDiffHighlighting();
    }

    private void applyDiffHighlighting() {
        StyledText styledText = this.getTextWidget();
        String text = styledText.getText();
        if (text.isEmpty()) {
            return;
        }
        String[] lines = text.split("\n", -1);
        int offset = 0;
        for (String line : lines) {
            int lineLength = line.length();
            StyleRange styleRange = null;
            if (line.startsWith("+")) {
                styleRange = new StyleRange(offset, lineLength, COLOR_ADDITION, null);
            } else if (line.startsWith("-")) {
                styleRange = new StyleRange(offset, lineLength, COLOR_DELETION, null);
            } else if (line.startsWith("diff --git") || line.startsWith("+++") || line.startsWith("---") || line.startsWith("index ") || line.startsWith("new file") || line.startsWith("deleted file") || line.startsWith("similarity index") || line.startsWith("rename from") || line.startsWith("rename to")) {
                styleRange = new StyleRange(offset, lineLength, COLOR_FILE_HEADER, null);
                if (line.startsWith("+++") || line.startsWith("---")) {
                    styleRange.fontStyle = 1;
                }
            } else if (line.startsWith("@@")) {
                styleRange = new StyleRange(offset, lineLength, COLOR_HUNK_HEADER, null);
                styleRange.fontStyle = 1;
            }
            if (styleRange != null) {
                styledText.setStyleRange(styleRange);
            }
            offset += lineLength + 1;
        }
    }

    public void dispose() {
        super.dispose();
    }
}

