/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git.config;

import lombok.Generated;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.git.config.GitConfig;
import org.apache.hop.git.config.GitConfigSingleton;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="GitConfigOptionPlugin", description="Configuration options for the git GUI plugin")
@GuiPlugin(description="i18n::GitConfig.Tab.Name")
public class GitConfigOptionPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    protected static final Class<?> PKG = GitConfigOptionPlugin.class;
    private static final String WIDGET_ID_GIT_ENABLE = "10000-git-enable-plugin";
    private static final String WIDGET_ID_GIT_SEARCH_PARENT_FOLDERS = "10010-git-search-parent-folders";
    @GuiWidgetElement(id="10000-git-enable-plugin", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, label="i18n::GitConfig.EnableGitPlugin.Message")
    @CommandLine.Option(names={"--git-gui-enabled"}, description={"Enable or disable the git GUI plugin"})
    private Boolean gitEnabled;
    @GuiWidgetElement(id="10010-git-search-parent-folders", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, label="i18n::GitConfig.SearchParentFolders.Message")
    @CommandLine.Option(names={"--git-gui-search-parent-folders"}, description={"The git GUI searches the parent folders for a repository"})
    private Boolean searchingParentFolders;

    public static GitConfigOptionPlugin getInstance() {
        GitConfigOptionPlugin instance = new GitConfigOptionPlugin();
        GitConfig config = GitConfigSingleton.getConfig();
        instance.gitEnabled = config.isEnabled();
        instance.searchingParentFolders = config.isSearchingParentFolders();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        GitConfig config = GitConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.gitEnabled != null) {
                config.setEnabled(this.gitEnabled);
                if (this.gitEnabled.booleanValue()) {
                    log.logBasic("Enabled the git GUI plugin");
                } else {
                    log.logBasic("Disabled the git GUI plugin");
                }
                changed = true;
            }
            if (this.searchingParentFolders != null) {
                config.setSearchingParentFolders(this.searchingParentFolders);
                if (this.searchingParentFolders.booleanValue()) {
                    log.logBasic("The git GUI plugin is searching parent folders for a repository.");
                } else {
                    log.logBasic("The git GUI plugin only looks at the project home folder for a repository.");
                }
                changed = true;
            }
            if (changed) {
                GitConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling git plugin configuration options", (Throwable)e);
        }
    }

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-git-enable-plugin": {
                    this.gitEnabled = ((Button)control).getSelection();
                    GitConfigSingleton.getConfig().setEnabled(this.gitEnabled);
                    break;
                }
                case "10010-git-search-parent-folders": {
                    this.searchingParentFolders = ((Button)control).getSelection();
                    GitConfigSingleton.getConfig().setSearchingParentFolders(this.searchingParentFolders);
                    break;
                }
            }
        }
        try {
            GitConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitConfig.SavingOption.ErrorDialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitConfig.SavingOption.ErrorDialog.Message", (String[])new String[0]), e);
        }
    }

    @Generated
    public Boolean getGitEnabled() {
        return this.gitEnabled;
    }

    @Generated
    public Boolean getSearchingParentFolders() {
        return this.searchingParentFolders;
    }

    @Generated
    public void setGitEnabled(Boolean gitEnabled) {
        this.gitEnabled = gitEnabled;
    }

    @Generated
    public void setSearchingParentFolders(Boolean searchingParentFolders) {
        this.searchingParentFolders = searchingParentFolders;
    }
}

