/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.git.HopDiff;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.workflow.WorkflowPainterExtension;

@ExtensionPoint(id="DrawDiffOnWorkflowHopExtensionPoint", description="Draws a marker on top of a workflow hop if it has added or removed", extensionPointId="WorkflowPainterArrow")
public class DrawDiffOnWorkflowHopExtensionPoint
implements IExtensionPoint<WorkflowPainterExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, WorkflowPainterExtension ext) throws HopException {
        IGc gc = ext.gc;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Map gitHops = ext.workflowMeta.getAttributes("GitHops");
            if (gitHops == null) {
                return;
            }
            for (String hopName : gitHops.keySet()) {
                String workflowHopName = HopDiff.getWorkflowHopName(ext.workflowHop);
                if (ext.workflowHop == null || !workflowHopName.equals(hopName)) continue;
                SvgFile svgFile = null;
                String status = (String)gitHops.get(hopName);
                if (status == null) continue;
                switch (status) {
                    case "ADDED": {
                        svgFile = new SvgFile("added.svg", classLoader);
                        break;
                    }
                    case "REMOVED": {
                        svgFile = new SvgFile("removed.svg", classLoader);
                        break;
                    }
                    case "CHANGED": {
                        svgFile = new SvgFile("CHANGED.svg", classLoader);
                        break;
                    }
                }
                if (svgFile == null) continue;
                Point fr = ext.workflowHop.getFromAction().getLocation();
                Point to = ext.workflowHop.getToAction().getLocation();
                int iconSize = 32;
                try {
                    iconSize = PropsUi.getInstance().getIconSize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int x = (int)ext.offset.x + (fr.x + to.x) / 2 + iconSize / 4;
                int y = (int)ext.offset.y + (fr.y + to.y) / 2 + iconSize / 4;
                gc.drawImage(svgFile, x, y, iconSize / 2, iconSize / 2, gc.getMagnification(), 0.0);
            }
        }
        catch (Exception e) {
            throw new HopException("Error drawing status on workflow hop", (Throwable)e);
        }
    }
}

